/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.notificationservice.persistence.model;

import de.justsoftware.notificationservice.model.NotificationStatus;
import de.justsoftware.notificationservice.persistence.model.DbAuditModel;
import de.justsoftware.notificationservice.persistence.model.DbDeliveryStatusId;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import jakarta.persistence.Id;
import jakarta.persistence.IdClass;
import jakarta.persistence.Table;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

@Entity
@Table(name="DeliveryStatus")
@ParametersAreNonnullByDefault
@IdClass(value=DbDeliveryStatusId.class)
public class DbDeliveryStatus
extends DbAuditModel {
    private static final long serialVersionUID = 1L;
    private UUID _notificationId;
    private String _receiverId;
    private NotificationStatus _status;
    private boolean _shouldTriggerMail;
    private boolean _marked;

    @Deprecated
    public DbDeliveryStatus() {
    }

    public DbDeliveryStatus(UUID notificationId, String receiverId, NotificationStatus status, boolean shouldTriggerMail, boolean marked) {
        this._notificationId = notificationId;
        this._receiverId = receiverId;
        this._status = status;
        this._shouldTriggerMail = shouldTriggerMail;
        this._marked = marked;
    }

    public DbDeliveryStatus(UUID notificationId, String receiverId, NotificationStatus status) {
        this._notificationId = notificationId;
        this._receiverId = receiverId;
        this._status = status;
        this._shouldTriggerMail = true;
        this._marked = false;
    }

    @Id
    @Nonnull
    public UUID getNotificationId() {
        return this._notificationId;
    }

    public void setNotificationId(UUID notificationId) {
        this._notificationId = notificationId;
    }

    @Id
    @Nonnull
    public String getReceiverId() {
        return this._receiverId;
    }

    public void setReceiverId(String receiverId) {
        this._receiverId = receiverId;
    }

    @Nonnull
    @Enumerated(value=EnumType.STRING)
    @Column(nullable=false)
    public NotificationStatus getStatus() {
        return this._status;
    }

    public void setStatus(NotificationStatus status) {
        this._status = status;
    }

    public boolean isShouldTriggerMail() {
        return this._shouldTriggerMail;
    }

    public void setShouldTriggerMail(boolean shouldTriggerMail) {
        this._shouldTriggerMail = shouldTriggerMail;
    }

    @Column(nullable=false)
    public boolean isMarked() {
        return this._marked;
    }

    public void setMarked(boolean marked) {
        this._marked = marked;
    }
}

