/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.wikiservice.graphql;

import com.fasterxml.jackson.databind.ObjectMapper;
import de.justsoftware.jwtfilter.JwtAuthenticationToken;
import de.justsoftware.wikiservice.authorization.AuthContext;
import de.justsoftware.wikiservice.authorization.AuthorizationService;
import de.justsoftware.wikiservice.business.WikiService;
import de.justsoftware.wikiservice.business.exceptions.NotAllowedException;
import de.justsoftware.wikiservice.graphql.AuthenticatedGraphQLContext;
import de.justsoftware.wikiservice.graphql.AuthenticatedGraphQLContextBuilder;
import de.justsoftware.wikiservice.graphql.dataloader.DataLoaderFactory;
import graphql.kickstart.execution.context.GraphQLKickstartContext;
import graphql.kickstart.servlet.context.DefaultGraphQLServletContextBuilder;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.dataloader.DataLoaderRegistry;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.oauth2.core.OAuth2AccessToken;
import org.springframework.security.oauth2.server.resource.authentication.BearerTokenAuthentication;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

/*
 * Exception performing whole class analysis ignored.
 */
@Component
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0017\u0018\u0000 \u001d2\u00020\u0001:\u0001\u001dBG\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0014\u0010\u0006\u001a\u0010\u0012\f\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\b0\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\b\b\u0002\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0002\u0010\u000fJ\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0012J\u0018\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u001b*\u00020\u001cH\u0012R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0006\u001a\u0010\u0012\f\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\b0\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lde/justsoftware/wikiservice/graphql/AuthenticatedGraphQLContextBuilder;", "Lgraphql/kickstart/servlet/context/DefaultGraphQLServletContextBuilder;", "toroBaseUrl", "", "authorizationService", "Lde/justsoftware/wikiservice/authorization/AuthorizationService;", "dataLoaderFactories", "", "Lde/justsoftware/wikiservice/graphql/dataloader/DataLoaderFactory;", "wikiService", "Lde/justsoftware/wikiservice/business/WikiService;", "objectMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "rest", "Lorg/springframework/web/client/RestTemplate;", "(Ljava/lang/String;Lde/justsoftware/wikiservice/authorization/AuthorizationService;Ljava/util/List;Lde/justsoftware/wikiservice/business/WikiService;Lcom/fasterxml/jackson/databind/ObjectMapper;Lorg/springframework/web/client/RestTemplate;)V", "build", "Lgraphql/kickstart/execution/context/GraphQLKickstartContext;", "httpServletRequest", "Ljakarta/servlet/http/HttpServletRequest;", "httpServletResponse", "Ljakarta/servlet/http/HttpServletResponse;", "buildDataLoaderRegistry", "Lorg/dataloader/DataLoaderRegistry;", "authContext", "Lde/justsoftware/wikiservice/authorization/AuthContext;", "getCurrentPersonInfo", "", "Lorg/springframework/security/oauth2/server/resource/authentication/BearerTokenAuthentication;", "Companion", "wiki-service"})
@SourceDebugExtension(value={"SMAP\nAuthenticatedGraphQLContextBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AuthenticatedGraphQLContextBuilder.kt\nde/justsoftware/wikiservice/graphql/AuthenticatedGraphQLContextBuilder\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,151:1\n1855#2,2:152\n1238#2,4:156\n1238#2,4:162\n468#3:154\n414#3:155\n453#3:160\n403#3:161\n*S KotlinDebug\n*F\n+ 1 AuthenticatedGraphQLContextBuilder.kt\nde/justsoftware/wikiservice/graphql/AuthenticatedGraphQLContextBuilder\n*L\n78#1:152,2\n104#1:156,4\n105#1:162,4\n104#1:154\n104#1:155\n105#1:160\n105#1:161\n*E\n"})
public class AuthenticatedGraphQLContextBuilder
extends DefaultGraphQLServletContextBuilder {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String toroBaseUrl;
    @NotNull
    private final AuthorizationService authorizationService;
    @NotNull
    private final List<DataLoaderFactory<?, ?>> dataLoaderFactories;
    @NotNull
    private final WikiService wikiService;
    @NotNull
    private final ObjectMapper objectMapper;
    @NotNull
    private final RestTemplate rest;
    private static final Logger LOG = LoggerFactory.getLogger(AuthenticatedGraphQLContextBuilder.class);

    public AuthenticatedGraphQLContextBuilder(@Value(value="${just.wiki.toro.internal.baseurl}") @NotNull String toroBaseUrl, @NotNull AuthorizationService authorizationService, @NotNull List<? extends DataLoaderFactory<?, ?>> dataLoaderFactories, @NotNull WikiService wikiService, @NotNull ObjectMapper objectMapper, @NotNull RestTemplate rest) {
        Intrinsics.checkNotNullParameter((Object)toroBaseUrl, (String)"toroBaseUrl");
        Intrinsics.checkNotNullParameter((Object)authorizationService, (String)"authorizationService");
        Intrinsics.checkNotNullParameter(dataLoaderFactories, (String)"dataLoaderFactories");
        Intrinsics.checkNotNullParameter((Object)wikiService, (String)"wikiService");
        Intrinsics.checkNotNullParameter((Object)objectMapper, (String)"objectMapper");
        Intrinsics.checkNotNullParameter((Object)rest, (String)"rest");
        this.toroBaseUrl = toroBaseUrl;
        this.authorizationService = authorizationService;
        this.dataLoaderFactories = dataLoaderFactories;
        this.wikiService = wikiService;
        this.objectMapper = objectMapper;
        this.rest = rest;
    }

    public /* synthetic */ AuthenticatedGraphQLContextBuilder(String string, AuthorizationService authorizationService, List list, WikiService wikiService, ObjectMapper objectMapper, RestTemplate restTemplate, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x20) != 0) {
            restTemplate = new RestTemplate();
        }
        this(string, authorizationService, list, wikiService, objectMapper, restTemplate);
    }

    @NotNull
    public GraphQLKickstartContext build(@NotNull HttpServletRequest httpServletRequest, @NotNull HttpServletResponse httpServletResponse) {
        AuthContext authContext;
        Intrinsics.checkNotNullParameter((Object)httpServletRequest, (String)"httpServletRequest");
        Intrinsics.checkNotNullParameter((Object)httpServletResponse, (String)"httpServletResponse");
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        if (authentication == null) {
            throw new NotAllowedException("You must be logged in to perform this request");
        }
        Authentication authentication2 = authentication;
        Authentication authentication3 = authentication2;
        if (authentication3 instanceof JwtAuthenticationToken) {
            authContext = new AuthContext(Companion.access$getProfileId((Companion)Companion, (JwtAuthenticationToken)((JwtAuthenticationToken)authentication2)), Companion.access$getTenantId((Companion)Companion, (JwtAuthenticationToken)((JwtAuthenticationToken)authentication2)), this.authorizationService, this.wikiService);
        } else if (authentication3 instanceof BearerTokenAuthentication) {
            Map currentPersonInfo = this.getCurrentPersonInfo((BearerTokenAuthentication)authentication2);
            authContext = new AuthContext(Companion.access$getProfileId((Companion)Companion, (Map)currentPersonInfo), Companion.access$getTenantId((Companion)Companion, (Map)currentPersonInfo), this.authorizationService, this.wikiService);
        } else {
            LOG.warn("We received an unknown type of authentication: " + authentication2.getClass().getName());
            throw new NotAllowedException("An error occurred authorizing your request.");
        }
        AuthContext authContext2 = authContext;
        return (GraphQLKickstartContext)new AuthenticatedGraphQLContext(authContext2, this.buildDataLoaderRegistry(authContext2));
    }

    private DataLoaderRegistry buildDataLoaderRegistry(AuthContext authContext) {
        DataLoaderRegistry dataLoaderRegistry;
        DataLoaderRegistry $this$buildDataLoaderRegistry_u24lambda_u241 = dataLoaderRegistry = new DataLoaderRegistry();
        boolean bl = false;
        Iterable $this$forEach$iv = this.dataLoaderFactories;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            DataLoaderFactory factory = (DataLoaderFactory)element$iv;
            boolean bl2 = false;
            $this$buildDataLoaderRegistry_u24lambda_u241.register(factory.getName().name(), factory.create(authContext));
        }
        return dataLoaderRegistry;
    }

    /*
     * WARNING - void declaration
     */
    private Map<String, String> getCurrentPersonInfo(BearerTokenAuthentication $this$getCurrentPersonInfo) {
        void $this$mapValuesTo$iv$iv;
        void $this$mapValues$iv;
        Object object;
        Object it;
        Map map;
        void $this$mapKeysTo$iv$iv;
        Map $this$mapKeys$iv;
        HttpHeaders headers = new HttpHeaders();
        headers.add("Authorization", "Bearer " + ((OAuth2AccessToken)$this$getCurrentPersonInfo.getToken()).getTokenValue());
        HttpEntity request = new HttpEntity((MultiValueMap)headers);
        ResponseEntity response = this.rest.exchange(this.toroBaseUrl + "/api/v1/person/current", HttpMethod.GET, request, String.class, new Object[0]);
        boolean bl = false;
        if (response.getStatusCode() != HttpStatus.OK) {
            LOG.warn("Failed to retrieve person info from toro internal API: " + response.getStatusCode());
            throw new NotAllowedException("An error occurred authorizing your request.");
        }
        Object object2 = this.objectMapper.readValue((String)response.getBody(), Map.class);
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"readValue(...)");
        Map map2 = (Map)object2;
        boolean $i$f$mapKeys = false;
        void var8_8 = $this$mapKeys$iv;
        Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapKeys$iv.size()));
        boolean $i$f$mapKeysTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapKeysTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void it$iv$iv;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            map = destination$iv$iv;
            boolean bl2 = false;
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            object = String.valueOf(it.getKey());
            Map map3 = map;
            boolean bl3 = false;
            it = it$iv$iv.getValue();
            map3.put(object, it);
        }
        $this$mapKeys$iv = destination$iv$iv;
        boolean $i$f$mapValues = false;
        $this$mapKeysTo$iv$iv = $this$mapValues$iv;
        destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void it2;
            void it$iv$iv;
            it = (Map.Entry)element$iv$iv$iv;
            Map map4 = destination$iv$iv;
            boolean bl4 = false;
            object = (Map.Entry)element$iv$iv$iv;
            Object k = it$iv$iv.getKey();
            map = map4;
            boolean bl5 = false;
            String string = String.valueOf(it2.getValue());
            map.put(k, string);
        }
        return destination$iv$iv;
    }

    public static final /* synthetic */ Logger access$getLOG$cp() {
        return LOG;
    }
}

