/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.wikiservice.business;

import de.justsoftware.permission.client.model.Role;
import de.justsoftware.wikiservice.business.model.SubscriptionDto;
import de.justsoftware.wikiservice.model.ArticleId;
import de.justsoftware.wikiservice.model.ChapterId;
import de.justsoftware.wikiservice.model.GranteeId;
import de.justsoftware.wikiservice.model.ItemId;
import de.justsoftware.wikiservice.model.ProfileId;
import de.justsoftware.wikiservice.model.WikiId;
import de.justsoftware.wikiservice.persistence.SubscriptionRepository;
import de.justsoftware.wikiservice.persistence.model.Subscription;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u000f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0012J\u0018\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0018\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\t\u001a\u00020\nH\u0016J8\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00060\u00122\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00130\u00152\u0006\u0010\t\u001a\u00020\n2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00170\u0015H\u0016J \u0010\u0018\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0019\u001a\u00020\u001aH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lde/justsoftware/wikiservice/business/SubscriptionService;", "", "subscriptionRepository", "Lde/justsoftware/wikiservice/persistence/SubscriptionRepository;", "(Lde/justsoftware/wikiservice/persistence/SubscriptionRepository;)V", "read", "Lde/justsoftware/wikiservice/business/model/SubscriptionDto;", "itemId", "Lde/justsoftware/wikiservice/model/ItemId;", "subscriber", "Lde/justsoftware/wikiservice/model/ProfileId;", "readArticle", "articleId", "Lde/justsoftware/wikiservice/model/ArticleId;", "readChapter", "chapterId", "Lde/justsoftware/wikiservice/model/ChapterId;", "readWikis", "", "Lde/justsoftware/wikiservice/model/WikiId;", "wikiIds", "", "subscriberRoles", "Lde/justsoftware/permission/client/model/Role;", "setSubscription", "isSubscribed", "", "wiki-service"})
@SourceDebugExtension(value={"SMAP\nSubscriptionService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SubscriptionService.kt\nde/justsoftware/wikiservice/business/SubscriptionService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,72:1\n1549#2:73\n1620#2,3:74\n1549#2:77\n1620#2,3:78\n1271#2,2:81\n1285#2,4:83\n1238#2,4:89\n453#3:87\n403#3:88\n*S KotlinDebug\n*F\n+ 1 SubscriptionService.kt\nde/justsoftware/wikiservice/business/SubscriptionService\n*L\n46#1:73\n46#1:74,3\n53#1:77\n53#1:78,3\n56#1:81,2\n56#1:83,4\n60#1:89,4\n60#1:87\n60#1:88\n*E\n"})
public class SubscriptionService {
    @NotNull
    private final SubscriptionRepository subscriptionRepository;

    @Autowired
    public SubscriptionService(@NotNull SubscriptionRepository subscriptionRepository) {
        Intrinsics.checkNotNullParameter((Object)subscriptionRepository, (String)"subscriptionRepository");
        this.subscriptionRepository = subscriptionRepository;
    }

    @NotNull
    public SubscriptionDto setSubscription(@NotNull ItemId itemId, @NotNull ProfileId subscriber, boolean isSubscribed) {
        Intrinsics.checkNotNullParameter((Object)itemId, (String)"itemId");
        Intrinsics.checkNotNullParameter((Object)subscriber, (String)"subscriber");
        Subscription subscription = new Subscription(subscriber, itemId, isSubscribed);
        Object object = this.subscriptionRepository.save((Object)subscription);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"save(...)");
        return SubscriptionDto.Companion.toDto((Subscription)object);
    }

    @NotNull
    public SubscriptionDto readArticle(@NotNull ArticleId articleId, @NotNull ProfileId subscriber) {
        Intrinsics.checkNotNullParameter((Object)articleId, (String)"articleId");
        Intrinsics.checkNotNullParameter((Object)subscriber, (String)"subscriber");
        return this.read((ItemId)articleId, subscriber);
    }

    @NotNull
    public SubscriptionDto readChapter(@NotNull ChapterId chapterId, @NotNull ProfileId subscriber) {
        Intrinsics.checkNotNullParameter((Object)chapterId, (String)"chapterId");
        Intrinsics.checkNotNullParameter((Object)subscriber, (String)"subscriber");
        return this.read((ItemId)chapterId, subscriber);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Map<WikiId, SubscriptionDto> readWikis(@NotNull Set<WikiId> wikiIds, @NotNull ProfileId subscriber, @NotNull Set<Role> subscriberRoles) {
        void $this$mapValuesTo$iv$iv;
        void $this$mapValues$iv;
        Subscription subscription;
        Object subscription2;
        Object object;
        Object object2;
        Collection<UUID> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Object object3;
        void $this$mapTo$iv$iv2;
        void $this$map$iv2;
        Intrinsics.checkNotNullParameter(wikiIds, (String)"wikiIds");
        Intrinsics.checkNotNullParameter((Object)subscriber, (String)"subscriber");
        Intrinsics.checkNotNullParameter(subscriberRoles, (String)"subscriberRoles");
        Iterable iterable = subscriberRoles;
        boolean $i$f$map22 = false;
        void var7_7 = $this$map$iv2;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            void r;
            Role role = (Role)item$iv$iv;
            object3 = destination$iv$iv;
            boolean bl = false;
            object3.add(GranteeId.Companion.toGranteeId((Role)r));
        }
        Set granteeIds = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        Iterable $i$f$map22 = wikiIds;
        Set<WikiId> set = wikiIds;
        Set set2 = granteeIds;
        long l = subscriber.getId();
        object3 = this.subscriptionRepository;
        boolean $i$f$map = false;
        destination$iv$iv = $this$map$iv;
        Object destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            WikiId bl = (WikiId)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl2 = false;
            collection.add(p0.getId());
        }
        collection = (List)destination$iv$iv2;
        List subscriptions = object3.findAllByWikiPermissionRoles(l, set2, set, CollectionsKt.toSet((Iterable)collection));
        Object $this$associateWith$iv = wikiIds;
        boolean $i$f$associateWith = false;
        LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
        Iterable $this$associateWithTo$iv$iv = $this$associateWith$iv;
        boolean $i$f$associateWithTo = false;
        for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
            Subscription subscription3;
            Object v0;
            void wikiId;
            Object e;
            block6: {
                WikiId p0 = (WikiId)element$iv$iv;
                e = element$iv$iv;
                object3 = result$iv;
                boolean bl = false;
                object2 = subscriptions;
                object = object2.iterator();
                while (object.hasNext()) {
                    Object t = object.next();
                    subscription2 = (Subscription)t;
                    boolean bl3 = false;
                    if (!Intrinsics.areEqual((Object)subscription2.getItemId(), (Object)wikiId.getId())) continue;
                    v0 = t;
                    break block6;
                }
                v0 = null;
            }
            if ((subscription3 = (Subscription)v0) == null) {
                subscription3 = new Subscription(subscriber, (ItemId)wikiId, false);
            }
            subscription = subscription3;
            object3.put(e, subscription);
        }
        $this$associateWith$iv = result$iv;
        boolean $i$f$mapValues = false;
        result$iv = $this$mapValues$iv;
        destination$iv$iv2 = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void entry;
            void it$iv$iv;
            object2 = (Map.Entry)element$iv$iv$iv;
            object = destination$iv$iv2;
            boolean bl = false;
            subscription2 = (Map.Entry)element$iv$iv$iv;
            Object k = it$iv$iv.getKey();
            object3 = object;
            boolean bl4 = false;
            subscription = SubscriptionDto.Companion.toDto((Subscription)entry.getValue());
            object3.put(k, subscription);
        }
        return destination$iv$iv2;
    }

    private SubscriptionDto read(ItemId itemId, ProfileId subscriber) {
        Subscription subscription = this.subscriptionRepository.findBySubscriberAndItemId(subscriber.getId(), itemId.getId());
        if (subscription == null) {
            subscription = new Subscription(subscriber, itemId, false);
        }
        return SubscriptionDto.Companion.toDto(subscription);
    }
}

