/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.wikiservice.business;

import de.justsoftware.wikiservice.business.DriveFileMigrationService;
import de.justsoftware.wikiservice.kafka.DriveFileMigrationProducer;
import de.justsoftware.wikiservice.kafka.model.DriveFileMigrationResult;
import de.justsoftware.wikiservice.model.ArticleId;
import de.justsoftware.wikiservice.model.ClusterPosition;
import de.justsoftware.wikiservice.persistence.ArticleVersionRepository;
import de.justsoftware.wikiservice.persistence.DriveFileMigrationRepository;
import de.justsoftware.wikiservice.persistence.MigrationStatusRepository;
import de.justsoftware.wikiservice.persistence.model.ArticleVersion;
import de.justsoftware.wikiservice.persistence.model.DriveFileMigration;
import de.justsoftware.wikiservice.persistence.model.MigrationState;
import de.justsoftware.wikiservice.persistence.model.MigrationStatus;
import de.justsoftware.wikiservice.prosemirror.ProseMirrorContentParserKt;
import jakarta.persistence.EntityManager;
import jakarta.persistence.PersistenceContext;
import jakarta.transaction.Transactional;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.context.event.EventListener;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;

@Service
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0017\u0018\u0000 (2\u00020\u0001:\u0001(BA\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\b\u0001\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u0010J\b\u0010\u001e\u001a\u00020\u001fH\u0012J\b\u0010 \u001a\u00020\u001fH\u0017J\u0016\u0010!\u001a\u00020\u001f2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020$0#H\u0012J\u0016\u0010%\u001a\u00020\u001f2\f\u0010&\u001a\b\u0012\u0004\u0012\u00020'0#H\u0017R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\f\u001a\u00020\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u000e\u0010\n\u001a\u00020\u000bX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0010\u0010\u000e\u001a\u00020\u000f8\u0012X\u0093\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0019\u001a\n \u001b*\u0004\u0018\u00010\u001a0\u001aX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001d\u00a8\u0006)"}, d2={"Lde/justsoftware/wikiservice/business/DriveFileMigrationService;", "", "articleVersionRepository", "Lde/justsoftware/wikiservice/persistence/ArticleVersionRepository;", "driveFileMigrationRepository", "Lde/justsoftware/wikiservice/persistence/DriveFileMigrationRepository;", "migrationStatusRepository", "Lde/justsoftware/wikiservice/persistence/MigrationStatusRepository;", "driveFileMigrationProducer", "Lde/justsoftware/wikiservice/kafka/DriveFileMigrationProducer;", "driveFileMigrationBatchSize", "", "clusterPosition", "Lde/justsoftware/wikiservice/model/ClusterPosition;", "entityManager", "Ljakarta/persistence/EntityManager;", "(Lde/justsoftware/wikiservice/persistence/ArticleVersionRepository;Lde/justsoftware/wikiservice/persistence/DriveFileMigrationRepository;Lde/justsoftware/wikiservice/persistence/MigrationStatusRepository;Lde/justsoftware/wikiservice/kafka/DriveFileMigrationProducer;ILde/justsoftware/wikiservice/model/ClusterPosition;Ljakarta/persistence/EntityManager;)V", "getArticleVersionRepository", "()Lde/justsoftware/wikiservice/persistence/ArticleVersionRepository;", "getClusterPosition", "()Lde/justsoftware/wikiservice/model/ClusterPosition;", "getDriveFileMigrationProducer", "()Lde/justsoftware/wikiservice/kafka/DriveFileMigrationProducer;", "getDriveFileMigrationRepository", "()Lde/justsoftware/wikiservice/persistence/DriveFileMigrationRepository;", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "getMigrationStatusRepository", "()Lde/justsoftware/wikiservice/persistence/MigrationStatusRepository;", "migrate", "", "runAfterStart", "saveMigrations", "driveFileMigrations", "", "Lde/justsoftware/wikiservice/persistence/model/DriveFileMigration;", "updateDriveMediaIds", "migrationResults", "Lde/justsoftware/wikiservice/kafka/model/DriveFileMigrationResult;", "Companion", "wiki-service"})
@SourceDebugExtension(value={"SMAP\nDriveFileMigrationService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DriveFileMigrationService.kt\nde/justsoftware/wikiservice/business/DriveFileMigrationService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,182:1\n1360#2:183\n1446#2,2:184\n1549#2:186\n1620#2,3:187\n1448#2,3:190\n1194#2,2:193\n1222#2,4:195\n1549#2:199\n1620#2,3:200\n1179#2,2:203\n1253#2,4:205\n1194#2,2:209\n1222#2,4:211\n1855#2,2:215\n1855#2,2:217\n1549#2:219\n1620#2,3:220\n766#2:223\n857#2,2:224\n1179#2,2:226\n1253#2,4:228\n1855#2,2:232\n*S KotlinDebug\n*F\n+ 1 DriveFileMigrationService.kt\nde/justsoftware/wikiservice/business/DriveFileMigrationService\n*L\n77#1:183\n77#1:184,2\n79#1:186\n79#1:187,3\n77#1:190,3\n86#1:193,2\n86#1:195,4\n108#1:199\n108#1:200,3\n119#1:203,2\n119#1:205,4\n125#1:209,2\n125#1:211,4\n131#1:215,2\n142#1:217,2\n155#1:219\n155#1:220,3\n159#1:223\n159#1:224,2\n160#1:226,2\n160#1:228,4\n164#1:232,2\n*E\n"})
public class DriveFileMigrationService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ArticleVersionRepository articleVersionRepository;
    @NotNull
    private final DriveFileMigrationRepository driveFileMigrationRepository;
    @NotNull
    private final MigrationStatusRepository migrationStatusRepository;
    @NotNull
    private final DriveFileMigrationProducer driveFileMigrationProducer;
    private final int driveFileMigrationBatchSize;
    @NotNull
    private final ClusterPosition clusterPosition;
    @PersistenceContext
    @NotNull
    private final EntityManager entityManager;
    private final Logger logger;
    @NotNull
    private static final String MIGRATION_ID = "DRIVE_FILES";

    @Autowired
    public DriveFileMigrationService(@NotNull ArticleVersionRepository articleVersionRepository, @NotNull DriveFileMigrationRepository driveFileMigrationRepository, @NotNull MigrationStatusRepository migrationStatusRepository, @NotNull DriveFileMigrationProducer driveFileMigrationProducer, @Value(value="${service.driveFileMigrationBatchSize:100}") int driveFileMigrationBatchSize, @NotNull ClusterPosition clusterPosition, @NotNull EntityManager entityManager) {
        Intrinsics.checkNotNullParameter((Object)articleVersionRepository, (String)"articleVersionRepository");
        Intrinsics.checkNotNullParameter((Object)driveFileMigrationRepository, (String)"driveFileMigrationRepository");
        Intrinsics.checkNotNullParameter((Object)migrationStatusRepository, (String)"migrationStatusRepository");
        Intrinsics.checkNotNullParameter((Object)driveFileMigrationProducer, (String)"driveFileMigrationProducer");
        Intrinsics.checkNotNullParameter((Object)clusterPosition, (String)"clusterPosition");
        Intrinsics.checkNotNullParameter((Object)entityManager, (String)"entityManager");
        this.articleVersionRepository = articleVersionRepository;
        this.driveFileMigrationRepository = driveFileMigrationRepository;
        this.migrationStatusRepository = migrationStatusRepository;
        this.driveFileMigrationProducer = driveFileMigrationProducer;
        this.driveFileMigrationBatchSize = driveFileMigrationBatchSize;
        this.clusterPosition = clusterPosition;
        this.entityManager = entityManager;
        this.logger = LoggerFactory.getLogger(DriveFileMigrationService.class);
    }

    @NotNull
    public ArticleVersionRepository getArticleVersionRepository() {
        return this.articleVersionRepository;
    }

    @NotNull
    public DriveFileMigrationRepository getDriveFileMigrationRepository() {
        return this.driveFileMigrationRepository;
    }

    @NotNull
    public MigrationStatusRepository getMigrationStatusRepository() {
        return this.migrationStatusRepository;
    }

    @NotNull
    public DriveFileMigrationProducer getDriveFileMigrationProducer() {
        return this.driveFileMigrationProducer;
    }

    @NotNull
    public ClusterPosition getClusterPosition() {
        return this.clusterPosition;
    }

    @EventListener(value={ApplicationReadyEvent.class})
    public void runAfterStart() {
        if (this.getClusterPosition() != ClusterPosition.PRIMARY) {
            return;
        }
        this.migrate();
    }

    /*
     * WARNING - void declaration
     */
    private void migrate() {
        Instant instant;
        Instant before;
        Object t = this.getMigrationStatusRepository().findById((Object)MIGRATION_ID).get();
        Intrinsics.checkNotNullExpressionValue(t, (String)"get(...)");
        MigrationStatus migration = (MigrationStatus)t;
        if (migration.getStatus() == MigrationState.FINISHED) {
            return;
        }
        Instant instant2 = migration.getCreatedAt();
        if (instant2 == null) {
            instant2 = before = Instant.now();
        }
        if ((instant = migration.getUpdatedAt()) == null) {
            instant = Instant.EPOCH;
        }
        Instant after = instant;
        String[] stringArray = new String[]{"createdAt"};
        PageRequest page = PageRequest.of((int)0, (int)this.driveFileMigrationBatchSize, (Sort)Sort.by((Sort.Direction)Sort.Direction.ASC, (String[])stringArray));
        ArticleVersionRepository articleVersionRepository = this.getArticleVersionRepository();
        Intrinsics.checkNotNull((Object)after);
        Intrinsics.checkNotNull((Object)before);
        PageRequest pageRequest = page;
        Intrinsics.checkNotNull((Object)pageRequest);
        Page pagedResult = articleVersionRepository.findAllByCreatedAtAfterAndCreatedAtBefore(after, before, (Pageable)pageRequest);
        while (!pagedResult.isEmpty()) {
            void $this$associateByTo$iv$iv;
            void $this$associateBy$iv;
            void $this$flatMapTo$iv$iv;
            List list = pagedResult.getContent();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getContent(...)");
            Iterable $this$flatMap$iv = list;
            boolean $i$f$flatMap = false;
            Iterable iterable = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                Iterable $this$map$iv;
                ArticleVersion it = (ArticleVersion)element$iv$iv;
                boolean bl = false;
                try {
                    void $this$mapTo$iv$iv;
                    $this$map$iv = ProseMirrorContentParserKt.driveMediaIdsFromPMContent((String)it.getContent());
                    boolean $i$f$map = false;
                    Iterable iterable2 = $this$map$iv;
                    Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv) {
                        void driveFileId;
                        String string = (String)item$iv$iv;
                        Collection collection = destination$iv$iv2;
                        boolean bl2 = false;
                        collection.add(new DriveFileMigration((String)driveFileId, null, it.getArticleId()));
                    }
                    $this$map$iv = (List)destination$iv$iv2;
                }
                catch (Exception ex) {
                    this.logger.error("Could not extract driveIds for ArticleVersion " + it.getId() + ": " + ex.getClass());
                    $this$map$iv = CollectionsKt.emptyList();
                }
                Iterable list$iv$iv = $this$map$iv;
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            $this$flatMap$iv = (List)destination$iv$iv;
            boolean $i$f$associateBy = false;
            int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
            destination$iv$iv = $this$associateBy$iv;
            Map destination$iv$iv3 = new LinkedHashMap(capacity$iv);
            boolean $i$f$associateByTo = false;
            for (Object element$iv$iv : $this$associateByTo$iv$iv) {
                void it;
                DriveFileMigration bl = (DriveFileMigration)element$iv$iv;
                Map map = destination$iv$iv3;
                boolean bl3 = false;
                map.put(it.getOldFileId(), element$iv$iv);
            }
            Set driveFileIds = CollectionsKt.toSet((Iterable)destination$iv$iv3.values());
            if (!((Collection)driveFileIds).isEmpty()) {
                this.saveMigrations(driveFileIds);
                migration.setUpdatedAt(Instant.now());
                this.getMigrationStatusRepository().saveAndFlush((Object)migration);
            }
            page = page.next();
            ArticleVersionRepository articleVersionRepository2 = this.getArticleVersionRepository();
            PageRequest pageRequest2 = page;
            Intrinsics.checkNotNull((Object)pageRequest2);
            pagedResult = articleVersionRepository2.findAllByCreatedAtAfterAndCreatedAtBefore(after, before, (Pageable)pageRequest2);
        }
        migration.setStatus(MigrationState.FINISHED);
        this.getMigrationStatusRepository().saveAndFlush((Object)migration);
    }

    /*
     * WARNING - void declaration
     */
    private void saveMigrations(Set<DriveFileMigration> driveFileMigrations) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = driveFileMigrations;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            DriveFileMigration driveFileMigration = (DriveFileMigration)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getOldFileId());
        }
        Set driveFileIds = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        Set existingMigrations = this.getDriveFileMigrationRepository().findByDriveFileIds(driveFileIds);
        Set newMigrations = SetsKt.minus(driveFileMigrations, (Iterable)existingMigrations);
        this.getDriveFileMigrationProducer().sendDriveFileMigrations(newMigrations);
        this.getDriveFileMigrationRepository().saveAllAndFlush((Iterable)newMigrations);
    }

    /*
     * WARNING - void declaration
     */
    @Transactional
    public void updateDriveMediaIds(@NotNull Set<DriveFileMigrationResult> migrationResults) {
        void $this$associateTo$iv$iv;
        void $this$associate$iv;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        void $this$mapTo$iv$iv;
        String newFileId;
        Object element$iv2;
        Object object;
        void $this$associateByTo$iv$iv;
        void $this$associateBy$iv;
        DriveFileMigrationResult it;
        void $this$associateTo$iv$iv2;
        Intrinsics.checkNotNullParameter(migrationResults, (String)"migrationResults");
        Iterable $this$associate$iv2 = migrationResults;
        boolean $i$f$associate22 = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv2, (int)10)), (int)16);
        Iterable iterable = $this$associate$iv2;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv2) {
            Map map = destination$iv$iv;
            it = (DriveFileMigrationResult)element$iv$iv;
            boolean bl = false;
            it = TuplesKt.to((Object)it.getOldFileId(), (Object)it.getNewFileId());
            map.put(it.getFirst(), it.getSecond());
        }
        Map idMapping = destination$iv$iv;
        Iterable $i$f$associate22 = this.getDriveFileMigrationRepository().findByDriveFileIds(idMapping.keySet());
        boolean $i$f$associateBy = false;
        int capacity$iv2 = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        destination$iv$iv = $this$associateBy$iv;
        Object destination$iv$iv2 = new LinkedHashMap(capacity$iv2);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            it = (DriveFileMigration)element$iv$iv;
            object = destination$iv$iv2;
            boolean bl = false;
            object.put(it.getOldFileId(), element$iv$iv);
        }
        Map migrationsMapping = MapsKt.toMutableMap((Map)destination$iv$iv2);
        Iterable $this$forEach$iv = migrationResults;
        boolean $i$f$forEach = false;
        for (Object element$iv2 : $this$forEach$iv) {
            destination$iv$iv2 = (DriveFileMigrationResult)element$iv2;
            boolean bl = false;
            ArticleId articleId = destination$iv$iv2.component1();
            String oldFileId = destination$iv$iv2.component2();
            newFileId = destination$iv$iv2.component3();
            migrationsMapping.computeIfAbsent(oldFileId, arg_0 -> DriveFileMigrationService.updateDriveMediaIds$lambda$7$lambda$6((Function1)new /* Unavailable Anonymous Inner Class!! */, arg_0));
        }
        $this$forEach$iv = migrationsMapping.values();
        $i$f$forEach = false;
        for (Object element$iv2 : $this$forEach$iv) {
            Object newFileId2;
            DriveFileMigration it2 = (DriveFileMigration)element$iv2;
            boolean bl = false;
            if ((String)idMapping.get(it2.getOldFileId()) == null) {
                return;
            }
            if (it2.getNewFileId() != null && !Intrinsics.areEqual((Object)it2.getNewFileId(), (Object)newFileId2)) {
                return;
            }
            it2.setNewFileId((String)newFileId2);
        }
        this.getDriveFileMigrationRepository().saveAllAndFlush((Iterable)migrationsMapping.values());
        Iterable $this$map$iv = migrationsMapping.values();
        boolean $i$f$map22 = false;
        element$iv2 = $this$map$iv;
        destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            newFileId = (DriveFileMigration)item$iv$iv;
            object = destination$iv$iv2;
            boolean bl = false;
            object.add(it.getArticleId());
        }
        Set articleIds = CollectionsKt.toSet((Iterable)((List)destination$iv$iv2));
        Iterable $i$f$map22 = this.getDriveFileMigrationRepository().findByArticleIds(articleIds);
        boolean $i$f$filter = false;
        destination$iv$iv2 = $this$filter$iv;
        Collection destination$iv$iv3 = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            DriveFileMigration it3 = (DriveFileMigration)element$iv$iv;
            boolean bl = false;
            if (!(it3.getNewFileId() != null)) continue;
            destination$iv$iv3.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv3;
        boolean $i$f$associate = false;
        int capacity$iv3 = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        destination$iv$iv3 = $this$associate$iv;
        Map destination$iv$iv4 = new LinkedHashMap(capacity$iv3);
        boolean $i$f$associateTo2 = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            Map map = destination$iv$iv4;
            DriveFileMigration it4 = (DriveFileMigration)element$iv$iv;
            boolean bl = false;
            String string = it4.getNewFileId();
            if (string == null) {
                String string2 = "Required value was null.";
                throw new IllegalStateException(string2.toString());
            }
            Pair pair = TuplesKt.to((Object)it4.getOldFileId(), (Object)string);
            map.put(pair.getFirst(), pair.getSecond());
        }
        Map migrationsForArticles = destination$iv$iv4;
        Iterable $this$forEach$iv2 = articleIds;
        boolean $i$f$forEach2 = false;
        for (Object element$iv3 : $this$forEach$iv2) {
            ArticleId article = (ArticleId)element$iv3;
            boolean bl = false;
            this.getArticleVersionRepository().findByArticleIdOrderByCreatedAtDesc(article).forEach(arg_0 -> DriveFileMigrationService.updateDriveMediaIds$lambda$13$lambda$12((Function1)new /* Unavailable Anonymous Inner Class!! */, arg_0));
        }
        this.getArticleVersionRepository().flush();
    }

    private static final DriveFileMigration updateDriveMediaIds$lambda$7$lambda$6(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (DriveFileMigration)$tmp0.invoke(p0);
    }

    private static final void updateDriveMediaIds$lambda$13$lambda$12(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    public static final /* synthetic */ EntityManager access$getEntityManager$p(DriveFileMigrationService $this) {
        return $this.entityManager;
    }
}

