/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.wikiservice.application;

import de.justsoftware.wikiservice.business.ConfigService;
import de.justsoftware.wikiservice.model.PermissionType;
import de.justsoftware.wikiservice.model.TenantId;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0017\u0018\u00002\u00020\u0001B\u000f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\u0006H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lde/justsoftware/wikiservice/application/ConfigApplicationService;", "", "configService", "Lde/justsoftware/wikiservice/business/ConfigService;", "(Lde/justsoftware/wikiservice/business/ConfigService;)V", "getArticleVersionHistoryReadPermission", "Lde/justsoftware/wikiservice/model/PermissionType;", "tenantId", "Lde/justsoftware/wikiservice/model/TenantId;", "setArticleVersionHistoryReadPermission", "", "permissionType", "wiki-service"})
public class ConfigApplicationService {
    @NotNull
    private final ConfigService configService;

    @Autowired
    public ConfigApplicationService(@NotNull ConfigService configService) {
        Intrinsics.checkNotNullParameter((Object)configService, (String)"configService");
        this.configService = configService;
    }

    public void setArticleVersionHistoryReadPermission(@NotNull TenantId tenantId, @NotNull PermissionType permissionType) {
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        Intrinsics.checkNotNullParameter((Object)permissionType, (String)"permissionType");
        this.configService.setMayReadArticleVersionHistoryPermission(tenantId, permissionType);
    }

    @NotNull
    public PermissionType getArticleVersionHistoryReadPermission(@NotNull TenantId tenantId) {
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        return this.configService.getMayReadArticleVersionHistoryPermission(tenantId);
    }
}

