(function () {
    
    /**
     * Make all li tags with an expandable-collapsed class foldable.
     */
    var makeFoldable = function(element) {

        var addOpenCallback = function(li) {
            li.data(
                "openCallback",
                function() {
                    open(li[0]);
                });
        };
        
        var makeTextClickable = function(jLi, clickHandler) {
            var contents = jLi.contents();

            contents.each(function(i, element) {
                var jElement,
                    firstOrLast,
                    tagName;

                // is text node?
                if (element.nodeType === 3) {
                    firstOrLast = i === 0 || i === contents.length - 1;

                    if (firstOrLast && /^\s*$/.test(element.nodeValue)) {
                        // ignore the first and the last text node if it contains only whitespaces
                        return;
                    }

                    // wrap a span around text-nodes, so we have an element.
                    jElement = jQuery(element).wrap("<span/>").parent();

                    jElement.click(clickHandler);
                    jElement.addClass("fold-text");
                } else {
                    tagName = element.tagName;
                    if (tagName === 'UL' || tagName === 'OL' || tagName === 'A') {
                        return; // ignore links and sub lists
                    }

                    jElement = jQuery(element);

                    if (jElement.find('ul')[0] || jElement.find('ol')[0] || jElement.find('a')[0]) {
                        // This element has a descent, we need to ignore.
                        // We will check the children recursively, to
                        // exclude this child correctly.
                        makeTextClickable(jElement, clickHandler);
                    } else {
                        jElement.click(clickHandler);
                        jElement.addClass("fold-text");
                    }
                }

            });
        };

        // Old user generated HTML might use the class "expandable-collapsed".
        // Remove this class. We will add it to the correct elements below.
        jQuery("li.expandable-collapsed", element).removeClass("expandable-collapsed");

        // Find fold links.
        jQuery("li i.icon-caret-down.fold-link", element)
            .each(function(i, foldLink) {
                var jFoldLink = jQuery(foldLink);                

                // find the parent li tag
                var jLi = jFoldLink.parents("li").first();

                // We only register the last found i tag.
                // Although it is possible that more than one i tags are present.
                // We life with that "bug" because it gains rendering speed.
                jLi.data("fold-link", jFoldLink)

                if (!jLi.hasClass("expandable-collapsed")) {
                    //this list is not foldable yet

                    addOpenCallback(jLi);
                    jLi.addClass("expandable-collapsed");

                    makeTextClickable(jLi, function() {
                        toggle(jLi);
                    });
                }
            });

        // Add class expandable-parent to parents of expandable items.
        jQuery('ul > li.expandable-collapsed, ol > li.expandable-collapsed').parent().addClass('expandable-parent');

        // Add class expandable-parent-odd to every second expandable-parent in a list hierarchy.
        jQuery(".expandable-parent", element).each(function(i, e) {
            var jE = jQuery(e);
            if (!jE.parent().parent().hasClass("expandable-parent-odd")) {
                jE.addClass("expandable-parent-odd");
            }
        });
    };

    /**
     * Opens element (if it is an folded list), and all it's parents.
     */
    var openParents = function(element) {
        var jElement = jQuery(element);

        var open = function(i, p) {
            var openCallback = jQuery(p).data("openCallback");
            if (jQuery.isFunction(openCallback)) {
                openCallback();
            }
        };

        open(0, jElement);
        jElement.parents().each(open);
    };

    var toggle = function(li) {
        setCollapsed(li, !isCollapsed(li));
    };

    var open = function(li) {
        if (isCollapsed(li)) {
            setCollapsed(li, false);
        }
    };

    var isCollapsed = function(li) {
        return jQuery(li).hasClass("expandable-collapsed");
    };

    var setCollapsed = function(li, collapsed) {
        var jLi = jQuery(li);
        var foldLinks = jLi.data("fold-link");
        if (collapsed) {
            foldLinks.removeClass("icon-caret-up");
            foldLinks.addClass("icon-caret-down");
            jLi.removeClass("expandable-expanded");
            jLi.addClass("expandable-collapsed");
        } else {
            foldLinks.removeClass("icon-caret-down");
            foldLinks.addClass("icon-caret-up");
            jLi.removeClass("expandable-collapsed");
            jLi.addClass("expandable-expanded");
        }
    };

    window.justConnect = window.justConnect || {};
    window.justConnect.foldUtil = window.justConnect.foldUtil || {};
    var foldUtil = window.justConnect.foldUtil;

    foldUtil.makeFoldable = makeFoldable;
    foldUtil.openParents = openParents;
})();
