/*
 * Decompiled with CFR 0.152.
 */
package org.gwtwidgets.server.spring;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public class ServletUtils {
    private static ThreadLocal<HttpServletResponse> servletResponse = new ThreadLocal();

    public static void disableResponseCaching(HttpServletResponse response) {
        response.setHeader("Expires", "Sat, 1 January 2000 12:00:00 GMT");
        response.setHeader("Cache-Control", "no-store, no-cache, must-revalidate");
        response.addHeader("Cache-Control", "post-check=0, pre-check=0");
        response.setHeader("Pragma", "no-cache");
    }

    public static HttpServletRequest getRequest() {
        return ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest();
    }

    public static HttpServletResponse getResponse() {
        return (HttpServletResponse)servletResponse.get();
    }

    public static void setResponse(HttpServletResponse response) {
        servletResponse.set(response);
    }
}

