/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.searchnew.presentation.server;

import com.freiheit.toro.common.shared.model.ServiceException;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import de.justsoftware.onx.authorization.business.AuthorizationCheckContextWithLocale;
import de.justsoftware.onx.authorization.business.AuthorizationCheckContextWithUserId;
import de.justsoftware.onx.authorization.business.AuthorizationContext;
import de.justsoftware.onx.authorization.business.SearchAuthorizationCheckContext;
import de.justsoftware.onx.authorization.business.SessionAuthorizationContextProvider;
import de.justsoftware.onx.common.business.configfile.EntityConfigService;
import de.justsoftware.onx.common.shared.model.EntityVersionReviewerConfig;
import de.justsoftware.onx.common.shared.model.ListAndCount;
import de.justsoftware.onx.common.shared.model.action.Action;
import de.justsoftware.onx.common.shared.model.action.StaticEntityAction;
import de.justsoftware.onx.common.shared.util.CollectionUtil;
import de.justsoftware.onx.container.business.EntityService;
import de.justsoftware.onx.container.business.EntityTeaserService;
import de.justsoftware.onx.container.presentation.shared.EntityChildrenRemoteService;
import de.justsoftware.onx.container.shared.model.EntityId;
import de.justsoftware.onx.container.shared.model.EntityInfo;
import de.justsoftware.onx.container.shared.model.EntityTeaser;
import de.justsoftware.onx.container.shared.model.EntityType;
import de.justsoftware.onx.container.shared.model.teasers.TeaserType;
import de.justsoftware.onx.searchnew.business.CommonSearchService;
import de.justsoftware.onx.searchnew.presentation.shared.CommonSearchRemoteService;
import de.justsoftware.onx.searchnew.shared.model.FilterType;
import de.justsoftware.onx.searchnew.shared.model.PersonSuggest;
import de.justsoftware.onx.searchnew.shared.model.SearchContextModel;
import de.justsoftware.onx.searchnew.shared.model.SearchResult;
import de.justsoftware.onx.searchnew.shared.model.SortType;
import de.justsoftware.onx.searchnew.shared.model.StaticFilterType;
import de.justsoftware.onx.searchnew.shared.model.SubFilter;
import de.justsoftware.onx.searchnew.shared.model.SuggestModel;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CommonSearchRemoteServiceImpl
implements CommonSearchRemoteService,
EntityChildrenRemoteService {
    @Autowired
    private CommonSearchService _searchService;
    @Autowired
    private EntityService _entityService;
    @Autowired
    private SessionAuthorizationContextProvider _sessionAuthorizationContextProvider;
    @Autowired
    private EntityConfigService _entityConfigService;
    @Autowired
    private EntityTeaserService _entityTeaserService;

    @Nonnull
    private SearchResult<SuggestModel<?, ?>> suggestPersons(@Nonnull String searchString, int offset, int numberOfResults, @Nullable Collection<SubFilter> additionalFilter) throws ServiceException {
        AuthorizationContext authorizationContext = this._sessionAuthorizationContextProvider.getAuthorizationContextForCurrentUser();
        return this._searchService.suggest(searchString, null, ImmutableSet.of((Object)StaticFilterType.PROFILES), null, additionalFilter, offset, numberOfResults, (SearchAuthorizationCheckContext)authorizationContext);
    }

    public SearchResult<SuggestModel<?, ?>> suggestAuthorForEntity(EntityId entityId, String searchString, int offset, int numberOfResults) {
        return this.suggestByActionForEntity(entityId, searchString, offset, numberOfResults, (Action)StaticEntityAction.ENTITY_BECOME_VERSION_AUTHOR);
    }

    @Nonnull
    private SearchResult<SuggestModel<?, ?>> suggestByActionForEntity(@Nonnull EntityId entityId, @Nonnull String searchString, int offset, int numberOfResults, @Nonnull Action action) {
        SubFilter orFilter = this._searchService.getSubFilterForStaticEntityAction(entityId, action);
        return this.suggestPersons(searchString, offset, numberOfResults, (Collection)(orFilter != null ? ImmutableList.of((Object)orFilter) : null));
    }

    @Nonnull
    private SearchResult<SuggestModel<?, ?>> suggestReviewersForEntityByReviewStage(@Nonnull EntityId entityId, @Nonnull String searchString, int stageIndex, int offset, int numberOfResults) {
        SubFilter orFilter = this._searchService.getSubFilterForReviewStageRoles(entityId, stageIndex);
        return this.suggestPersons(searchString, offset, numberOfResults, (Collection)(orFilter != null ? ImmutableList.of((Object)orFilter) : null));
    }

    public SearchResult<SuggestModel<?, ?>> suggestReviewerForEntity(EntityId entityId, String searchString, int reviewStage, int offset, int numberOfResults) throws ServiceException {
        EntityType entityType = this._entityService.getByIdNotNull(entityId).getType();
        EntityVersionReviewerConfig reviewerConfig = this._entityConfigService.getVersionReleaseReviewerConfig(entityType);
        if (reviewerConfig.hasPredefinedReviewerRolesForStage(reviewStage)) {
            return this.suggestReviewersForEntityByReviewStage(entityId, searchString, reviewStage, offset, numberOfResults);
        }
        return this.suggestByActionForEntity(entityId, searchString, offset, numberOfResults, (Action)StaticEntityAction.ENTITY_BECOME_VERSION_REVIEWER);
    }

    public ListAndCount<PersonSuggest> getPotentialReviewersForEntity(EntityId entityId, int reviewStage, int offset, int numberOfResults) {
        return this._searchService.getPotentialReviewersForEntityByReviewStage(entityId, reviewStage, offset, numberOfResults, (SearchAuthorizationCheckContext)this._sessionAuthorizationContextProvider.getAuthorizationContextForCurrentUser());
    }

    public ListAndCount<PersonSuggest> getPotentialAuthorsForEntity(EntityId entityId, int offset, int numberOfResults) throws ServiceException {
        return this._searchService.getPotentialAuthorsForEntity(entityId, offset, numberOfResults, (SearchAuthorizationCheckContext)this._sessionAuthorizationContextProvider.getAuthorizationContextForCurrentUser());
    }

    public List<EntityTeaser> getRandomChildrenTeasers(EntityType entityType, EntityId parentId, TeaserType teaserType, int numberOfResults, ImmutableList<? extends SubFilter> subFilter) {
        AuthorizationContext authorizationContext = this._sessionAuthorizationContextProvider.getAuthorizationContextForCurrentUser();
        ListAndCount ids = this._searchService.getVisibleChildrenIds((SearchAuthorizationCheckContext)authorizationContext, parentId, (Iterable)ImmutableSet.of((Object)entityType), 0, Integer.MAX_VALUE, null, subFilter);
        return this._entityTeaserService.getTeasersByIds(teaserType, CollectionUtil.randomSublist((Iterable)ids, (int)numberOfResults), (AuthorizationCheckContextWithUserId)authorizationContext);
    }

    public SearchResult<SuggestModel<?, ?>> suggest(String searchString, SearchContextModel searchContext, Collection<SubFilter> additionalFilter, ImmutableSet<FilterType> filterTypes, SortType selectedSortType, int offset, int numberOfResults) {
        AuthorizationContext authorizationContext = this._sessionAuthorizationContextProvider.getAuthorizationContextForCurrentUser();
        return this._searchService.suggest(searchString, searchContext, filterTypes, selectedSortType, additionalFilter, offset, numberOfResults, (SearchAuthorizationCheckContext)authorizationContext);
    }

    public ListAndCount<EntityTeaser> getChildrenTeasers(EntityType entityType, EntityId parentId, TeaserType teaserType, SortType sortType, int offset, int numberOfResults, ImmutableSet<? extends SubFilter> subFilter) {
        return this.getChildrenTeasers(entityType, parentId, teaserType, sortType, offset, numberOfResults, subFilter, this._sessionAuthorizationContextProvider.getAuthorizationContextForCurrentUser());
    }

    @Nonnull
    private ListAndCount<EntityInfo> getChildrenInfos(EntityType entityType, EntityId parentId, SortType sortType, int offset, int numberOfResults, @Nullable ImmutableList<? extends SubFilter> subFilter, @Nonnull AuthorizationContext authorizationContext) {
        ListAndCount ids = this._searchService.getVisibleChildrenIds((SearchAuthorizationCheckContext)authorizationContext, parentId, (Iterable)ImmutableSet.of((Object)entityType), offset, numberOfResults, sortType, subFilter);
        return new ListAndCount(ids.getMaxCount(), (Collection)this._entityService.getInfosByIdsOrdered((Iterable)ids, (AuthorizationCheckContextWithLocale)authorizationContext));
    }

    @Nonnull
    private ListAndCount<EntityTeaser> getChildrenTeasers(EntityType entityType, @Nonnull EntityId parentId, TeaserType teaserType, SortType sortType, int offset, int numberOfResults, @Nullable ImmutableSet<? extends SubFilter> subFilter, @Nonnull AuthorizationContext authorizationContext) {
        ListAndCount ids = this._searchService.getVisibleChildrenIds((SearchAuthorizationCheckContext)authorizationContext, parentId, (Iterable)ImmutableSet.of((Object)entityType), offset, numberOfResults, sortType, subFilter);
        return new ListAndCount(ids.getMaxCount(), (Collection)this._entityTeaserService.getTeasersByIds(teaserType, (List)ids, (AuthorizationCheckContextWithUserId)authorizationContext));
    }
}

