/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.searchnew.presentation.client.ui;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import de.justsoftware.onx.searchnew.presentation.client.MultiSelectionFilterLink;
import de.justsoftware.onx.searchnew.presentation.client.ui.AbstractMultiSelectionDataProvider;
import de.justsoftware.onx.searchnew.presentation.client.ui.MultipleSelectionFilterPresenter;
import de.justsoftware.onx.searchnew.shared.model.ProfileAttributeSearchFacet;
import de.justsoftware.onx.searchnew.shared.model.ProfileAttributeSubFilter;
import de.justsoftware.onx.searchnew.shared.model.SearchConfigurationProvider;
import de.justsoftware.onx.searchnew.shared.model.SearchFacet;
import de.justsoftware.onx.searchnew.shared.model.SearchFacetCounts;
import de.justsoftware.onx.searchnew.shared.model.SearchParameters;
import de.justsoftware.onx.searchnew.shared.model.SubFilter;
import de.justsoftware.onx.searchnew.shared.model.SubFilterSelector;
import de.justsoftware.onx.searchnew.shared.model.TranslatedProfileAttributeFacet;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class ProfileAttributeSubFilterDataProvider
extends AbstractMultiSelectionDataProvider<String> {
    private final TranslatedProfileAttributeFacet _attribute;
    private final ProfileAttributeSearchFacet _searchFacet;

    public ProfileAttributeSubFilterDataProvider(TranslatedProfileAttributeFacet attribute, SearchConfigurationProvider searchConfigurationProvider) {
        super(searchConfigurationProvider);
        this._attribute = attribute;
        this._searchFacet = new ProfileAttributeSearchFacet(attribute.getName());
    }

    public String getFilterHeader() {
        return this._attribute.getI18nName();
    }

    public MultipleSelectionFilterPresenter.SearchInSelectionsSupport<String> getSearchInSelectionSupport() {
        return this._attribute.isSearchInSelectionSupported() ? this.createDefaultSearchInSelectionSupport() : null;
    }

    protected SearchFacetCounts.SearchFacetCountsVisitor<ImmutableList<MultiSelectionFilterLink<String>>> getSearchFacetCountsVisitor(SearchParameters searchParameters) {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    protected SearchFacet getSearchFacet() {
        return this._searchFacet;
    }

    protected ImmutableSet<String> getCurrentlySelected(SearchParameters searchParameters) {
        ProfileAttributeSubFilter subfilter = searchParameters.getProfileAttributeSubFilter(this._searchFacet.getName());
        return subfilter != null ? subfilter.getFilterValues() : ImmutableSet.of();
    }

    protected SubFilter createSubfilter(ImmutableSet<String> newSelection) {
        return new ProfileAttributeSubFilter(this._searchFacet.getName(), newSelection);
    }

    protected SubFilterSelector getSkipCurrentSubFilterSelector() {
        return SubFilterSelector.selectAll().skipProfileAttributeSubFilter(this._searchFacet.getName());
    }
}

