/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.searchnew.presentation.client.ui;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import de.justsoftware.onx.common.shared.model.attributes.DynamicAttributeConfig;
import de.justsoftware.onx.common.shared.model.attributes.DynamicEntityAttributesMessages;
import de.justsoftware.onx.common.shared.model.attributes.Input;
import de.justsoftware.onx.container.presentation.client.EntityClientFactory;
import de.justsoftware.onx.container.shared.model.EntityType;
import de.justsoftware.onx.searchnew.presentation.client.MultiSelectionFilterLink;
import de.justsoftware.onx.searchnew.presentation.client.ui.AbstractMultiSelectionDataProvider;
import de.justsoftware.onx.searchnew.presentation.client.ui.MultipleSelectionFilterPresenter;
import de.justsoftware.onx.searchnew.shared.model.EntityDynamicAttributeSearchFacet;
import de.justsoftware.onx.searchnew.shared.model.EntityDynamicAttributeSubFilter;
import de.justsoftware.onx.searchnew.shared.model.SearchConfigurationProvider;
import de.justsoftware.onx.searchnew.shared.model.SearchFacet;
import de.justsoftware.onx.searchnew.shared.model.SearchFacetCounts;
import de.justsoftware.onx.searchnew.shared.model.SearchParameters;
import de.justsoftware.onx.searchnew.shared.model.SubFilter;
import de.justsoftware.onx.searchnew.shared.model.SubFilterSelector;
import javax.annotation.Nonnull;

public class EntityDynamicAttributeSubFilterDataProvider
extends AbstractMultiSelectionDataProvider<String> {
    private final DynamicEntityAttributesMessages _messages;
    private final EntityType _entityType;
    private final EntityDynamicAttributeSearchFacet _searchFacet;
    private final DynamicAttributeConfig _attributeConfig;
    private final EntityClientFactory _entityClientFactory;
    private final Function<String, String> _labelFunction;

    public EntityDynamicAttributeSubFilterDataProvider(@Nonnull EntityType entityType, @Nonnull DynamicAttributeConfig attributeConfig, @Nonnull EntityClientFactory entityClientFactory, @Nonnull SearchConfigurationProvider searchConfigurationProvider) {
        super(searchConfigurationProvider);
        this._entityType = entityType;
        this._attributeConfig = attributeConfig;
        this._entityClientFactory = entityClientFactory;
        this._searchFacet = new EntityDynamicAttributeSearchFacet(attributeConfig.getId(), entityType);
        this._messages = this._entityClientFactory.getDynamicAttributeMessages(entityType, this._attributeConfig.getId());
        this._labelFunction = this.getLabelFunction();
    }

    public String getFilterHeader() {
        return this._messages.name(this._attributeConfig.getId());
    }

    protected SearchFacetCounts.SearchFacetCountsVisitor<ImmutableList<MultiSelectionFilterLink<String>>> getSearchFacetCountsVisitor(SearchParameters searchParameters) {
        ImmutableSet currentlySelected = this.getCurrentlySelected(searchParameters);
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    protected SearchFacet getSearchFacet() {
        return this._searchFacet;
    }

    protected ImmutableSet<String> getCurrentlySelected(SearchParameters searchParameters) {
        EntityDynamicAttributeSubFilter subFilter = searchParameters.getEntityDynamicAttributeSubFilter(this._attributeConfig.getId());
        return subFilter != null ? subFilter.getFilterValues() : ImmutableSet.of();
    }

    protected SubFilter createSubfilter(ImmutableSet<String> newSelection) {
        return new EntityDynamicAttributeSubFilter(this._attributeConfig.getId(), this._entityType, newSelection);
    }

    protected SubFilterSelector getSkipCurrentSubFilterSelector() {
        return SubFilterSelector.selectAll().skipEntityDynamicAttributeSubFilter(this._attributeConfig.getId());
    }

    @Nonnull
    private Function<String, String> getLabelFunction() {
        return (Function)this._attributeConfig.getInput().accept((Input.InputVisitor)new /* Unavailable Anonymous Inner Class!! */);
    }

    public MultipleSelectionFilterPresenter.SearchInSelectionsSupport<String> getSearchInSelectionSupport() {
        return (MultipleSelectionFilterPresenter.SearchInSelectionsSupport)((Optional)this._attributeConfig.getInput().accept((Input.InputVisitor)new /* Unavailable Anonymous Inner Class!! */)).orNull();
    }
}

