/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.searchnew.presentation.client.ui;

import com.freiheit.toro.client.mediator.I18nMediator;
import com.freiheit.toro.common.presentation.ui.HTMLUtil;
import com.freiheit.toro.common.shared.i18n.DocumentConstants;
import com.github.gwtbootstrap.client.ui.base.IconAnchor;
import com.google.common.base.Optional;
import com.google.gwt.safehtml.shared.SafeHtml;
import com.google.gwt.safehtml.shared.UriUtils;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.InlineHyperlink;
import com.google.gwt.user.client.ui.InlineLabel;
import com.google.gwt.user.client.ui.Widget;
import de.justsoftware.onx.common.presentation.client.ClientFactory;
import de.justsoftware.onx.common.presentation.client.FieldNameResolver;
import de.justsoftware.onx.common.presentation.client.ui.JucoSafeHtmlTemplates;
import de.justsoftware.onx.common.shared.util.StringUtil;
import de.justsoftware.onx.container.presentation.client.EntityUtils;
import de.justsoftware.onx.container.shared.model.ItemIdVisitor;
import de.justsoftware.onx.container.shared.model.SearchableId;
import de.justsoftware.onx.drive.presentation.client.DriveClientFactory;
import de.justsoftware.onx.drive.shared.model.DriveDocumentId;
import de.justsoftware.onx.searchnew.presentation.client.SearchTrackingInfo;
import de.justsoftware.onx.searchnew.presentation.client.ui.BaseSearchResultBadgePresenter;
import de.justsoftware.onx.searchnew.presentation.client.ui.DriveDocumentSearchResultBadgePresenter;
import de.justsoftware.onx.searchnew.shared.model.DriveDocumentSearchResultBadgeModel;
import de.justsoftware.onx.searchnew.shared.model.ParentItemInfo;
import java.util.Collection;
import java.util.Date;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class DriveDocumentSearchResultBadgePresenter
extends BaseSearchResultBadgePresenter {
    private static final DocumentConstants DOCUMENT_CONSTANTS = I18nMediator.DOCUMENT;
    private final DriveClientFactory _driveFactory;

    public DriveDocumentSearchResultBadgePresenter(ClientFactory clientFactory, DriveDocumentSearchResultBadgeModel model, boolean displayPublicationDate, boolean displayParents, boolean displayContextSwitch, @Nullable SearchTrackingInfo searchTrackingInfo, @Nullable String additionalOverlayStyleName) {
        super(clientFactory, displayContextSwitch, (SearchableId)model.getId(), searchTrackingInfo, additionalOverlayStyleName);
        this._driveFactory = clientFactory.driveFactory();
        this.setImage(model);
        this.setTitle(model);
        if (displayParents) {
            Optional widget;
            ParentItemInfo parent = model.getParentItemInfo();
            if (parent != null && (widget = (Optional)parent.getItemId().accept((ItemIdVisitor)new /* Unavailable Anonymous Inner Class!! */)).isPresent()) {
                this._view.setParentWidget((Widget)widget.get());
            }
        } else {
            this._view.setParentEnabled(false);
        }
        this.setLastChangeDate(model.getModifyDate());
        this.addPublicationDate(displayPublicationDate, model.getPublicationDate());
        this._view.addFoundIn((Collection)model.getFoundInFields(), (FieldNameResolver)DocumentFieldNameResolver.INSTANCE);
    }

    @Nonnull
    private SafeHtml createParentLinkTemplate(String name, String token) {
        return JucoSafeHtmlTemplates.INSTANCE.inlineHyperlink(StringUtil.breakWord((String)name), UriUtils.fromSafeConstant((String)("#" + token)));
    }

    @Nonnull
    private Widget createParentLink(String name, String token) {
        return new HTML(this.createParentLinkTemplate(name, token));
    }

    private void setTitle(DriveDocumentSearchResultBadgeModel model) {
        String name;
        FlowPanel titleWidget = new FlowPanel();
        String targetHistoryToken = this.token(model);
        Date archiveDate = model.getArchivedDate();
        if (archiveDate != null) {
            IconAnchor icon = EntityUtils.createArchivedIconAndTooltip((Date)archiveDate).createIconAnchor(targetHistoryToken, null);
            titleWidget.add((Widget)icon);
            titleWidget.add((Widget)new InlineLabel(" "));
        }
        if ((name = model.getName()) != null) {
            InlineHyperlink link = new InlineHyperlink(name, targetHistoryToken);
            link.setHTML(HTMLUtil.highlightedHtmlEscape((String)name));
            link.setTitle(HTMLUtil.removeHighlightTag((String)name));
            titleWidget.add((Widget)link);
            this._view.setTitleWidget((Widget)titleWidget, (Widget)link);
        }
    }

    @Nonnull
    private String token(DriveDocumentSearchResultBadgeModel model) {
        ParentItemInfo parentInfo = model.getParentItemInfo();
        return this._driveFactory.getHistoryToken((DriveDocumentId)model.getId(), model.getDocumentType(), parentInfo != null ? parentInfo.getItemId() : null);
    }

    private void setImage(DriveDocumentSearchResultBadgeModel model) {
        if (model.getDocumentType() == DriveDocumentSearchResultBadgeModel.DocumentType.FOLDER) {
            if (model.getParentItemInfo() != null) {
                this._view.setIconWidget((Widget)new HTML(this._driveFactory.getFolderIcon()));
            } else {
                this._view.setIconWidget((Widget)new HTML(this._driveFactory.getShareIcon()));
            }
        } else {
            String imageUrl = this._driveFactory.getIconUrlForMimeType(model.getMimeType());
            if (imageUrl != null) {
                this._view.setIconWidget((Widget)new Image(imageUrl));
            }
        }
    }
}

