/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.person.presentation.client.ui;

import com.freiheit.toro.client.ui.Heading;
import com.github.gwtbootstrap.client.ui.Icon;
import com.github.gwtbootstrap.client.ui.constants.IconType;
import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.ui.Anchor;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.Widget;
import de.justsoftware.gwt.user.client.ui.JucoTooltip;
import de.justsoftware.onx.common.presentation.client.ui.InlineFeedbackWidget;
import de.justsoftware.onx.common.presentation.client.ui.JCButton;
import de.justsoftware.onx.common.presentation.client.ui.WaitSpinner;
import de.justsoftware.onx.person.presentation.client.ui.AccountSettingsSection;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class AccountSettingsSection
extends Composite {
    private static final AccountSettingsSectionUIBinder UI_BINDER = (AccountSettingsSectionUIBinder)GWT.create(AccountSettingsSectionUIBinder.class);
    @UiField
    HorizontalPanel _caption;
    @UiField
    FlowPanel _headline;
    @UiField
    SimplePanel _content;
    @UiField
    JCButton _saveButton;
    @UiField
    WaitSpinner _waitIcon;
    @UiField
    InlineFeedbackWidget _feedbackWidget;
    @UiField
    Anchor _edit;
    @UiField
    Anchor _cancel;
    private boolean _initialized = false;
    private boolean _visible = false;
    private boolean _hasChanges = false;
    private final FillSectionHandler _fillSectionHandler;
    private HandlerRegistration _saveButtonHandlerRegistration;
    private HandlerRegistration _cancelButtonHandlerRegistration;

    public AccountSettingsSection(String headline, boolean first, @Nonnull FillSectionHandler fillSectionHandler) {
        this._fillSectionHandler = fillSectionHandler;
        this.initWidget((Widget)UI_BINDER.createAndBindUi((Object)this));
        if (first) {
            this.addStyleDependentName("first");
        }
        this.setDisplayLoading(false);
        this.setCaption(headline);
        this.expand(false);
    }

    public void expandAndReset(boolean expand) {
        this.hasChanges(false);
        this._content.clear();
        this.hideErrorMessages();
        this._initialized = false;
        this.expand(expand);
    }

    public void setCaption(@Nonnull String headline) {
        this._headline.add((Widget)new Heading(headline, 2));
    }

    public void addCaptionTooltip(@Nonnull String tooltipText) {
        JucoTooltip tooltip = new JucoTooltip(tooltipText);
        tooltip.addStyleName("tooltip-icon");
        tooltip.add((Widget)new Icon(IconType.INFO_SIGN));
        this._headline.add((Widget)tooltip);
    }

    public void setContent(IsWidget widget) {
        this._content.add(widget);
        this.setDisplayLoading(false);
    }

    public void setSaveClickHandler(@Nullable ClickHandler handler) {
        if (this._saveButtonHandlerRegistration != null) {
            this._saveButtonHandlerRegistration.removeHandler();
            this._saveButtonHandlerRegistration = null;
        }
        if (handler != null) {
            this._saveButtonHandlerRegistration = this._saveButton.addClickHandler(handler);
        }
    }

    public void setCancelClickHandler(@Nonnull ClickHandler handler) {
        if (this._cancelButtonHandlerRegistration != null) {
            this._cancelButtonHandlerRegistration.removeHandler();
            this._cancelButtonHandlerRegistration = null;
        }
        if (handler != null) {
            this._cancelButtonHandlerRegistration = this._cancel.addClickHandler(handler);
        }
    }

    public void setDisplayLoading(boolean display) {
        this._saveButton.setEnabled(!display);
        this._waitIcon.setVisible(display);
    }

    public void hideErrorMessages() {
        this._feedbackWidget.hide();
    }

    public void showAndHideAfterDelay(String text, InlineFeedbackWidget.InlineType type) {
        this._feedbackWidget.showAndHideAfterDelay(text, type);
    }

    public void enableSaveButton(boolean enabled) {
        this._saveButton.setEnabled(enabled);
    }

    public void setButtonText(String text) {
        this._saveButton.setText(text);
    }

    public void displayCancelButton(boolean display) {
        this._cancel.setVisible(display);
    }

    public void expand(boolean expand) {
        this._visible = expand;
        if (expand) {
            if (!this._initialized) {
                this._initialized = true;
                this.setDisplayLoading(true);
                this._fillSectionHandler.fillSection(this);
            }
            this._caption.addStyleDependentName("expanded");
        } else {
            this._caption.removeStyleDependentName("expanded");
        }
        this._edit.setVisible(!expand);
        this._content.setVisible(expand);
        this._saveButton.setVisible(expand);
        this._cancel.setVisible(expand);
    }

    public boolean isExpanded() {
        return this._visible;
    }

    public void hasChanges(boolean hasChanges) {
        this._hasChanges = hasChanges;
    }

    public boolean hasChanges() {
        return this._hasChanges;
    }

    public void addExpandClickHandler(ClickHandler handler) {
        this._caption.addDomHandler((EventHandler)handler, ClickEvent.getType());
    }
}

