/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.person.presentation.client;

import com.freiheit.toro.common.shared.util.UrlUtil;
import com.google.common.collect.ImmutableSet;
import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.rpc.AsyncCallback;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.common.shared.model.ValidationResult;
import de.justsoftware.onx.common.shared.model.action.Action;
import de.justsoftware.onx.person.presentation.shared.PersonController;
import de.justsoftware.onx.person.presentation.shared.PersonControllerAsync;
import de.justsoftware.onx.person.shared.model.DBAccountSettings;
import de.justsoftware.onx.person.shared.model.EmailNotificationSettingsBean;
import de.justsoftware.onx.person.shared.model.PersonDetailsModel;
import de.justsoftware.onx.person.shared.model.PersonPopupModel;
import de.justsoftware.onx.person.shared.model.PersonTeaserModel;
import de.justsoftware.onx.person.shared.model.settings.ProfileSettings;
import java.util.List;
import java.util.Map;

public final class PersonMediator
implements PersonControllerAsync {
    private static final PersonMediator INSTANCE = new PersonMediator();
    private final PersonControllerAsync _personRemoteServiceAsync = (PersonControllerAsync)GWT.create(PersonController.class);

    private PersonMediator() {
        UrlUtil.setRemoteServiceUrl((Object)this._personRemoteServiceAsync, (String)"/person");
    }

    public static PersonMediator getInstance() {
        return INSTANCE;
    }

    public void getProfileSettings(PersonId personId, AsyncCallback<ProfileSettings> cb) {
        this._personRemoteServiceAsync.getProfileSettings(personId, cb);
    }

    public void getPersonDetailsModelById(PersonId personId, AsyncCallback<PersonDetailsModel> callback) {
        this._personRemoteServiceAsync.getPersonDetailsModelById(personId, callback);
    }

    public void getPersonTeaserModelsByIds(ImmutableSet<PersonId> ids, AsyncCallback<Map<PersonId, PersonTeaserModel>> callback) {
        this._personRemoteServiceAsync.getPersonTeaserModelsByIds(ids, callback);
    }

    public void getPersonTeaserModelById(PersonId id, AsyncCallback<PersonTeaserModel> callback) {
        this._personRemoteServiceAsync.getPersonTeaserModelById(id, callback);
    }

    public void deleteAccount(String password, AsyncCallback<Void> callback) {
        this._personRemoteServiceAsync.deleteAccount(password, callback);
    }

    public void deleteAccountAsSuperadmin(PersonId personId, AsyncCallback<Void> callback) {
        this._personRemoteServiceAsync.deleteAccountAsSuperadmin(personId, callback);
    }

    public void changeLanguageForLoggedInUser(String languageCode, AsyncCallback<Void> callback) {
        this._personRemoteServiceAsync.changeLanguageForLoggedInUser(languageCode, callback);
    }

    public void getAccountSettings(PersonId personId, AsyncCallback<DBAccountSettings> callback) {
        this._personRemoteServiceAsync.getAccountSettings(personId, callback);
    }

    public void validatePassword(String password, AsyncCallback<List<ValidationResult>> callback) {
        this._personRemoteServiceAsync.validatePassword(password, callback);
    }

    public void getEmailNotificationSettings(PersonId personId, AsyncCallback<EmailNotificationSettingsBean> callback) {
        this._personRemoteServiceAsync.getEmailNotificationSettings(personId, callback);
    }

    public void updateEmailNotificationSettings(EmailNotificationSettingsBean emailNotificationSettingsBean, AsyncCallback<Void> callback) {
        this._personRemoteServiceAsync.updateEmailNotificationSettings(emailNotificationSettingsBean, callback);
    }

    public void setPersonBlocked(PersonId personId, boolean block, AsyncCallback<Void> callback) {
        this._personRemoteServiceAsync.setPersonBlocked(personId, block, callback);
    }

    public void getPersonPopupModelById(PersonId personId, ImmutableSet<? extends Action> requiredActions, AsyncCallback<PersonPopupModel> callback) {
        this._personRemoteServiceAsync.getPersonPopupModelById(personId, requiredActions, callback);
    }

    public void updateEmailAddressForDifferentUser(PersonId affectedPerson, String newEmail, AsyncCallback<DBAccountSettings> callback) {
        this._personRemoteServiceAsync.updateEmailAddressForDifferentUser(affectedPerson, newEmail, callback);
    }

    public void updateOwnEmailAddress(String newEmail, String password, AsyncCallback<DBAccountSettings> callback) {
        this._personRemoteServiceAsync.updateOwnEmailAddress(newEmail, password, callback);
    }

    public void updateOwnPassword(String newPassword, String oldPassword, AsyncCallback<DBAccountSettings> callback) {
        this._personRemoteServiceAsync.updateOwnPassword(newPassword, oldPassword, callback);
    }

    public void updatePasswordForDifferentUser(PersonId affectedPerson, String newPassword, AsyncCallback<DBAccountSettings> callback) {
        this._personRemoteServiceAsync.updatePasswordForDifferentUser(affectedPerson, newPassword, callback);
    }

    public void setActivated(PersonId personId, boolean activated, AsyncCallback<Void> callback) {
        this._personRemoteServiceAsync.setActivated(personId, activated, callback);
    }
}

