/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.design.client.util;

import com.google.common.collect.ImmutableSet;
import com.google.gwt.dom.client.Document;
import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.Node;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.rpc.AsyncCallback;
import de.justsoftware.onx.container.presentation.client.ui.design.ThemeClientFactory;
import de.justsoftware.onx.design.client.util.WebResourceReloader;
import de.justsoftware.onx.design.shared.model.ThemeId;
import de.justsoftware.onx.design.shared.model.ThemeWebResource;
import de.justsoftware.onx.design.shared.model.WebResource;
import java.util.Set;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

/*
 * Exception performing whole class analysis ignored.
 */
@ParametersAreNonnullByDefault
public class WebResourceReloader {
    private static final String HREF = "href";
    private final ThemeClientFactory _clientFactory;

    public WebResourceReloader(ThemeClientFactory clientFactory) {
        this._clientFactory = clientFactory;
    }

    public void refreshStyles(Set<WebResource> resources, @Nullable ResourceReloadedCallback callback) {
        this._clientFactory.getController().getCurrentResourceUris(resources, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void loadThemeWhenNeeded(ThemeId themeId, @Nullable ResourceReloadedCallback callback) {
        ThemeWebResource themeResource = ThemeWebResource.of((ThemeId)themeId);
        Element styleElement = WebResourceReloader.getStyleElementForResource((WebResource)themeResource);
        if (styleElement != null) {
            callback.onResourcesReloaded();
        } else {
            this.refreshStyles((Set)ImmutableSet.of((Object)themeResource), callback);
        }
    }

    @CheckForNull
    private static Element getStyleElementForResource(WebResource resource) {
        return DOM.getElementById((String)WebResourceReloader.getIdForWebresource((WebResource)resource));
    }

    private static String getIdForWebresource(WebResource resource) {
        return resource.getGroupName() + "-css";
    }

    private void reloadStyleIfChanged(WebResource resource, String freshUri) {
        String currentUri;
        Element style = WebResourceReloader.getStyleElementForResource((WebResource)resource);
        if (style == null) {
            style = Document.get().createElement("link");
            style.setAttribute("rel", "stylesheet");
            style.setId(WebResourceReloader.getIdForWebresource((WebResource)resource));
            style.setAttribute("href", freshUri);
            Document.get().getHead().appendChild((Node)style);
        }
        if (!freshUri.equals(currentUri = style.getAttribute("href"))) {
            style.setAttribute("href", freshUri);
        }
    }
}

