/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.container.presentation.client.ui.version;

import com.freiheit.toro.client.ui.ConfirmPopup;
import com.freiheit.toro.common.shared.model.DateWithoutTimezone;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.ui.HasWidgets;
import de.justsoftware.onx.common.presentation.client.ClientFactory;
import de.justsoftware.onx.common.shared.model.EntityVersionClientModel;
import de.justsoftware.onx.common.shared.model.EntityVersionDetailsClientModel;
import de.justsoftware.onx.common.shared.model.action.StaticEntityAction;
import de.justsoftware.onx.container.presentation.client.ui.version.EntityVersionCompareRowView;
import de.justsoftware.onx.container.presentation.client.ui.version.EntityVersionCompareView;
import java.util.Date;
import javax.annotation.Nonnull;

public class EntityVersionCompareRowPresenter
implements EntityVersionCompareRowView.Presenter {
    private final ClientFactory _clientFactory;
    private final EntityVersionCompareRowView _view;
    private final EntityVersionCompareView.Presenter _parentPresenter;
    private EntityVersionClientModel _version;
    private boolean _showRestoreButton = false;

    public EntityVersionCompareRowPresenter(@Nonnull ClientFactory clientFactory, @Nonnull EntityVersionCompareView.Presenter parent) {
        this._clientFactory = clientFactory;
        this._view = this._clientFactory.entityVersionFactory().entityVersionCompareRowView((EntityVersionCompareRowView.Presenter)this);
        this._parentPresenter = parent;
    }

    public void show(EntityVersionDetailsClientModel entityVersion, EntityVersionClientModel firstVersion, EntityVersionClientModel secondVersion, HasWidgets parent) {
        this._version = entityVersion;
        this._view.setVersionString(entityVersion.getVersionString());
        this._view.setAuthor(entityVersion.getAuthor());
        this._view.setReviewer(entityVersion.getReviewers());
        String changeMessage = entityVersion.getChangeMessage();
        if (changeMessage != null) {
            this._view.setChangeMessage(changeMessage);
            this._view.setInfoButtonVisible(true);
        } else {
            this._view.setInfoButtonVisible(false);
        }
        this._view.setDeleteButtonVisible(entityVersion.getAllowedActions().contains((Object)StaticEntityAction.ENTITY_VERSION_DELETE_VERSION));
        this._view.setRestoreButtonVisible(this._showRestoreButton);
        DateWithoutTimezone creationDate = entityVersion.getCreationDate();
        String formatVersionDate = creationDate != null ? this._clientFactory.dateFormatter().formatDateTime((Date)creationDate) : "";
        this._view.setCreationDate(formatVersionDate);
        this._view.checkRadio1(firstVersion != null && firstVersion.getId().equals((Object)entityVersion.getId()));
        this._view.checkRadio2(secondVersion != null && secondVersion.getId().equals((Object)entityVersion.getId()));
        parent.add(this._view.asWidget());
    }

    public void setSelectedAsFirstVersion(boolean selected) {
        if (selected) {
            this._parentPresenter.setFirstVersion(this._version);
        }
    }

    public void setSelectionAsFirstVersionPossible(boolean selectable) {
        this._view.setRadio1Enabled(selectable);
        if (!selectable) {
            this._view.checkRadio1(false);
        }
    }

    public void setSelectedAsSecondVersion(boolean selected) {
        if (selected) {
            this._parentPresenter.setSecondVersion(this._version);
        }
    }

    public void setSelectionAsSecondVersionPossible(boolean selectable) {
        this._view.setRadio2Enabled(selectable);
        if (!selectable) {
            this._view.checkRadio2(false);
        }
    }

    public void setVersionClicked() {
        this._parentPresenter.singleVersionSelected(this._version);
    }

    @Nonnull
    public EntityVersionClientModel getVersion() {
        return this._version;
    }

    public void setShowRestoreButton(boolean showRestore) {
        this._showRestoreButton = showRestore;
    }

    public void deleteVersionClicked() {
        ConfirmPopup.makeConfirmPopup((String)this._clientFactory.entityVersionFactory().entityVersionConstants().deleteVersionMessage(this._version.getVersionString()), (ClickHandler)new /* Unavailable Anonymous Inner Class!! */, null, (ConfirmPopup.ButtonType)ConfirmPopup.ButtonType.YES_NO).show();
    }

    public void restoreVersionClicked() {
        ConfirmPopup.makeConfirmPopup((String)this._clientFactory.entityVersionFactory().entityVersionConstants().restoreVersionMessage(this._version.getVersionString()), (ClickHandler)new /* Unavailable Anonymous Inner Class!! */, null, (ConfirmPopup.ButtonType)ConfirmPopup.ButtonType.YES_NO).show();
    }
}

