/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.container.presentation.client.ui;

import com.freiheit.toro.client.mediator.I18nMediator;
import com.freiheit.toro.client.ui.ConfirmPopup;
import com.freiheit.toro.common.presentation.ui.PersonUtil;
import com.google.common.collect.ImmutableSet;
import com.google.gwt.core.client.GWT;
import com.google.gwt.uibinder.client.UiFactory;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.IsWidget;
import de.justsoftware.onx.common.presentation.client.ClientFactoryImpl;
import de.justsoftware.onx.common.presentation.client.ui.JCButton;
import de.justsoftware.onx.common.presentation.client.ui.PanelPagingWidget;
import de.justsoftware.onx.common.shared.model.PersonId;
import de.justsoftware.onx.container.presentation.client.MultiPersonSelectionMediator;
import de.justsoftware.onx.container.presentation.client.ui.MultiPersonSelect;
import de.justsoftware.onx.container.presentation.client.ui.NameEntityAdminPopup;
import de.justsoftware.onx.container.presentation.client.ui.PersonPopupPagingList;
import de.justsoftware.onx.container.presentation.client.ui.PersonSelectPopup;
import de.justsoftware.onx.container.presentation.client.ui.PersonSelectWidget;
import de.justsoftware.onx.container.shared.i18n.EntityConstants;
import de.justsoftware.onx.container.shared.i18n.EntityMessages;
import de.justsoftware.onx.container.shared.model.EntityId;
import de.justsoftware.onx.container.shared.model.EntityInfo;
import de.justsoftware.onx.container.shared.model.EntityType;
import de.justsoftware.onx.container.shared.model.PersonDetails;
import de.justsoftware.onx.person.shared.model.PersonBadgeModel;
import de.justsoftware.onx.person.shared.model.PersonTeaserModel;
import de.justsoftware.onx.searchnew.shared.model.PersonSuggest;
import javax.annotation.Nonnull;

public class NameEntityAdminPopup
extends PersonSelectPopup {
    private static final NameEntityAdminPopupUIBinder UI_BINDER = (NameEntityAdminPopupUIBinder)GWT.create(NameEntityAdminPopupUIBinder.class);
    @UiField
    PersonSelectWidget _personSelectWidget;
    @UiField
    PersonPopupPagingList _selectedPersonList;
    private final AdminOrCoAdmin _role;
    private final EntityInfo _entity;
    private final EntityConstants _entityConstants;
    private final EntityMessages _entityMessages;

    public NameEntityAdminPopup(@Nonnull AdminOrCoAdmin role, @Nonnull EntityInfo entity) {
        super(ImmutableSet.of(), false, true);
        this._role = role;
        this._entity = entity;
        this._entityConstants = I18nMediator.getEntityConstantsByEntityType((EntityType)((EntityType)entity.getType()));
        this._entityMessages = I18nMediator.getEntityMessagesByEntityType((EntityType)((EntityType)entity.getType()));
        this.setContent((IsWidget)UI_BINDER.createAndBindUi((Object)this));
        String caption = role == AdminOrCoAdmin.ADMIN ? this._entityConstants.makeAdmin() : this._entityConstants.makeCoAdmin();
        this.setText(caption);
        this._personSelectWidget.addOnSuggestionSelectHandler(event -> {
            PanelPagingWidget pager = this._selectedPersonList.getPager();
            boolean mayAddToList = this._role == AdminOrCoAdmin.COADMIN || pager.getCurrentPageData().size() < 1;
            PersonSuggest value = (PersonSuggest)this._personSelectWidget.getValue();
            if (mayAddToList && value != null && value.getId() != null) {
                MultiPersonSelectionMediator.getInstance().getSelectedPersonList(this.addCurrentSelection(ImmutableSet.of((Object)((PersonId)value.getId()))), pager.getOffset(), pager.getItemPerPage(), (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
            }
        });
        JCButton submit = new JCButton(caption);
        submit.addClickHandler(event -> {
            this.hide();
            PanelPagingWidget pager = this._selectedPersonList.getPager();
            pager.getWidgetProvider().getListAndCount(0, pager.getMaxCount(), (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
        });
        this.addButton(submit);
    }

    public void updatePersonPager() {
        this._selectedPersonList.getPager().update();
    }

    @UiFactory
    public PersonPopupPagingList createPersonPopupPagingList() {
        return new PersonPopupPagingList((MultiPersonSelect)this);
    }

    @UiFactory
    public EntityConstants getEntityConstants() {
        return this._entityConstants;
    }

    private void makeAdmin(@Nonnull PersonDetails adminDetails) {
        PersonBadgeModel admin = adminDetails.getPersonBadge();
        ConfirmPopup.makeConfirmPopup((String)I18nMediator.getEntityMessagesByEntityType((EntityType)((EntityType)this._entity.getType())).attentionXWillBecomeAdminAndYouWillBecomeCoAdmin(PersonUtil.fullName((PersonTeaserModel)admin)), clickEvent -> ClientFactoryImpl.INSTANCE.entityMemberClientFactory().clientService().makeAdmin((EntityId)this._entity.getId(), (EntityType)this._entity.getType(), (PersonId)admin.getId(), (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */), null, (ConfirmPopup.ButtonType)ConfirmPopup.ButtonType.YES_NO).show();
    }

    private void makeCoAdmins(@Nonnull ImmutableSet<PersonId> personIds) {
        ClientFactoryImpl.INSTANCE.entityMemberClientFactory().clientService().makeCoAdmins((EntityId)this._entity.getId(), (EntityType)this._entity.getType(), personIds, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    protected void runOnSuccess() {
    }
}

