/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.container.presentation.client.ui;

import com.freiheit.toro.client.mediator.I18nMediator;
import com.freiheit.toro.common.shared.util.ImageSize;
import com.freiheit.toro.common.shared.util.ImageUrlUtil;
import com.github.gwtbootstrap.client.ui.constants.IconType;
import com.google.common.base.MoreObjects;
import com.google.gwt.core.client.GWT;
import com.google.gwt.event.logical.shared.AttachEvent;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.HasWidgets;
import com.google.gwt.user.client.ui.InlineLabel;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.Panel;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.Widget;
import de.justsoftware.onx.appswitcher.shared.model.CoreApp;
import de.justsoftware.onx.common.presentation.client.ui.HoverWidgetAnchor;
import de.justsoftware.onx.common.presentation.client.ui.InlineFeedbackWidget;
import de.justsoftware.onx.common.presentation.client.ui.JCButton;
import de.justsoftware.onx.container.presentation.client.ui.EntityLogoCreator;
import de.justsoftware.onx.container.presentation.client.ui.InformationTabView;
import de.justsoftware.onx.container.presentation.client.ui.InformationTabViewImpl;
import de.justsoftware.onx.container.shared.i18n.EntityConstants;
import de.justsoftware.onx.container.shared.model.EntityType;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class InformationTabViewImpl
implements InformationTabView {
    private static final InformationTabViewImplUIBinder UI_BINDER = (InformationTabViewImplUIBinder)GWT.create(InformationTabViewImplUIBinder.class);
    @UiField(provided=true)
    final EntityConstants _entityConstants;
    final InlineLabel _followersLabel = new InlineLabel();
    final InlineLabel _visitsLabel = new InlineLabel();
    @UiField
    FlowPanel _baseData;
    @UiField
    JCButton _editButton;
    @UiField
    Panel _logoSection;
    @UiField
    SimplePanel _logo;
    @UiField
    Label _title;
    @UiField
    InlineFeedbackWidget _descriptionFeedback;
    @UiField
    SimplePanel _descriptionPanel;
    @UiField
    SimplePanel _privacySettingsPanel;
    private final Widget _widget;

    InformationTabViewImpl(EntityConstants entityConstants) {
        this._entityConstants = entityConstants;
        this._widget = (Widget)UI_BINDER.createAndBindUi((Object)this);
    }

    public Widget asWidget() {
        return this._widget;
    }

    public HasWidgets.ForIsWidget getBaseDataContainer() {
        return this._baseData;
    }

    public void showEditIcon(String editToken) {
        this._editButton.setTargetHistoryToken(editToken);
        this._editButton.setVisible(true);
    }

    public void hideEditIcon() {
        this._editButton.setVisible(false);
        this._editButton.setHref(null);
    }

    public void showEditableLogo(CoreApp app, EntityType entityType, String logo, String token) {
        Widget logoWidget = new EntityLogoCreator(ImageSize.LARGE).create(app, entityType, logo, true);
        if (logoWidget != null) {
            this._logo.setWidget((Widget)this.createLogoImageLink(logoWidget, token));
        }
        this._logoSection.setVisible(true);
    }

    public void showLogo(CoreApp app, EntityType entityType, String logo) {
        Widget logoWidget = new EntityLogoCreator(ImageSize.LARGE).create(app, entityType, logo, true);
        if (logoWidget != null) {
            this._logo.setWidget(logoWidget);
        }
        this._logoSection.setVisible(true);
    }

    public void hideLogo() {
        this._logoSection.setVisible(false);
        this._logo.clear();
    }

    @Nonnull
    private static String logoUrl(EntityType entityType, @Nullable String logo) {
        return ImageUrlUtil.getFullEntityImageUrl((EntityType)entityType, (ImageSize)ImageSize.LARGE, (String)logo);
    }

    @Nonnull
    private HoverWidgetAnchor createLogoImageLink(Widget logo, String token) {
        HoverWidgetAnchor link = new HoverWidgetAnchor();
        link.setIcon(IconType.UPLOAD);
        link.setTitle(this._entityConstants.uploadLogo());
        link.setWidget((IsWidget)logo);
        link.setTargetHistoryToken(token);
        return link;
    }

    public void setTitle(String title) {
        this._title.setText(title);
    }

    public HandlerRegistration addAttachHandler(AttachEvent.Handler handler) {
        return this._widget.addAttachHandler(handler);
    }

    public void showDescriptionSaveError(String message) {
        this._descriptionFeedback.showAndHideAfterDelay(I18nMediator.EXCEPTION.serviceException() + " " + (String)MoreObjects.firstNonNull((Object)message, (Object)""));
    }

    public void setDescriptionEditorView(IsWidget view) {
        this._descriptionPanel.setWidget(view);
        this._descriptionPanel.setVisible(true);
    }

    public void hideDescriptionEditorView() {
        this._descriptionPanel.clear();
        this._descriptionPanel.setVisible(false);
    }

    public void setPrivacySettingsView(IsWidget view) {
        this._privacySettingsPanel.setWidget(view);
        this._privacySettingsPanel.setVisible(true);
    }

    public void hidePrivacySettingsView() {
        this._privacySettingsPanel.clear();
        this._privacySettingsPanel.setVisible(false);
    }

    public IsWidget getVisitsWidget() {
        return this._visitsLabel;
    }

    public void updateVisitsWidget(int visitsCount) {
        this._visitsLabel.setText(String.valueOf(visitsCount));
    }

    public IsWidget getFollowersWidget() {
        return this._followersLabel;
    }

    public void updateFollowersWidget(int followersCount) {
        this._followersLabel.setText(String.valueOf(followersCount));
    }
}

