/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.container.presentation.client.presenter;

import com.freiheit.toro.client.mediator.I18nMediator;
import com.freiheit.toro.util.client.HostPropertiesMediator;
import de.justsoftware.onx.common.shared.i18n.DateFormatter;
import de.justsoftware.onx.common.shared.model.ClientEntityConfig;
import de.justsoftware.onx.container.presentation.client.EntityVersionClientFactory;
import de.justsoftware.onx.container.shared.i18n.EntityVersionConstants;
import de.justsoftware.onx.container.shared.model.EntityType;
import de.justsoftware.onx.container.shared.model.EntityVersionReviewData;
import de.justsoftware.onx.container.shared.model.ReleaseProcessStatus;
import de.justsoftware.onx.person.presentation.client.ui.ReviewsView;
import de.justsoftware.onx.person.presentation.client.ui.presenter.ReviewsPresenter;
import javax.annotation.Nonnull;

public class EntityReleaseStatePopupPresenter
extends ReviewsPresenter {
    private final EntityVersionConstants _versionMessages = I18nMediator.LOCALIZED_MESSAGES.entityVersionConstants();

    public EntityReleaseStatePopupPresenter(@Nonnull EntityVersionClientFactory entityVersionClientFactory, @Nonnull DateFormatter dateFormatter, @Nonnull EntityVersionReviewData reviewData, @Nonnull ReviewsView.PopupClosedCallback callback) {
        super(entityVersionClientFactory, dateFormatter, reviewData, callback);
    }

    protected void updateView(EntityVersionReviewData reviewData) {
        ClientEntityConfig config = HostPropertiesMediator.getClientEntityConfig((EntityType)((EntityType)reviewData.getToReview().getType()));
        this._view.setHeader(this._versionMessages.releaseProcess());
        this._view.addInviter(reviewData.getInviter());
        this._view.addEntity(reviewData.getToReview());
        this._view.addReviewersRow(reviewData);
        if (config.getReleaseActivationDateVisibility().isVisibleOption()) {
            this._view.addReleaseDate(reviewData.getReleaseDate(), true);
        }
        if (config.getReleaseExpirationDateVisibility().isVisibleOption()) {
            this._view.addExpirationDate(reviewData.getExpirationDate(), true);
        }
        if (config.getReleaseChangeMessageVisibility().isVisibleOption()) {
            this._view.addChangeMessage(reviewData.getChangeMessage());
        }
        if (config.getReleaseCommentForReviewerVisibility().isVisibleOption()) {
            this._view.addCommentForReviewers(reviewData.getCommentForReviewer());
        }
        if (reviewData.mayAccept()) {
            this._view.activateAcceptAction();
        }
        if (reviewData.mayDecline()) {
            this._view.activateDeclineAction();
            this._view.setDeclineMessage(reviewData.getDeclineMessage(), true);
        } else if (ReleaseProcessStatus.DECLINED.getName().equals(reviewData.getVersionStatus().getName())) {
            this._view.setDeclineMessage(reviewData.getDeclineMessage(), false);
        }
        this._view.activateCloseAction();
    }
}

