/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.container.presentation.client;

import com.freiheit.toro.common.shared.model.DateWithoutTimezone;
import com.freiheit.toro.common.shared.util.UrlUtil;
import com.google.common.collect.ImmutableSet;
import com.google.gwt.core.shared.GWT;
import com.google.gwt.user.client.rpc.AsyncCallback;
import de.justsoftware.onx.common.presentation.client.ClientFactory;
import de.justsoftware.onx.common.shared.model.EntityVersionClientModel;
import de.justsoftware.onx.common.shared.model.EntityVersionDetailsClientModel;
import de.justsoftware.onx.common.shared.model.ListAndCount;
import de.justsoftware.onx.container.presentation.client.EntityVersionControllerAsyncImpl;
import de.justsoftware.onx.container.presentation.shared.EntityVersionController;
import de.justsoftware.onx.container.presentation.shared.EntityVersionControllerAsync;
import de.justsoftware.onx.container.shared.model.EntityBadge;
import de.justsoftware.onx.container.shared.model.EntityId;
import de.justsoftware.onx.container.shared.model.EntityVersionId;
import de.justsoftware.onx.container.shared.model.EntityVersionReleaseClientModel;
import de.justsoftware.onx.container.shared.model.EntityVersionReviewData;
import de.justsoftware.onx.validation.shared.model.JucoConstraintViolation;

public class EntityVersionControllerAsyncImpl
implements EntityVersionControllerAsync {
    private final EntityVersionControllerAsync _controller = (EntityVersionControllerAsync)GWT.create(EntityVersionController.class);
    private final ClientFactory _clientFactory;

    public EntityVersionControllerAsyncImpl(ClientFactory clientFactory) {
        UrlUtil.setRemoteServiceUrl((Object)this._controller, (String)"/entityVersion");
        this._clientFactory = clientFactory;
    }

    public void startReleaseProcess(EntityVersionReleaseClientModel releaseData, AsyncCallback<EntityVersionClientModel> callback) {
        this._controller.startReleaseProcess(releaseData, (AsyncCallback)new EntityVersionChangedEventInterceptor(this, callback));
    }

    public void getCurrentEntityVersion(EntityId entityId, AsyncCallback<EntityVersionClientModel> callback) {
        this._controller.getCurrentEntityVersion(entityId, callback);
    }

    public void getVersionDetails(EntityId entityId, int limit, int offset, AsyncCallback<ListAndCount<EntityVersionDetailsClientModel>> callback) {
        this._controller.getVersionDetails(entityId, limit, offset, callback);
    }

    public void updateReadDateByEntityVersionId(EntityVersionId id, AsyncCallback<Void> callback) {
        this._controller.updateReadDateByEntityVersionId(id, callback);
    }

    public void getVersionReviewData(EntityVersionId entityVersionId, AsyncCallback<EntityVersionReviewData> callback) {
        this._controller.getVersionReviewData(entityVersionId, callback);
    }

    public void acceptRelease(EntityVersionId versionId, DateWithoutTimezone newReleaseDate, DateWithoutTimezone newExpirationDate, AsyncCallback<EntityVersionClientModel> callback) {
        this._controller.acceptRelease(versionId, newReleaseDate, newExpirationDate, (AsyncCallback)new EntityVersionReviewChangedInterceptor(this, callback));
    }

    public void cancelReleaseProcess(EntityVersionId versionId, String declineMessage, AsyncCallback<EntityVersionClientModel> callback) {
        this._controller.cancelReleaseProcess(versionId, declineMessage, (AsyncCallback)new EntityVersionReviewChangedInterceptor(this, callback));
    }

    public void getWikiCompareData(EntityVersionId firstVersion, EntityVersionId secondVersionId, AsyncCallback<String> callback) {
        this._controller.getWikiCompareData(firstVersion, secondVersionId, callback);
    }

    public void getWikiVersionAsHtmlString(EntityVersionId versionId, AsyncCallback<String> callback) {
        this._controller.getWikiVersionAsHtmlString(versionId, callback);
    }

    public void deleteVersion(EntityVersionId versionId, AsyncCallback<EntityId> callback) {
        this._controller.deleteVersion(versionId, (AsyncCallback)new EntityVersionDeletedEventInterceptor(this, callback));
    }

    public void restoreVersion(EntityVersionId versionId, AsyncCallback<EntityVersionClientModel> callback) {
        this._controller.restoreVersion(versionId, (AsyncCallback)new EntityVersionChangedEventInterceptor(this, callback));
    }

    public void getMyDrafts(int offset, int limit, AsyncCallback<ListAndCount<EntityBadge>> callback) {
        this._controller.getMyDrafts(offset, limit, callback);
    }

    public void getMyDraftCount(AsyncCallback<Integer> callback) {
        this._controller.getMyDraftCount(callback);
    }

    public void validate(EntityVersionReviewData validationModel, AsyncCallback<ImmutableSet<JucoConstraintViolation>> callback) {
        this._controller.validate(validationModel, callback);
    }

    public void archiveVersion(EntityId entityId, EntityVersionId entityVersionId, AsyncCallback<EntityVersionClientModel> callback) {
        this._controller.archiveVersion(entityId, entityVersionId, (AsyncCallback)new EntityVersionChangedEventInterceptor(this, callback));
    }
}

