/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.common.presentation.client.ui.components;

import com.freiheit.toro.client.mediator.I18nMediator;
import com.freiheit.toro.util.client.WidgetUtil;
import com.google.common.collect.ImmutableList;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.Hyperlink;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.Panel;
import com.google.gwt.user.client.ui.Widget;
import de.justsoftware.onx.common.presentation.client.ClientFactory;
import de.justsoftware.onx.common.presentation.client.ui.InfoBoxWidget;
import de.justsoftware.onx.common.presentation.client.ui.JucoIconTypes;
import de.justsoftware.onx.common.presentation.client.ui.components.EntityWithDurationListWidget;
import de.justsoftware.onx.common.shared.i18n.BasicConstants;
import de.justsoftware.onx.container.presentation.client.EntityChildrenMediator;
import de.justsoftware.onx.container.shared.i18n.EntityConstants;
import de.justsoftware.onx.container.shared.model.ChildEntityTeaserSortType;
import de.justsoftware.onx.container.shared.model.EntityId;
import de.justsoftware.onx.container.shared.model.EntityType;
import de.justsoftware.onx.container.shared.model.teasers.TeaserType;
import de.justsoftware.onx.searchnew.presentation.client.ClientSearchConfigurationProvider;
import de.justsoftware.onx.searchnew.presentation.client.SearchHandler;
import de.justsoftware.onx.searchnew.shared.model.ArchiveSubFilter;
import de.justsoftware.onx.searchnew.shared.model.DateSubFilter;
import de.justsoftware.onx.searchnew.shared.model.FilterType;
import de.justsoftware.onx.searchnew.shared.model.FilterTypes;
import de.justsoftware.onx.searchnew.shared.model.SearchContext;
import de.justsoftware.onx.searchnew.shared.model.SearchParameters;
import de.justsoftware.onx.searchnew.shared.model.SubFilter;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class EntityWithDurationListWidget
extends InfoBoxWidget {
    private static final BasicConstants BASIC = I18nMediator.BASIC_CONSTANTS;
    private final EntityConstants _entityConstants;
    private final EntityId _parentId;
    private final SearchParameters _searchParameters;
    private final ClientFactory _clientFactory;
    private final ClickHandler _addHandler = new /* Unavailable Anonymous Inner Class!! */;
    private final EntityType _entityType;

    public EntityWithDurationListWidget(@Nonnull ClientFactory clientFactory, @Nonnull EntityId parentId, boolean showAddLink, @Nonnull EntityType childType, boolean simplePager, @Nonnull TeaserType teaserType, int numberOfTeasers, @Nonnull ChildEntityTeaserSortType childEntityTeaserSortOrder, @Nullable String customizedTitle) {
        this._entityType = childType;
        this._parentId = parentId;
        this._entityConstants = I18nMediator.getEntityConstantsByEntityType((EntityType)this._entityType);
        this._clientFactory = clientFactory;
        FlowPanel content = new FlowPanel();
        this.setContent((Widget)content);
        SearchContext searchContext = SearchContext.ENTITY;
        this._searchParameters = SearchHandler.parameters((FilterType)FilterTypes.getByEntityType((EntityType)this._entityType), (SearchContext)searchContext, (EntityId)this._parentId).withChildEntityTeaserSortType(childEntityTeaserSortOrder).withDefaultSubfilter(ClientSearchConfigurationProvider.INSTANCE);
        String allUpcomingToken = SearchHandler.tokenFor((SearchParameters)this._searchParameters.withAdditionalSubfilter((SubFilter)DateSubFilter.FUTURE));
        String labelTitle = customizedTitle == null ? I18nMediator.getEntityConstantsByEntityType((EntityType)this._entityType).childEntities(this._entityType) : customizedTitle;
        this.setLabel((Widget)new Hyperlink(labelTitle, allUpcomingToken));
        this.setTitle(labelTitle);
        if (showAddLink) {
            this.addActionIcon(JucoIconTypes.ADD, this._addHandler, BASIC.add());
        }
        MonthViewActionIconAnchor monthViewAction = new MonthViewActionIconAnchor(this, clientFactory, showAddLink);
        this.addAction((Widget)monthViewAction);
        if (childEntityTeaserSortOrder != ChildEntityTeaserSortType.RANDOM) {
            AppointmentTeasersPager pager = new AppointmentTeasersPager(this, monthViewAction, teaserType, numberOfTeasers, (Panel)new FlowPanel(), childEntityTeaserSortOrder);
            pager.setSimplePager(simplePager);
            pager.setNoDataWidget(this.createNoDataWidget(showAddLink));
            content.add((Widget)pager);
        } else {
            EntityChildrenMediator.getInstance().getRandomChildrenTeasers(childType, this._parentId, teaserType, numberOfTeasers, ImmutableList.of((Object)DateSubFilter.FUTURE, (Object)ArchiveSubFilter.NON_ARCHIVED), (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
        }
    }

    @Nonnull
    private Widget createNoDataWidget(boolean mayAdd) {
        FlowPanel result = new FlowPanel();
        if (mayAdd) {
            result.add(WidgetUtil.insertNoHistoryHyperlink((String)this._entityConstants.noChildEntitiesCreateOne(this._entityType), (ClickHandler)this._addHandler));
        } else {
            result.add((Widget)new Label(this._entityConstants.noChildEntities(this._entityType)));
        }
        return result;
    }
}

