/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.common.presentation.client.ui.components;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.gwt.user.client.ui.HasVisibility;
import com.google.gwt.user.client.ui.HasWidgets;
import com.google.gwt.user.client.ui.IsWidget;
import de.justsoftware.onx.administration.presentation.client.AdministrationClientFactory;
import de.justsoftware.onx.common.presentation.client.ui.PersonRoleListItem;
import de.justsoftware.onx.common.presentation.client.ui.components.AuthorityListView;
import java.util.Map;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class AuthorityListPresenter
implements AuthorityListView.AuthorityListViewPresenter {
    private final Map<String, PersonRoleListItem> _selectedAuthorities;
    @CheckForNull
    private AuthorityListView.SelectionChangedHandler _handler;
    private final ImmutableList<PersonRoleListItem> _authorities;
    private final AdministrationClientFactory _clientFactory;

    public AuthorityListPresenter(AdministrationClientFactory clientFactory, ImmutableList<PersonRoleListItem> authorities, ImmutableSet<String> selectedAuthorities) {
        this._clientFactory = clientFactory;
        this._authorities = authorities;
        this._selectedAuthorities = Maps.newHashMap((Map)FluentIterable.from(authorities).filter(Predicates.compose((Predicate)Predicates.in(selectedAuthorities), (Function)PersonRoleListItem.TO_UNIQUE_KEY)).uniqueIndex(PersonRoleListItem.TO_UNIQUE_KEY));
    }

    @Nonnull
    private AuthorityListView createView() {
        AuthorityListView view = this._clientFactory.getAuthorityListView((AuthorityListView.AuthorityListViewPresenter)this);
        for (PersonRoleListItem authority : this._authorities) {
            view.addAuthority(authority, this._selectedAuthorities.containsKey(authority.getUniqueKey()));
        }
        return view;
    }

    public void authorityDeselected(PersonRoleListItem authority) {
        this._selectedAuthorities.remove(authority.getUniqueKey());
        this.notify(authority);
    }

    public void authoritySelected(PersonRoleListItem authority) {
        this._selectedAuthorities.put(authority.getUniqueKey(), authority);
        this.notify(authority);
    }

    private void notify(PersonRoleListItem authority) {
        if (this._handler != null) {
            this._handler.onSelectionChanged(this.getSelected(), authority);
        }
    }

    public void setSelectionChangedHandler(AuthorityListView.SelectionChangedHandler handler) {
        this._handler = handler;
    }

    @Nonnull
    public ImmutableSet<String> getSelected() {
        return ImmutableSet.copyOf(this._selectedAuthorities.keySet());
    }

    public boolean isContainsVisibleAuthorities() {
        return Iterables.any((Iterable)this._authorities, (Predicate)PersonRoleListItem.IS_VISIBLE);
    }

    @Nonnull
    public AuthorityListPresenter show(HasWidgets.ForIsWidget parentWidget) {
        return this.show(parentWidget, null);
    }

    @Nonnull
    public AuthorityListPresenter show(HasWidgets.ForIsWidget parentWidget, @Nullable HasVisibility section) {
        boolean containsVisibleAuthorities = this.isContainsVisibleAuthorities();
        if (containsVisibleAuthorities) {
            parentWidget.add((IsWidget)this.createView());
        }
        if (section != null) {
            section.setVisible(containsVisibleAuthorities);
        }
        return this;
    }
}

