/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.common.presentation.client.ui;

import com.freiheit.toro.util.client.HostPropertiesMediator;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import de.justsoftware.onx.common.shared.model.AuthorityModel;
import java.util.Collection;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class PersonRoleListItem {
    public static final Predicate<PersonRoleListItem> IS_VISIBLE = new /* Unavailable Anonymous Inner Class!! */;
    public static final Function<PersonRoleListItem, String> TO_UNIQUE_KEY = new /* Unavailable Anonymous Inner Class!! */;
    private static final Function<AuthorityModel, PersonRoleListItem> TO_LIST_ITEM = new /* Unavailable Anonymous Inner Class!! */;
    private final String _rolename;
    private final String _i18nName;
    private final AuthorityModel.Modifier _modifier;

    public PersonRoleListItem(String rolename, AuthorityModel.Modifier modifier) {
        this._rolename = rolename;
        this._i18nName = HostPropertiesMediator.getHostPropertiesBean().getPersonRolesTranslation().getDisplayName(rolename);
        this._modifier = modifier;
    }

    @Nonnull
    public String getName() {
        return this._i18nName;
    }

    @Nonnull
    public String getUniqueKey() {
        return this._rolename;
    }

    @Nonnull
    public AuthorityModel.Modifier getModifier() {
        return this._modifier;
    }

    @Nonnull
    public static ImmutableList<PersonRoleListItem> fromAuthorityModelList(Collection<? extends AuthorityModel> roles) {
        return FluentIterable.from(roles).transform(TO_LIST_ITEM).toList();
    }
}

