/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.common.presentation.client.ui;

import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.user.client.ui.FlexTable;
import com.google.gwt.user.client.ui.HasVerticalAlignment;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.RadioButton;
import com.google.gwt.user.client.ui.Widget;
import de.justsoftware.onx.common.presentation.client.ui.CompositePanelWithValue;
import de.justsoftware.onx.common.presentation.client.ui.EnumOptionI18NResolver;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;

public class EnumRadioButtonWidget<T extends Enum<T>>
extends CompositePanelWithValue<T> {
    private final Class<T> _enumClass;
    private final String _radioGroupName;
    private final EnumOptionI18NResolver<T> _enumOptionI18NResolver;
    private final Map<T, RadioButton> _radioButtons;
    private final FlexTable _mainTable;

    public EnumRadioButtonWidget(Class<T> enumClass, String radioGroupName) {
        this(enumClass, radioGroupName, null);
    }

    public EnumRadioButtonWidget(Class<T> enumClass, String radioGroupName, EnumOptionI18NResolver<T> enumOptionI18NResolver) {
        this._enumClass = enumClass;
        this._radioGroupName = radioGroupName;
        this._enumOptionI18NResolver = enumOptionI18NResolver;
        EnumSet<Enum> enumSet = EnumSet.allOf(this._enumClass);
        this._radioButtons = new HashMap(enumSet.size());
        this._mainTable = new FlexTable();
        this.add((Widget)this._mainTable);
        for (Enum val : enumSet) {
            int currentRow = this._mainTable.getRowCount();
            String labelText = this._enumOptionI18NResolver == null ? val.name() : this._enumOptionI18NResolver.getI18NText(val);
            RadioButton button = new RadioButton(this._radioGroupName);
            Label label = new Label(labelText);
            this._mainTable.setWidget(currentRow, 0, (Widget)button);
            this._mainTable.setWidget(currentRow, 1, (Widget)label);
            this._mainTable.getCellFormatter().setVerticalAlignment(currentRow, 0, HasVerticalAlignment.ALIGN_TOP);
            this._mainTable.getCellFormatter().setVerticalAlignment(currentRow, 1, HasVerticalAlignment.ALIGN_MIDDLE);
            this._radioButtons.put(val, button);
            button.addValueChangeHandler((ValueChangeHandler)new /* Unavailable Anonymous Inner Class!! */);
            label.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
            label.addStyleName("cursorPointer");
        }
    }

    public void setEnabled(T option, boolean enabled) {
        RadioButton radioButton = (RadioButton)this._radioButtons.get(option);
        if (radioButton != null) {
            radioButton.setEnabled(enabled);
        }
    }

    public void setVisible(T option, boolean visible) {
        RadioButton radioButton = (RadioButton)this._radioButtons.get(option);
        if (radioButton != null) {
            radioButton.setVisible(visible);
            for (int row = 0; row < this._mainTable.getRowCount(); ++row) {
                Widget widget = this._mainTable.getWidget(row, 0);
                if (!(widget instanceof RadioButton) || !widget.equals(radioButton)) continue;
                Widget labelWidget = this._mainTable.getWidget(row, 1);
                labelWidget.setVisible(visible);
            }
        }
    }

    public void setValue(T value, boolean fireEvents) {
        for (Enum val : EnumSet.allOf(this._enumClass)) {
            ((RadioButton)this._radioButtons.get(val)).setValue(Boolean.valueOf(val.equals(value)), false);
        }
        super.setValue(value, fireEvents);
    }
}

