/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.common.presentation.client.presenter;

import com.github.gwtbootstrap.client.ui.constants.IconType;
import com.google.common.base.Optional;
import de.justsoftware.onx.authorization.presentation.client.LoginManager;
import de.justsoftware.onx.common.presentation.client.AsyncClickHandler;
import de.justsoftware.onx.common.presentation.client.ClientFactory;
import de.justsoftware.onx.common.presentation.client.model.Promise;
import de.justsoftware.onx.common.presentation.client.presenter.EntityOptionsPresenter;
import de.justsoftware.onx.common.presentation.client.ui.EntityOptionsView;
import de.justsoftware.onx.common.shared.model.EntityVersionClientModel;
import de.justsoftware.onx.common.shared.model.action.Action;
import de.justsoftware.onx.common.shared.model.action.StaticEntityAction;
import de.justsoftware.onx.container.presentation.client.EntityClientFactory;
import de.justsoftware.onx.container.presentation.client.EntityMemberClientFactory;
import de.justsoftware.onx.container.presentation.shared.model.EventMembershipChangeResult;
import de.justsoftware.onx.container.shared.i18n.EntityConstants;
import de.justsoftware.onx.container.shared.model.EntityDetailsPublicData;
import de.justsoftware.onx.container.shared.model.EntityId;
import de.justsoftware.onx.container.shared.model.EntityType;
import de.justsoftware.onx.container.shared.model.MyMemberStatus;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class EntityOptionsPresenter {
    private final ClientFactory _clientFactory;
    private final EntityOptionsView _view;
    private final EntityClientFactory _entityFactory;
    private final EntityMemberClientFactory _entityMemberClientFactory;

    public EntityOptionsPresenter(ClientFactory clientFactory) {
        this._clientFactory = clientFactory;
        this._entityFactory = clientFactory.entityFactory();
        this._entityMemberClientFactory = clientFactory.entityMemberClientFactory();
        this._view = this._entityFactory.getEntityOptionsView();
    }

    @Nonnull
    public EntityOptionsView getView() {
        return this._view;
    }

    public void showOptionsForEntity(EntityDetailsPublicData entity, @Nullable EntityVersionClientModel entityVersion) {
        this.showAllowedActions(entity, entityVersion, entity.getMay(), entity.getMyMemberStatus());
    }

    private void updateAllowedActions(EntityDetailsPublicData entity, @Nullable EntityVersionClientModel entityVersion, EventMembershipChangeResult result) {
        this.showAllowedActions(entity, entityVersion, (Set)result.getActions(), result.getMemberStatus());
    }

    private void showAllowedActions(EntityDetailsPublicData entity, @Nullable EntityVersionClientModel entityVersion, Set<? extends Action> may, MyMemberStatus memberStatus) {
        EntityConstants entityConstants = this._entityFactory.entityConstants((EntityType)entity.getType());
        this._view.resetButtons();
        this._clientFactory.loginManager().isLoggedIn((LoginManager.LoginCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void updateButtons(EntityDetailsPublicData entity, @Nullable EntityVersionClientModel entityVersion, EntityConstants entityConstants, Set<? extends Action> may, boolean isLoggedIn, @Nullable MyMemberStatus currentStatus) {
        switch (2.$SwitchMap$de$justsoftware$onx$container$shared$model$EntityMemberWorkflow[entity.getMemberWorkflow().ordinal()]) {
            case 1: {
                this.addEventButtons(entity, entityVersion, entityConstants, may, isLoggedIn, currentStatus);
                break;
            }
            case 2: {
                this.addMembershipButtons(entity, entityVersion, entityConstants, may, isLoggedIn);
            }
        }
        if (isLoggedIn) {
            this._view.addEntitySubscribeButton(entity);
        }
    }

    private void addEventButtons(EntityDetailsPublicData entity, @Nullable EntityVersionClientModel entityVersion, EntityConstants entityConstants, Set<? extends Action> may, boolean isLoggedIn, MyMemberStatus currentStatus) {
        if (isLoggedIn) {
            this.addEventStatusButton(entityConstants, currentStatus);
            if (may.contains(StaticEntityAction.EVENT_ATTEND)) {
                this._view.addChangeMembershipOption(EntityOptionsView.NO_ICON, entityConstants.attendEvent(), EntityOptionsView.NO_TOOLTIP, (AsyncClickHandler)new AttendEventClickHandler(this, entity, entityVersion, this._clientFactory.overlayNotificationClientFactory(), this._clientFactory.eventManager()));
            }
            if (may.contains(StaticEntityAction.EVENT_MAYBE_ATTEND)) {
                this._view.addChangeMembershipOption(EntityOptionsView.NO_ICON, entityConstants.maybeAttendEvent(), EntityOptionsView.NO_TOOLTIP, (AsyncClickHandler)new MaybeAttendEventClickHandler(this, entity, entityVersion, this._clientFactory.eventManager()));
            }
            if (may.contains(StaticEntityAction.EVENT_DONT_ATTEND)) {
                this._view.addChangeMembershipOption(EntityOptionsView.NO_ICON, entityConstants.dontAttendEvent(), EntityOptionsView.NO_TOOLTIP, (AsyncClickHandler)new DontAttendEventClickHandler(this, entity, entityVersion, this._clientFactory.eventManager()));
            }
            if (may.contains(StaticEntityAction.ENTITY_LEAVE)) {
                if (may.contains(StaticEntityAction.ENTITY_ACCEPT_INVITE)) {
                    this._view.addChangeMembershipOption(EntityOptionsView.NO_ICON, entityConstants.rejectInvitationToEvent(), EntityOptionsView.NO_TOOLTIP, (AsyncClickHandler)new RejectEventInvitationClickHandler(this, entity, entityVersion));
                } else {
                    this._view.addChangeMembershipOption(EntityOptionsView.NO_ICON, entityConstants.leaveEntity(), EntityOptionsView.NO_TOOLTIP, (AsyncClickHandler)new LeaveEntityClickHandler(entity));
                }
            }
        }
    }

    private void addEventStatusButton(EntityConstants entityConstants, MyMemberStatus currentStatus) {
        switch (2.$SwitchMap$de$justsoftware$onx$container$shared$model$MyMemberStatus$PublicEventStatus[currentStatus.getEventStatus().ordinal()]) {
            case 1: {
                this._view.setCurrentEventMembership(IconType.OK, entityConstants.youAreAttending());
                break;
            }
            case 2: {
                this._view.setCurrentEventMembership(null, entityConstants.onWaitinglistOfEvent());
                break;
            }
            case 3: {
                this._view.setCurrentEventMembership(null, entityConstants.youAreNotAttending());
                break;
            }
            case 4: {
                this._view.setCurrentEventMembership(null, entityConstants.youAreUndecided());
                break;
            }
        }
    }

    private void addMembershipButtons(EntityDetailsPublicData entity, @Nullable EntityVersionClientModel entityVersion, EntityConstants entityConstants, Set<? extends Action> may, boolean isLoggedIn) {
        if (isLoggedIn && may.contains(StaticEntityAction.ENTITY_JOIN)) {
            this._view.addChangeMembershipOption(EntityOptionsView.NO_ICON, entityConstants.joinEntity(), EntityOptionsView.NO_TOOLTIP, (AsyncClickHandler)new JoinButtonClickHandler(this, entity, may));
        }
        if (isLoggedIn && may.contains(StaticEntityAction.ENTITY_JOIN_REQUEST)) {
            this._view.addChangeMembershipOption(EntityOptionsView.NO_ICON, entityConstants.sendJoinRequest(), EntityOptionsView.NO_TOOLTIP, (AsyncClickHandler)new JoinButtonClickHandler(this, entity, may));
        }
        if (may.contains(StaticEntityAction.ENTITY_ACCEPT_INVITE)) {
            boolean mayRejectInvitation = may.contains(StaticEntityAction.ENTITY_LEAVE);
            String title = mayRejectInvitation ? entityConstants.acceptInvitationOption() : entityConstants.acceptDeclinedInvitation();
            this._view.addChangeMembershipOption(EntityOptionsView.NO_ICON, title, EntityOptionsView.NO_TOOLTIP, (AsyncClickHandler)new AcceptInviteClickHandler(this, entity));
            if (mayRejectInvitation) {
                this._view.addChangeMembershipOption(EntityOptionsView.NO_ICON, entityConstants.declineInvite(), EntityOptionsView.NO_TOOLTIP, (AsyncClickHandler)new RejectInvitationClickHandler(this, entity, entityVersion));
            }
        } else if (may.contains(StaticEntityAction.ENTITY_LEAVE)) {
            this._view.addChangeMembershipOption(Optional.of((Object)IconType.OK), entityConstants.youAreMember(), Optional.of((Object)entityConstants.clickToLeaveEntity()), (AsyncClickHandler)new LeaveEntityClickHandler(entity));
        }
        if (may.contains(StaticEntityAction.ENTITY_REMOVE_JOIN_REQUEST)) {
            AsyncClickHandler clickHandler = e -> this._entityMemberClientFactory.clientService().deleteJoinRequest((EntityId)entity.getId(), (EntityType)entity.getType()).error(Promise.DEFAULT_ERROR_HANDLER);
            this._view.addChangeMembershipOption(EntityOptionsView.NO_ICON, entityConstants.removeJoinEntityRequest(), EntityOptionsView.NO_TOOLTIP, clickHandler);
        }
    }
}

