/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.calendar.presentation.client.ui;

import com.freiheit.toro.client.mediator.I18nMediator;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.Event;
import com.google.gwt.user.client.ui.AbsolutePanel;
import com.google.gwt.user.client.ui.Anchor;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.FocusPanel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.Widget;
import de.justsoftware.onx.calendar.presentation.client.CalendarViewHandler;
import de.justsoftware.onx.calendar.presentation.client.ui.MonthViewTimedAppointmentWidget;
import de.justsoftware.onx.common.presentation.client.ClientFactory;
import de.justsoftware.onx.common.shared.util.Dates;
import de.justsoftware.onx.container.shared.model.EntityBadge;
import de.justsoftware.onx.container.shared.model.EntityType;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.annotation.Nonnull;

public class MonthViewDayCell
extends Composite {
    private final Date _day;
    private final Label _dayLabel;
    private final int _width;
    private final int _height;
    private final AbsolutePanel _dayContentPanel;
    private final Set<EntityBadge> _timedAppointments = new LinkedHashSet();
    private final Set<EntityBadge> _multiDayAppointments = new LinkedHashSet();
    private final Set<Integer> _usedSlots;
    private int _lastSlotInUse = 0;
    private final int _gridX;
    private final int _gridY;
    private final int _maxDisplayableSlot;
    private final EntityType _entityType;
    private final CalendarViewHandler _calendarViewHandler;
    private final FocusPanel _clickPanel;
    private final boolean _mayCreateAppointment;
    private final ClientFactory _clientFactory;

    public MonthViewDayCell(Date day, Date anyDateInMonth, boolean displayMonth, int width, int height, int gridX, int gridY, EntityType entityType, CalendarViewHandler calendarViewHandler, boolean mayCreateAppointment, ClientFactory clientFactory) {
        this._clientFactory = clientFactory;
        this._dayContentPanel = new AbsolutePanel();
        this._mayCreateAppointment = mayCreateAppointment;
        this.initWidget((Widget)this._dayContentPanel);
        this._clickPanel = new FocusPanel();
        this._clickPanel.setWidth(width + "px");
        this._clickPanel.setHeight(height + "px");
        this._dayContentPanel.add((Widget)this._clickPanel, 0, 0);
        this._gridY = gridY;
        this._gridX = gridX;
        this._calendarViewHandler = calendarViewHandler;
        this._usedSlots = new HashSet();
        this._day = Dates.clone((Date)day);
        this._width = width;
        this._height = height;
        this._entityType = entityType;
        this._dayContentPanel.setWidth(this._width + "px");
        this._dayContentPanel.setHeight(this._height + "px");
        int appHeight = 21;
        this._maxDisplayableSlot = (this._height - 20 - 1) / 21 - 1;
        StringBuilder strDateLabel = new StringBuilder().append(this._day.getDate());
        if (displayMonth) {
            strDateLabel.append(" ").append(I18nMediator.getMonthShortName((int)(this._day.getMonth() + 1)));
        }
        this.setStyleName("monthViewDay");
        this._dayLabel = new Label(strDateLabel.toString());
        this._dayLabel.setStyleName("monthViewDayHeader");
        this._dayLabel.setHeight("20px");
        boolean isToday = Dates.areOnTheSameDay((Date)day, (Date)new Date());
        if (isToday) {
            this._dayLabel.addStyleName("monthViewDayHeader-today");
            this.addStyleName("monthViewDay-today");
        }
        if (anyDateInMonth.getMonth() != day.getMonth()) {
            this._dayLabel.addStyleName("monthViewDayHeader-otherMonth");
            this.addStyleName("monthViewDay-otherMonth");
        }
        this._dayContentPanel.add((Widget)this._dayLabel);
        this.sinkEvents(48);
        this._clickPanel.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void onBrowserEvent(Event event) {
        switch (DOM.eventGetType((Event)event)) {
            case 32: {
                this._dayLabel.removeStyleName("monthViewDayHeader-selected");
                this.removeStyleName("monthViewDay-selected");
                break;
            }
            case 16: {
                this._dayLabel.addStyleName("monthViewDayHeader-selected");
                this.addStyleName("monthViewDay-selected");
                break;
            }
            default: {
                super.onBrowserEvent(event);
            }
        }
    }

    public void addTimedAppointments(@Nonnull Iterable<? extends EntityBadge> dayAppointments) {
        for (EntityBadge entityBadge : dayAppointments) {
            this.addTimedAppointment(entityBadge);
        }
    }

    public void addTimedAppointment(EntityBadge appointment) {
        if (this._timedAppointments.add(appointment)) {
            int slot = this.getLastSlotInUsed() + 1;
            this.useSlot(slot);
            if (this.getMaxDisplayabeSlot() >= slot) {
                this._dayContentPanel.add((Widget)new MonthViewTimedAppointmentWidget(appointment, this._calendarViewHandler, this._width), 0, 20 + (slot - 1) * 21 + 3);
            }
        }
    }

    public void addMutliDayAppointment(EntityBadge multiDayAppointment) {
        this._multiDayAppointments.add(multiDayAppointment);
    }

    public int getMaxDisplayabeSlot() {
        return this._maxDisplayableSlot;
    }

    public boolean isSlotUsed(int slot) {
        return this._usedSlots.contains(slot);
    }

    public void useSlot(int slot) throws IllegalArgumentException {
        if (slot < 1) {
            throw new IllegalArgumentException("Slot must bigger than 0");
        }
        if (this.isSlotUsed(slot)) {
            throw new IllegalArgumentException("Slot " + slot + " already in use");
        }
        this._lastSlotInUse = Math.max(this._lastSlotInUse, slot);
        this._usedSlots.add(slot);
    }

    public int getLastSlotInUsed() {
        return this._lastSlotInUse;
    }

    public int getGridX() {
        return this._gridX;
    }

    public int getGridY() {
        return this._gridY;
    }

    public int getWidth() {
        return this._width;
    }

    public int getHeight() {
        return this._height;
    }

    public void addMoreLinkIfNessesary() {
        int lastSlotInUsed = this.getLastSlotInUsed();
        if (lastSlotInUsed > this.getMaxDisplayabeSlot()) {
            int displayedApps = 0;
            int appsTotal = this._timedAppointments.size() + this._multiDayAppointments.size();
            for (int i = this.getMaxDisplayabeSlot(); i > 0; --i) {
                if (!this.isSlotUsed(i)) continue;
                ++displayedApps;
            }
            int more = appsTotal - displayedApps;
            if (more > 0) {
                FlowPanel moreDiv = new FlowPanel();
                moreDiv.setHeight("20px");
                moreDiv.setWidth(this._width + "px");
                moreDiv.setStyleName("monthViewMoreAppointmentsLink");
                Anchor moreLink = new Anchor(I18nMediator.BASIC_MESSAGES.xMore(more));
                moreDiv.add((Widget)moreLink);
                moreLink.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
                int top = this._height - 20 - 1;
                this._dayContentPanel.add((Widget)moreDiv, 0, top);
            }
        }
    }
}

