/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.onx.calendar.presentation.client.ui;

import com.freiheit.toro.client.mediator.I18nMediator;
import com.freiheit.toro.util.client.LoggingUtil;
import com.google.gwt.user.client.ui.FlexTable;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.Widget;
import de.justsoftware.onx.calendar.presentation.client.ui.Calendar;
import de.justsoftware.onx.calendar.presentation.client.ui.CalendarView;
import de.justsoftware.onx.calendar.presentation.client.ui.MonthViewDayCell;
import de.justsoftware.onx.calendar.presentation.client.ui.MonthViewWholeDayAppointment;
import de.justsoftware.onx.common.presentation.client.ClientFactory;
import de.justsoftware.onx.common.presentation.client.JCDateTimeFormat;
import de.justsoftware.onx.common.shared.i18n.CalendarConstants;
import de.justsoftware.onx.common.shared.util.Dates;
import de.justsoftware.onx.container.shared.model.EntityBadge;
import de.justsoftware.onx.container.shared.model.EntityType;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.Nonnull;

/*
 * Exception performing whole class analysis ignored.
 */
public class MonthView
extends CalendarView {
    public static final int DATEDAY_LABEL_HEIGHT = 20;
    public static final int APPOINTMENT_HEIGHT = 20;
    public static final int APPOINTMENT_PADDING = 1;
    public static final int DAYS_IN_A_WEEK = 7;
    public static final int WEEKDAY_LABEL_HEIGHT = 30;
    public static final int PADDING = 5;
    private static final CalendarConstants CALENDAR_CONSTANTS = I18nMediator.CALENDAR;
    private static final JCDateTimeFormat TITLE_FORMAT = JCDateTimeFormat.forPattern((String)"MMMM yyyy");
    private final FlowPanel _viewPanel;
    private FlexTable _monthViewTable;
    private final Map<String, MonthViewDayCell> _dayWidgets;
    private final ClientFactory _clientFactory;

    public MonthView(int viewWidht, int viewHeight, boolean mayCreate, EntityType type, ClientFactory clientFactory) {
        super(viewWidht, viewHeight, mayCreate, type);
        this._clientFactory = clientFactory;
        this._viewPanel = new FlowPanel();
        this._viewPanel.setStyleName("monthView");
        this._dayWidgets = new LinkedHashMap();
        this.addToContent((Widget)this._viewPanel, 0, 0);
    }

    private static int getFirstDayOfWeek() {
        int firstDayOfWeek;
        String strFirstDayOfWeek = CALENDAR_CONSTANTS.firstDayOfWeek();
        try {
            firstDayOfWeek = Integer.parseInt(strFirstDayOfWeek);
        }
        catch (NumberFormatException e) {
            LoggingUtil.warn((Object)"MonthView", (String)"Cannot parse firstDayOfWeek in CalendarConstants to a number, we will set the first day in month to monday");
            firstDayOfWeek = 1;
        }
        if (firstDayOfWeek < 0 || firstDayOfWeek > 6) {
            LoggingUtil.warn((Object)"MonthView", (String)"Cannot parse firstDayOfWeek in CalendarConstants is not between 0 to 6. We will set the first day in month to monday");
            firstDayOfWeek = 1;
        }
        return firstDayOfWeek;
    }

    private static Date firstDateShownInAMonthView(Date dayInMonth, int firstDayOfWeek) {
        Date date = MonthView.resetTime((Date)Dates.firstOfTheMonth((Date)dayInMonth));
        int firstDayOffset = firstDayOfWeek + date.getDate() - date.getDay();
        date.setDate(firstDayOffset);
        if (Dates.areOnTheSameMonth((Date)date, (Date)dayInMonth) && date.getDate() > 1) {
            date.setDate(firstDayOffset - 7);
        }
        return date;
    }

    @Nonnull
    private static Date resetTime(@Nonnull Date day) {
        return new Date(day.getYear(), day.getMonth(), day.getDate());
    }

    private static Date lastDateShownInAMonthView(Date dayInMonth, int firstDayOfWeek) {
        Date date = MonthView.resetTime((Date)Dates.lastOfTheMonth((Date)dayInMonth));
        int lastDayOfMonth = date.getDate();
        int lastDayOffset = firstDayOfWeek + lastDayOfMonth - date.getDay() - 1;
        date.setDate(lastDayOffset);
        if (Dates.areOnTheSameMonth((Date)date, (Date)dayInMonth) && date.getDate() < lastDayOfMonth) {
            date.setDate(lastDayOffset + 7);
        }
        return date;
    }

    protected void initView(Calendar calendar) {
        if (this._monthViewTable != null) {
            this._monthViewTable.clear();
            this._monthViewTable.removeFromParent();
            this._viewPanel.clear();
            this.clear();
            this.addToContent((Widget)this._viewPanel, 0, 0);
        }
        this._viewPanel.setHeight(this.getViewHeight() - 10 + "px");
        this._viewPanel.setWidth(this.getViewWidth() - 10 + "px");
        this._dayWidgets.clear();
        this._monthViewTable = new FlexTable();
        this._monthViewTable.setStyleName("monthViewGrid");
        this._viewPanel.add((Widget)this._monthViewTable);
        int firstDayOfWeek = MonthView.getFirstDayOfWeek();
        Date firstDateDisplayed = this.getCurrentStartDate(calendar);
        Date lastDateDisplayed = this.getCurrentEndDate(calendar);
        Date today = new Date();
        Dates.resetTime((Date)today);
        String[] weekdayShortNameArray = I18nMediator.getWeekdayShortNameArray();
        for (int i = 0; i < 7; ++i) {
            this._monthViewTable.setText(0, i, weekdayShortNameArray[(i + firstDayOfWeek) % 7]);
            this._monthViewTable.getCellFormatter().setStyleName(0, i, "monthViewWeekdayLabel");
        }
        Date date = (Date)firstDateDisplayed.clone();
        int monthGridRowIndex = 0;
        int dayOfWeekIndex = 0;
        int countOfDays = Dates.differenceInDays((Date)lastDateDisplayed, (Date)firstDateDisplayed) + 1;
        int maxMonthGridRowIndex = countOfDays / 7;
        int cellHeight = (this.getViewHeight() - 50) / maxMonthGridRowIndex;
        int cellWidht = (this.getViewWidth() - 10 - 8) / 7;
        for (int i = 0; i < countOfDays; ++i) {
            dayOfWeekIndex = i % 7;
            if (dayOfWeekIndex == 0) {
                ++monthGridRowIndex;
            }
            MonthViewDayCell dayWidget = new MonthViewDayCell(date, calendar.getSelectedDate(), i == 0 || date.getDate() == 1, cellWidht, cellHeight, dayOfWeekIndex, monthGridRowIndex, this._entityType, calendar.getCalendarViewHandler(), this.isMayCreateAppointment(), this._clientFactory);
            this._dayWidgets.put(DATE_KEY_FORMATTER.format(date), dayWidget);
            this._monthViewTable.setWidget(monthGridRowIndex, dayOfWeekIndex, (Widget)dayWidget);
            this._monthViewTable.getCellFormatter().setStyleName(monthGridRowIndex, dayOfWeekIndex, "monthViewCell");
            this._monthViewTable.getCellFormatter().setWidth(monthGridRowIndex, dayOfWeekIndex, cellWidht + "px");
            this._monthViewTable.getCellFormatter().setHeight(monthGridRowIndex, dayOfWeekIndex, cellHeight + "px");
            this._monthViewTable.getRowFormatter().setStyleName(monthGridRowIndex, "monthViewRow");
            date = Dates.getNextDay((Date)date);
        }
    }

    protected Date getCurrentStartDate(Calendar calendar) {
        return MonthView.firstDateShownInAMonthView((Date)calendar.getSelectedDate(), (int)MonthView.getFirstDayOfWeek());
    }

    protected Date getCurrentEndDate(Calendar calendar) {
        return MonthView.lastDateShownInAMonthView((Date)calendar.getSelectedDate(), (int)MonthView.getFirstDayOfWeek());
    }

    protected String getViewTitle(Calendar calendar) {
        return TITLE_FORMAT.format(calendar.getSelectedDate());
    }

    protected void addWholeDaysAppointmentsToView(Date day, Iterable<? extends EntityBadge> dayAppointments, Calendar calendar) {
        for (EntityBadge entityBadge : dayAppointments) {
            MonthViewWholeDayAppointment wholeDayAppointment = new MonthViewWholeDayAppointment(day, entityBadge, calendar.getCalendarViewHandler());
            wholeDayAppointment.createWholeDayAppointmentToAbsolutePanel(this._absoluteContentPanel, this._dayWidgets);
        }
    }

    protected void addTimedAppointmentsToView(Date day, Iterable<? extends EntityBadge> timedAppointments, Calendar calendar) {
        MonthViewDayCell dayWidget = (MonthViewDayCell)this._dayWidgets.get(DATE_KEY_FORMATTER.format(day));
        if (dayWidget != null) {
            dayWidget.addTimedAppointments(timedAppointments);
        }
    }

    protected void afterAddAppointments() {
        for (Map.Entry entry : this._dayWidgets.entrySet()) {
            ((MonthViewDayCell)entry.getValue()).addMoreLinkIfNessesary();
        }
    }
}

