/*
 * Decompiled with CFR 0.152.
 */
package com.freiheit.toro.server;

import com.google.common.base.MoreObjects;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public class UrlBuilder {
    private static final String HTTP_HEADER_X_FORWARDED_HOST = "x-forwarded-host";
    private static final String SCHEME_SERVERNAME_SEPARATOR = "://";
    private static final String SERVERNAME_PORT_SEPARATOR = ":";
    private static final String PATH_QUERYSTRING_SEPARATOR = "?";
    private static final String QUERYSTRING_SEPARATOR = "&";
    private static final String QUERYSTRING_NAME_VALUE_SEPARATOR = "=";
    private static final String REQUEST_PARAMETERS_ANCHOR_SEPARATOR = "#";
    private static final int STANDARD_SERVER_PORT = 80;
    private static int _proxyPort = 80;
    private String _scheme;
    private String _serverName;
    private int _serverPort;
    private String _path;
    private StringBuilder _queryString;
    private String _anchorString;

    public UrlBuilder(HttpServletRequest request, String protocoll) {
        this._scheme = protocoll;
        this._serverName = UrlBuilder.getHost((HttpServletRequest)request);
        this._serverPort = UrlBuilder.getPort((HttpServletRequest)request);
        StringBuilder pathBuilder = new StringBuilder((String)MoreObjects.firstNonNull((Object)request.getContextPath(), (Object)""));
        pathBuilder.append((String)MoreObjects.firstNonNull((Object)request.getServletPath(), (Object)""));
        pathBuilder.append((String)MoreObjects.firstNonNull((Object)request.getPathInfo(), (Object)""));
        this._path = pathBuilder.toString();
        String queryString = request.getQueryString();
        if (!StringUtils.isEmpty((String)queryString)) {
            int splitIndex = queryString.indexOf(35);
            if (splitIndex == -1) {
                this._queryString = new StringBuilder(queryString);
            } else {
                this._queryString = new StringBuilder(queryString.substring(0, splitIndex));
                if (queryString.length() > splitIndex + 1) {
                    this._anchorString = queryString.substring(splitIndex + 1);
                }
            }
        }
    }

    public String getPath() {
        return this._path;
    }

    public void setPath(String path) {
        this._path = path;
    }

    public String getQueryString() {
        return this._queryString == null ? null : this._queryString.toString();
    }

    public void setQueryString(String queryString) {
        this._queryString = new StringBuilder((String)MoreObjects.firstNonNull((Object)queryString, (Object)""));
    }

    public String getScheme() {
        return this._scheme;
    }

    public void setScheme(String scheme) {
        this._scheme = scheme;
    }

    public String getServerName() {
        return this._serverName;
    }

    public void setServerName(String serverName) {
        this._serverName = serverName;
    }

    public int getServerPort() {
        return this._serverPort;
    }

    public int getServerPortOrZeroIfStandard() {
        return this._serverPort == 80 ? 0 : this._serverPort;
    }

    public void setServerPort(int serverPort) {
        this._serverPort = serverPort;
    }

    public void clearServerPort() {
        this._serverPort = 80;
    }

    public void appendRequestParameter(String name, String value) {
        if (StringUtils.isEmpty((String)name)) {
            throw new IllegalArgumentException("Der Name des Request-Parameters darf nicht null oder leer sein.");
        }
        if (this._queryString == null) {
            this._queryString = new StringBuilder();
        }
        if (this._queryString.length() > 0) {
            this._queryString.append("&");
        }
        this._queryString.append(name);
        if (!StringUtils.isEmpty((String)value)) {
            this._queryString.append("=");
            this._queryString.append(value);
        }
    }

    public String getRequestParameter(String name) {
        return UrlBuilder.getRequestParameterFromParameterStringBuilder((StringBuilder)this._queryString, (String)name);
    }

    public static String getRequestParameterFromParameterStringBuilder(StringBuilder parameters, String parameterName) {
        if (parameters == null) {
            return null;
        }
        int i = parameters.indexOf(parameterName);
        if (i == -1) {
            return null;
        }
        int next = parameters.indexOf("&", i);
        if (next == -1) {
            next = parameters.length();
        }
        String parameter = parameters.substring(i, next);
        String[] value = parameter.split("=");
        return value[1];
    }

    public static String getRequestParameterFromParameterString(String parameters, String parameterName) {
        if (parameters == null) {
            return null;
        }
        return UrlBuilder.getRequestParameterFromParameterStringBuilder((StringBuilder)new StringBuilder(parameters), (String)parameterName);
    }

    public void replaceParameterValueIfExists(String name, String value) {
        int next;
        int i;
        if (StringUtils.isEmpty((String)name)) {
            throw new IllegalArgumentException("Der Name des Request-Parameters darf nicht null oder leer sein.");
        }
        int n = i = this._queryString == null ? -1 : this._queryString.indexOf(name);
        if (i == -1) {
            this.appendRequestParameter(name, value);
            return;
        }
        Object replacement = name;
        if (!StringUtils.isEmpty((String)value)) {
            replacement = (String)replacement + "=" + value;
        }
        if ((next = this._queryString.indexOf("&", i)) == -1) {
            next = this._queryString.length();
        }
        String first = this._queryString.substring(0, i);
        String last = this._queryString.substring(next);
        this._queryString = new StringBuilder(first);
        this._queryString.append((String)replacement).append(last);
    }

    public String getUrl() {
        StringBuilder sb = new StringBuilder(this._scheme);
        sb.append("://");
        sb.append(this._serverName);
        if (this._serverPort != 80) {
            sb.append(":");
            sb.append(this._serverPort);
        }
        if (!StringUtils.isEmpty((String)this._path)) {
            sb.append(this._path);
        }
        if (this._queryString != null && this._queryString.length() > 0) {
            sb.append("?");
            sb.append(this._queryString.toString());
        }
        if (!StringUtils.isEmpty((String)this._anchorString)) {
            sb.append("#");
            sb.append(this._anchorString);
        }
        return sb.toString();
    }

    public String toString() {
        return this.getUrl();
    }

    public String getAnchorString() {
        return this._anchorString;
    }

    public void setAnchorString(String anchorString) {
        this._anchorString = anchorString;
    }

    public static String getHost(HttpServletRequest request) {
        String header = request.getHeader("x-forwarded-host");
        if (header != null) {
            return header.replaceFirst(":.*$", "");
        }
        return request.getServerName();
    }

    public static int getPort(HttpServletRequest request) {
        String header = request.getHeader("x-forwarded-host");
        if (header != null) {
            return _proxyPort;
        }
        return request.getServerPort();
    }

    public static void setProxyPort(int port) {
        _proxyPort = port;
    }
}

