/*
 * Decompiled with CFR 0.152.
 */
package com.freiheit.toro.common.presentation.client;

import com.google.gwt.user.client.rpc.AsyncCallback;
import de.justsoftware.onx.common.presentation.client.ClientFactory;
import de.justsoftware.onx.common.presentation.client.ClientFactoryImpl;
import de.justsoftware.onx.common.presentation.client.ui.PopupHelper;
import de.justsoftware.onx.logging.client.ClientLogger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public abstract class ErrorHandlingAsyncCallback<T>
implements AsyncCallback<T> {
    private final PopupHelper _popupHelper;
    private final ClientLogger _clientLogger;

    public ErrorHandlingAsyncCallback() {
        this((ClientFactory)ClientFactoryImpl.INSTANCE);
    }

    public ErrorHandlingAsyncCallback(@Nullable PopupHelper popupHelper, @Nullable ClientLogger clientLogger) {
        this._popupHelper = popupHelper;
        this._clientLogger = clientLogger;
    }

    public ErrorHandlingAsyncCallback(@Nonnull ClientFactory clientFactory) {
        this(clientFactory.popupHelper(), clientFactory.clientLogger());
    }

    public final void onFailure(Throwable caught) {
        this.finishedHook();
        try {
            this.handleFailure(caught);
        }
        catch (RuntimeException e) {
            this.logWithTrace("handleFailure", (Throwable)e);
        }
    }

    private void logWithTrace(String s, Throwable e) {
        if (this._clientLogger != null) {
            this._clientLogger.error((Object)this, s + " threw a " + e.toString() + ": " + e.getMessage(), e);
        }
    }

    public final void onSuccess(T result) {
        this.finishedHook();
        try {
            this.handleSuccess(result);
        }
        catch (RuntimeException e) {
            this.logWithTrace("handleSuccess", (Throwable)e);
        }
    }

    public void handleFailure(Throwable cause) {
        if (this._popupHelper != null) {
            this._popupHelper.showErrorPopup(cause);
        }
    }

    public abstract void handleSuccess(T var1);

    public void finishedHook() {
    }

    public static ErrorHandlingAsyncCallback<Void> emptyCallback() {
        return new /* Unavailable Anonymous Inner Class!! */;
    }
}

