/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.permission.kafka.impl;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.kafka.clients.admin.NewTopic;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Profile;
import org.springframework.kafka.core.KafkaAdmin;

/*
 * Exception performing whole class analysis ignored.
 */
@Profile(value={"!test"})
@Configuration
@ParametersAreNonnullByDefault
public class KafkaTopicConfiguration {
    private static final String SEVEN_DAYS_IN_MS = "604800000";
    private static final ImmutableMap<String, String> DEFAULT_TOPIC_CONFIG = ImmutableMap.of((Object)"delete.retention.ms", (Object)"604800000", (Object)"segment.ms", (Object)"604800000", (Object)"cleanup.policy", (Object)"compact");

    @CheckForNull
    @Bean
    public KafkaAdmin admin(@Nullable @Value(value="${kafka.boostrapServers:}") String bootstrapServer) {
        if (Strings.isNullOrEmpty((String)bootstrapServer)) {
            return null;
        }
        ImmutableMap configs = ImmutableMap.of((Object)"bootstrap.servers", (Object)bootstrapServer);
        KafkaAdmin kafkaAdmin = new KafkaAdmin((Map)configs);
        kafkaAdmin.setFatalIfBrokerNotAvailable(true);
        return kafkaAdmin;
    }

    @Nonnull
    private static NewTopic topicFactory(String topicName) {
        return KafkaTopicConfiguration.topicFactory((String)topicName, (int)1);
    }

    @Nonnull
    private static NewTopic topicFactory(String topicName, int partitions) {
        NewTopic topic = new NewTopic(topicName, partitions, 1);
        return topic.configs((Map)DEFAULT_TOPIC_CONFIG);
    }

    @Nonnull
    @Bean
    public NewTopic permissionConfigTopic() {
        return KafkaTopicConfiguration.topicFactory((String)"just.permission.config");
    }

    @Nonnull
    @Bean
    public NewTopic permissionItemTopic() {
        return KafkaTopicConfiguration.topicFactory((String)"just.permission.item", (int)5);
    }

    @Nonnull
    @Bean
    public NewTopic permissionSingleRoleAssignment() {
        return KafkaTopicConfiguration.topicFactory((String)"just.permission.singleRoleAssignment", (int)5);
    }

    @Nonnull
    @Bean
    public NewTopic permissionMultiRoleAssignment() {
        return KafkaTopicConfiguration.topicFactory((String)"just.permission.multiRoleAssignment", (int)5);
    }
}

