/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.mobile.gateway.people.controller;

import de.justsoftware.mobile.gateway.authorization.model.AuthorizationContext;
import de.justsoftware.mobile.gateway.people.model.local.Profile;
import de.justsoftware.mobile.gateway.people.model.local.ProfileConfiguration;
import de.justsoftware.mobile.gateway.people.model.local.ProfileDetails;
import de.justsoftware.mobile.gateway.people.model.local.ProfileSection;
import de.justsoftware.mobile.gateway.people.model.local.UserGroup;
import de.justsoftware.mobile.gateway.people.service.PeopleService;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/people"})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001a\u0010\u0005\u001a\u00020\u00062\b\b\u0001\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0017J\u0018\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\b\b\u0001\u0010\u0007\u001a\u00020\bH\u0017J\u0012\u0010\u000e\u001a\u00020\u000f2\b\b\u0001\u0010\u0007\u001a\u00020\bH\u0017J\u001a\u0010\u0010\u001a\u00020\u00062\b\b\u0001\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0017J6\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\f2\n\b\u0001\u0010\u0013\u001a\u0004\u0018\u00010\b2\b\b\u0001\u0010\u0014\u001a\u00020\u00152\b\b\u0001\u0010\u0016\u001a\u00020\u00152\u0006\u0010\t\u001a\u00020\nH\u0017J\u0012\u0010\u0017\u001a\u00020\u00182\b\b\u0001\u0010\u0019\u001a\u00020\bH\u0017J,\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00120\f2\b\b\u0001\u0010\u0019\u001a\u00020\b2\b\b\u0001\u0010\u0014\u001a\u00020\u00152\b\b\u0001\u0010\u0016\u001a\u00020\u0015H\u0017J6\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00180\f2\n\b\u0001\u0010\u0013\u001a\u0004\u0018\u00010\b2\b\b\u0001\u0010\u0014\u001a\u00020\u00152\b\b\u0001\u0010\u0016\u001a\u00020\u00152\u0006\u0010\t\u001a\u00020\nH\u0017J$\u0010\u001c\u001a\u00020\u00062\b\b\u0001\u0010\u0007\u001a\u00020\b2\b\b\u0001\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\t\u001a\u00020\nH\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lde/justsoftware/mobile/gateway/people/controller/PeopleController;", "", "peopleService", "Lde/justsoftware/mobile/gateway/people/service/PeopleService;", "(Lde/justsoftware/mobile/gateway/people/service/PeopleService;)V", "deleteUserImage", "Lde/justsoftware/mobile/gateway/people/model/local/ProfileDetails;", "userId", "", "authContext", "Lde/justsoftware/mobile/gateway/authorization/model/AuthorizationContext;", "getAttributes", "", "Lde/justsoftware/mobile/gateway/people/model/local/ProfileSection;", "getConfiguration", "Lde/justsoftware/mobile/gateway/people/model/local/ProfileConfiguration;", "getProfile", "getProfiles", "Lde/justsoftware/mobile/gateway/people/model/local/Profile;", "query", "offset", "", "limit", "getUserGroup", "Lde/justsoftware/mobile/gateway/people/model/local/UserGroup;", "groupId", "getUserGroupMembers", "getUserGroups", "updateUserImage", "image", "Lorg/springframework/web/multipart/MultipartFile;", "mobile-gateway"})
public class PeopleController {
    @NotNull
    private final PeopleService peopleService;

    public PeopleController(@NotNull PeopleService peopleService) {
        Intrinsics.checkNotNullParameter((Object)peopleService, (String)"peopleService");
        this.peopleService = peopleService;
    }

    @GetMapping(value={"/{id}"})
    @NotNull
    public ProfileDetails getProfile(@PathVariable(value="id") @NotNull String userId, @NotNull AuthorizationContext authContext) {
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        return this.peopleService.getProfile(userId, authContext.getProfileId());
    }

    @GetMapping
    @NotNull
    public List<Profile> getProfiles(@RequestParam(value="query", required=false) @Nullable String query, @RequestParam(name="offset", required=false, defaultValue="0") int offset, @RequestParam(name="limit", required=false, defaultValue="20") int limit, @NotNull AuthorizationContext authContext) {
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        return this.peopleService.getProfiles(query, offset, limit);
    }

    @GetMapping(value={"/groups"})
    @NotNull
    public List<UserGroup> getUserGroups(@RequestParam(value="query", required=false) @Nullable String query, @RequestParam(name="offset", required=false, defaultValue="0") int offset, @RequestParam(name="limit", required=false, defaultValue="20") int limit, @NotNull AuthorizationContext authContext) {
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        return this.peopleService.getUserGroups(query, offset, limit);
    }

    @GetMapping(value={"/groups/{id}"})
    @NotNull
    public UserGroup getUserGroup(@PathVariable(value="id") @NotNull String groupId) {
        Intrinsics.checkNotNullParameter((Object)groupId, (String)"groupId");
        return this.peopleService.getUserGroup(groupId);
    }

    @GetMapping(value={"/groups/{id}/members"})
    @NotNull
    public List<Profile> getUserGroupMembers(@PathVariable(value="id") @NotNull String groupId, @RequestParam(name="offset", required=false, defaultValue="0") int offset, @RequestParam(name="limit", required=false, defaultValue="20") int limit) {
        Intrinsics.checkNotNullParameter((Object)groupId, (String)"groupId");
        return this.peopleService.getUserGroupMembers(groupId, offset, limit);
    }

    @PostMapping(value={"/{id}/image"})
    @NotNull
    public ProfileDetails updateUserImage(@PathVariable(value="id") @NotNull String userId, @RequestPart(value="image") @NotNull MultipartFile image, @NotNull AuthorizationContext authContext) {
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        Intrinsics.checkNotNullParameter((Object)image, (String)"image");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        return this.peopleService.updateUserImage(userId, image, authContext.getProfileId());
    }

    @DeleteMapping(value={"/{id}/image"})
    @NotNull
    public ProfileDetails deleteUserImage(@PathVariable(value="id") @NotNull String userId, @NotNull AuthorizationContext authContext) {
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        return this.peopleService.deleteUserImage(userId, authContext.getProfileId());
    }

    @GetMapping(value={"/{id}/attributes"})
    @NotNull
    public List<ProfileSection> getAttributes(@PathVariable(value="id") @NotNull String userId) {
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        return this.peopleService.getAttributes(userId);
    }

    @GetMapping(value={"/{id}/configuration"})
    @NotNull
    public ProfileConfiguration getConfiguration(@PathVariable(value="id") @NotNull String userId) {
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        return this.peopleService.getConfiguration(userId);
    }
}

