/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.justimport.util;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.MoreObjects;
import com.unboundid.scim2.common.exceptions.ScimException;
import com.unboundid.scim2.common.messages.PatchOpType;
import com.unboundid.scim2.common.messages.PatchOperation;
import com.unboundid.scim2.common.messages.PatchRequest;
import de.justsoftware.justimport.util.PatchRequestUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

/*
 * Exception performing whole class analysis ignored.
 */
@ParametersAreNonnullByDefault
public class PatchRequestUtils {
    @Nonnull
    public static PatchRequest fixPatchRequest(PatchRequest request) {
        ArrayList fixedOperations = new ArrayList();
        List originalOperations = request.getOperations();
        originalOperations.forEach(operation -> {
            if (operation.getPath() != null) {
                fixedOperations.add(operation);
            } else {
                try {
                    HashMap values = (HashMap)operation.getValue(HashMap.class);
                    if (values.keySet().stream().anyMatch(key -> key.contains("."))) {
                        fixedOperations.add(PatchRequestUtils.fixComplexObjectPatchOp((PatchOpType)operation.getOpType(), (HashMap)values));
                    } else {
                        fixedOperations.add(operation);
                    }
                }
                catch (JsonProcessingException | ScimException e) {
                    throw new IllegalStateException(String.format("Received incompatible PatchOperation: %s", operation));
                }
            }
        });
        return new PatchRequest(fixedOperations);
    }

    @Nonnull
    private static PatchOperation fixComplexObjectPatchOp(PatchOpType opType, HashMap<String, Object> values) throws JsonProcessingException {
        HashMap result = new HashMap();
        values.forEach((key, value) -> {
            String[] parts = key.split("\\.");
            if (parts.length == 2) {
                String objectName = parts[0];
                String attributeName = parts[1];
                Object complexObject = MoreObjects.firstNonNull(result.get(objectName), new HashMap());
                if (!(complexObject instanceof Map)) {
                    throw new IllegalStateException("whoa");
                }
                Map m = (Map)complexObject;
                m.put(attributeName, value);
                result.put(objectName, complexObject);
            } else {
                result.put(key, value);
            }
        });
        ObjectMapper mapper = new ObjectMapper();
        JsonNode jsonNode = mapper.valueToTree((Object)new FixedPatchOperation(opType, result));
        return (PatchOperation)mapper.treeToValue((TreeNode)jsonNode, PatchOperation.class);
    }
}

