/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.gateway.kafka.tenant;

import de.justsoftware.gateway.ids.TenantId;
import java.nio.charset.StandardCharsets;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.kafka.common.serialization.Deserializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ParametersAreNonnullByDefault
public class TenantIdDeserializer
implements Deserializer<TenantId> {
    private static final Logger LOG = LoggerFactory.getLogger(TenantIdDeserializer.class);

    public TenantId deserialize(@Nullable String topic, @Nullable byte[] data) {
        if (data == null) {
            return null;
        }
        try {
            String id = new String(data, StandardCharsets.UTF_8);
            return TenantId.parse((String)id);
        }
        catch (IllegalArgumentException e) {
            LOG.error("Could not parse incoming tenantId.", (Throwable)e);
            return null;
        }
    }
}

