/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.gateway.config;

import de.justsoftware.gateway.config.WebSecurityConfig;
import de.justsoftware.gateway.domain.login.UserLoginRepository;
import de.justsoftware.gateway.security.AddJustTokenHeaderFilter;
import de.justsoftware.gateway.security.AuthenticationToJwtStringConverter;
import de.justsoftware.gateway.security.EmailToProfileMapper;
import de.justsoftware.gateway.security.JustAuthenticationManager;
import de.justsoftware.gateway.security.JustAuthenticationManagerResolver;
import de.justsoftware.gateway.security.LoginCookieHandler;
import de.justsoftware.gateway.security.ToroOpaqueTokenIntrospector;
import de.justsoftware.gateway.security.oauth2.JustInMemoryClientRegistrationRepository;
import de.justsoftware.gateway.security.oauth2.JustOauthLoginAuthenticationEntryPoint;
import de.justsoftware.gateway.security.oauth2.JustServerLogoutSuccessHandler;
import de.justsoftware.jwtfilter.ReactiveJwtAuthenticationProcessingFilter;
import de.justsoftware.jwtfilter.verifier.JwtVerifier;
import java.net.URI;
import java.util.Arrays;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.gateway.filter.GlobalFilter;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.authentication.ReactiveAuthenticationManagerResolver;
import org.springframework.security.authorization.AuthenticatedReactiveAuthorizationManager;
import org.springframework.security.authorization.AuthorizationDecision;
import org.springframework.security.authorization.ReactiveAuthorizationManager;
import org.springframework.security.config.annotation.web.reactive.EnableWebFluxSecurity;
import org.springframework.security.config.web.server.SecurityWebFiltersOrder;
import org.springframework.security.config.web.server.ServerHttpSecurity;
import org.springframework.security.core.Authentication;
import org.springframework.security.oauth2.client.registration.ReactiveClientRegistrationRepository;
import org.springframework.security.web.server.SecurityWebFilterChain;
import org.springframework.security.web.server.ServerAuthenticationEntryPoint;
import org.springframework.security.web.server.WebFilterExchange;
import org.springframework.security.web.server.authentication.DelegatingServerAuthenticationSuccessHandler;
import org.springframework.security.web.server.authentication.RedirectServerAuthenticationSuccessHandler;
import org.springframework.security.web.server.authentication.ServerAuthenticationEntryPointFailureHandler;
import org.springframework.security.web.server.authentication.ServerAuthenticationFailureHandler;
import org.springframework.security.web.server.authentication.ServerAuthenticationSuccessHandler;
import org.springframework.security.web.server.authentication.logout.ServerLogoutSuccessHandler;
import org.springframework.security.web.server.authorization.AuthorizationContext;
import org.springframework.security.web.server.util.matcher.OrServerWebExchangeMatcher;
import org.springframework.security.web.server.util.matcher.PathPatternParserServerWebExchangeMatcher;
import org.springframework.security.web.server.util.matcher.ServerWebExchangeMatcher;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.WebFilter;
import reactor.core.publisher.Mono;

@Configuration
@EnableWebFluxSecurity
@ParametersAreNonnullByDefault
public class WebSecurityConfig {
    private static final String[] UNAUTHORIZED_PATHS = new String[]{"/gateway/config/idps/mobile", "/gateway/images/**", "/gateway/internal/**", "/toro/assets/**", "/toro/www/**", "/toro/ckeditor/**", "/toro/font/**", "/toro/rest/heartbeat", "/toro/outdatedBrowser", "/toro/ical", "/toro/terms", "/toro/privacy", "/toro/imprint", "/toro/help", "/toro/press", "/toro/about", "/toro/articlesOfAssociation", "/toro/register", "/toro/registerTenant/**", "/toro/requestActivation", "/toro/requestNewPassword", "/toro/activateAccount/**", "/toro/newMail/**", "/toro/login", "/toro/login/**", "/toro/logout", "/toro/api/v1/jwt", "/toro/swagger-ui.html", "/toro/swagger-ui/**", "/toro/swagger-resources/**", "/toro/v3/api-docs/**", "/toro/resource/i18n**", "/toro/api/v1/i18n/**", "/storageserver/images/ngloginpagelogo/**", "/toro/api/v1/i18n/**", "/toro/api/v1/info/**", "/toro/api/v1/account/unauthorized/**", "/toro/api/v1/document/unauthorized/**", "/toro/api/v1/theme/global", "/drive/api/unauthenticated/**", "/drive/sync/**", "/drive/s/**", "/authentication/**", "/toro/external/login/**", "/oauth2/login", "/login**", "/registration/**", "/account/**", "/about/**", "/just/loggedOut*"};
    private static final String[] COOKIE_ONLY_PATHS = new String[]{"/just/*", "/toro/import/csv-upload", "/toro/upload/**", "/toro/export/survey", "/toro/resource/icsexport.ics", "/toro/printPreview/**", "/toro/resource/html", "/toro/api/v1/conversation/message/*/thumbnail", "/drive/api/previews/**", "/drive/api/documents/folder/*/zip", "/drive/api/documents/fileversion/*/download", "/drive/api/documents/*/download", "/people/api/profiles/export", "/chat/swagger-ui/**", "/chat/swagger-resources/**", "/chat/v3/api-docs/**", "/chat/webjars/**", "/news/rest/event/*/ics-export", "/news/rest/poll/*/csv-export", "/storageserver/images/**", "/monitoring/**"};
    private static final AuthorizationDecision PERMIT_ALL = new AuthorizationDecision(true);
    private static final AuthenticatedReactiveAuthorizationManager<AuthorizationContext> AUTHENTICATED = AuthenticatedReactiveAuthorizationManager.authenticated();
    private final JwtVerifier _jwtVerifier;
    private final LoginCookieHandler _loginSuccessHandler;
    private final JustInMemoryClientRegistrationRepository _oAuthClientRepository;

    @Autowired
    public WebSecurityConfig(JwtVerifier jwtVerifier, LoginCookieHandler loginSuccessHandler, JustInMemoryClientRegistrationRepository oAuthClientRepository) {
        this._jwtVerifier = jwtVerifier;
        this._loginSuccessHandler = loginSuccessHandler;
        this._oAuthClientRepository = oAuthClientRepository;
    }

    @Bean
    @Nonnull
    public SecurityWebFilterChain securityWebFilterChain(ServerHttpSecurity http, JustAuthenticationManager justAuthenticationManager, ToroOpaqueTokenIntrospector toroOpaqueTokenIntrospector, JustOauthLoginAuthenticationEntryPoint oauthLoginEntryPoint, UserLoginRepository userLoginRepository, EmailToProfileMapper emailToProfileMapper) {
        OrServerWebExchangeMatcher cookieOnlyRequestsMatcher = new OrServerWebExchangeMatcher(Arrays.stream(COOKIE_ONLY_PATHS).map(PathPatternParserServerWebExchangeMatcher::new).collect(Collectors.toList()));
        ReactiveJwtAuthenticationProcessingFilter jwtFilter = new ReactiveJwtAuthenticationProcessingFilter(this._jwtVerifier);
        jwtFilter.applyAllowCookieOnlyVerificationMatcher((ServerWebExchangeMatcher)cookieOnlyRequestsMatcher);
        jwtFilter.applyIgnoreFilterMatcher((ServerWebExchangeMatcher)new OrServerWebExchangeMatcher(Arrays.stream(UNAUTHORIZED_PATHS).map(PathPatternParserServerWebExchangeMatcher::new).collect(Collectors.toList())));
        ProfileCheckingWebfilter profileCheckingFilter = new ProfileCheckingWebfilter(arg_0 -> ((EmailToProfileMapper)emailToProfileMapper).mayLogin(arg_0));
        DelegatingServerAuthenticationSuccessHandler successHandler = new DelegatingServerAuthenticationSuccessHandler(new ServerAuthenticationSuccessHandler[]{this._loginSuccessHandler, new SessionInvalidatingSuccessHandler(), new RedirectServerAuthenticationSuccessHandler()});
        JustAuthenticationManagerResolver authResolver = new JustAuthenticationManagerResolver(arg_0 -> ((JustInMemoryClientRegistrationRepository)this._oAuthClientRepository).resolve(arg_0), justAuthenticationManager, toroOpaqueTokenIntrospector);
        ReactiveAuthorizationManager permitAccessWithoutExternalIdp = (authentication, object) -> {
            if (this._oAuthClientRepository.isDesktopIdpConfigured()) {
                return AUTHENTICATED.check(authentication, object);
            }
            return Mono.just((Object)PERMIT_ALL);
        };
        http.csrf(ServerHttpSecurity.CsrfSpec::disable).authorizeExchange(exchanges -> ((ServerHttpSecurity.AuthorizeExchangeSpec.Access)((ServerHttpSecurity.AuthorizeExchangeSpec.Access)exchanges.pathMatchers(UNAUTHORIZED_PATHS)).permitAll().pathMatchers(new String[]{"/just/**", "/toro/resource/html/**"})).access(permitAccessWithoutExternalIdp).anyExchange().authenticated()).exceptionHandling(exceptionHandling -> exceptionHandling.authenticationEntryPoint((ServerAuthenticationEntryPoint)oauthLoginEntryPoint)).requestCache(ServerHttpSecurity.RequestCacheSpec::disable).oauth2ResourceServer(resourceServer -> resourceServer.authenticationManagerResolver((ReactiveAuthenticationManagerResolver)authResolver)).oauth2Login(oauth2Login -> oauth2Login.clientRegistrationRepository((ReactiveClientRegistrationRepository)this._oAuthClientRepository).authenticationSuccessHandler((ServerAuthenticationSuccessHandler)successHandler).authenticationFailureHandler((ServerAuthenticationFailureHandler)new ServerAuthenticationEntryPointFailureHandler((ServerAuthenticationEntryPoint)oauthLoginEntryPoint))).logout(logout -> logout.logoutHandler(WebSecurityConfig::removeJustCookies).logoutUrl("/just/logout").logoutSuccessHandler((ServerLogoutSuccessHandler)this.getJustServerLogoutSuccessHandler(userLoginRepository))).addFilterBefore((WebFilter)jwtFilter, SecurityWebFiltersOrder.AUTHENTICATION).addFilterAfter((WebFilter)profileCheckingFilter, SecurityWebFiltersOrder.AUTHENTICATION);
        return http.build();
    }

    @Nonnull
    private JustServerLogoutSuccessHandler getJustServerLogoutSuccessHandler(UserLoginRepository userLoginRepository) {
        JustServerLogoutSuccessHandler logoutSuccessHandler = new JustServerLogoutSuccessHandler((ReactiveClientRegistrationRepository)this._oAuthClientRepository, userLoginRepository);
        logoutSuccessHandler.setPostLogoutRedirectUri("{baseUrl}/just/loggedOut");
        logoutSuccessHandler.setLogoutSuccessUrl(URI.create("/toro/logout"));
        return logoutSuccessHandler;
    }

    @Nonnull
    private static Mono<Void> removeJustCookies(WebFilterExchange exchange, Authentication authentication) {
        LoginCookieHandler.removeJustIdCookie((ServerWebExchange)exchange.getExchange());
        return Mono.empty();
    }

    @Nonnull
    @Bean
    public GlobalFilter justTokenHeaderFilter(AuthenticationToJwtStringConverter converter) {
        return new AddJustTokenHeaderFilter(converter);
    }
}

