/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.drive.persistence.search;

import com.google.common.base.Predicates;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableSet;
import de.justsoftware.drive.common.item.model.ItemId;
import de.justsoftware.drive.common.person.model.PersonId;
import de.justsoftware.drive.mybatis.DAOSupport;
import de.justsoftware.drive.persistence.search.SearchIndexQueueDAO;
import de.justsoftware.drive.persistence.search.SearchIndexQueueEntryCreateModel;
import de.justsoftware.drive.persistence.search.SearchIndexQueueMapper;
import de.justsoftware.drive.persistence.search.model.SearchIndexQueueEntryBO;
import de.justsoftware.drive.persistence.search.model.SearchIndexQueueEntryId;
import de.justsoftware.drive.persistence.search.model.SearchIndexType;
import de.justsoftware.drive.persistence.transaction.TransactionSupport;
import java.time.Instant;
import java.util.List;
import java.util.Set;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.ibatis.session.RowBounds;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
@ParametersAreNonnullByDefault
public class SearchIndexQueueDAOImpl
implements SearchIndexQueueDAO {
    private final DAOSupport _daoSupport;
    private final SearchIndexQueueMapper _mapper;
    private final TransactionSupport _transactionSupport;

    @Autowired
    public SearchIndexQueueDAOImpl(DAOSupport daoSupport, TransactionSupport transactionSupport, SearchIndexQueueMapper mapper) {
        this._daoSupport = daoSupport;
        this._transactionSupport = transactionSupport;
        this._mapper = mapper;
    }

    public SearchIndexQueueEntryCreateModel createModel() {
        return new SearchIndexQueueEntryCreateModel();
    }

    public void insert(Iterable<SearchIndexQueueEntryCreateModel> models) {
        models.forEach(arg_0 -> ((SearchIndexQueueMapper)this._mapper).insertEntry(arg_0));
    }

    public List<SearchIndexQueueEntryBO> getEntries(Instant now, Instant beforeTimestamp, int limit) {
        return (List)this._transactionSupport.doInTransaction(() -> {
            List entriesToProcess = this._mapper.getEntries(beforeTimestamp, new RowBounds(0, limit));
            if (!entriesToProcess.isEmpty()) {
                ImmutableSet entryIds = FluentIterable.from((Iterable)entriesToProcess).filter(Predicates.notNull()).transform(SearchIndexQueueEntryBO::getId).toSet();
                this._daoSupport.partition((Set)entryIds).noResult(idList -> this._mapper.markEntriesAsInProgress(idList, now));
            }
            return entriesToProcess;
        });
    }

    public void unmarkEntriesInProgress(Set<SearchIndexQueueEntryId> entryIds) {
        this._daoSupport.partition(entryIds).noResult(arg_0 -> ((SearchIndexQueueMapper)this._mapper).unmarkEntriesAsInProgress(arg_0));
    }

    public void delete(Set<SearchIndexQueueEntryId> ids) {
        this._daoSupport.partition(ids).noResult(arg_0 -> ((SearchIndexQueueMapper)this._mapper).deleteEntries(arg_0));
    }

    public void insertAllDocuments(SearchIndexType indexType) {
        this._mapper.insertAllDocuments(indexType);
    }

    public boolean hasEntries(Instant beforeTimestamp) {
        return this._mapper.getEntriesCount(beforeTimestamp) > 0;
    }

    public void insertAllDocumentsOfItems(Set<ItemId> items, SearchIndexType indexType) {
        this._daoSupport.partition(items).noResult(ids -> this._mapper.insertAllDocumentsOfItems(ids, indexType));
    }

    public void insertAllDocumentsOfItemParents(Set<ItemId> parentItems, SearchIndexType indexType) {
        this._daoSupport.partition(parentItems).noResult(ids -> this._mapper.insertAllDocumentsOfItemParents(ids, indexType));
    }

    public void insertAllDocumentsOfOwner(Set<PersonId> persons, SearchIndexType indexType) {
        this._daoSupport.partition(persons).noResult(ids -> this._mapper.insertAllDocumentsOfOwner(ids, indexType));
    }
}

