/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.drive.persistence.publiclinks;

import de.justsoftware.drive.common.document.model.DocumentId;
import de.justsoftware.drive.common.person.model.PersonId;
import de.justsoftware.drive.common.publiclinks.model.PublicLinkBO;
import java.time.Instant;
import java.util.List;
import java.util.Set;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.ibatis.annotations.Arg;
import org.apache.ibatis.annotations.ConstructorArgs;
import org.apache.ibatis.annotations.Delete;
import org.apache.ibatis.annotations.Insert;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;
import org.apache.ibatis.annotations.Update;
import org.apache.ibatis.type.JdbcType;

@ParametersAreNonnullByDefault
@Mapper
public interface PublicLinkMapper {
    @ConstructorArgs(value={@Arg(javaType=String.class, column="link_id", id=true), @Arg(javaType=DocumentId.class, column="document_id"), @Arg(javaType=Instant.class, column="expiration_date"), @Arg(javaType=PersonId.class, column="creator"), @Arg(javaType=Instant.class, column="ctime"), @Arg(javaType=String.class, column="password", jdbcType=JdbcType.VARCHAR)})
    @Select(value={"SELECT link_id, document_id, expiration_date, creator, ctime, password ", "FROM public_links ", "WHERE link_id = #{linkID} ", "AND (expiration_date IS NULL OR expiration_date > clock_timestamp())"})
    @CheckForNull
    public PublicLinkBO getPublicLink(@Param(value="linkID") String var1);

    @Insert(value={"INSERT INTO public_links(link_id, document_id, expiration_date, creator)", "VALUES (#{id}, #{fileId}, #{expirationDate}, #{personId})"})
    public void createPublicLink(@Param(value="id") String var1, @Param(value="fileId") DocumentId var2, @Param(value="expirationDate") Instant var3, @Param(value="personId") PersonId var4);

    @ConstructorArgs(value={@Arg(javaType=String.class, column="link_id", id=true), @Arg(javaType=DocumentId.class, column="document_id"), @Arg(javaType=Instant.class, column="expiration_date"), @Arg(javaType=PersonId.class, column="creator"), @Arg(javaType=Instant.class, column="ctime"), @Arg(javaType=String.class, column="password")})
    @Select(value={"SELECT link_id, document_id, expiration_date, creator, ctime, password ", "FROM public_links ", "WHERE document_id = #{fileId} ", "AND (expiration_date IS NULL OR expiration_date > clock_timestamp()) ", "ORDER by ctime DESC"})
    @Nonnull
    public List<PublicLinkBO> getPublicLinks(@Param(value="fileId") DocumentId var1);

    @Select(value={"<script>", "SELECT document_id FROM public_links ", "WHERE document_id in (<foreach collection='documentsToCheck' item='i' separator=','>#{i}</foreach>) ", "AND (expiration_date IS NULL OR expiration_date > clock_timestamp())", "</script>"})
    @Nonnull
    public Set<DocumentId> hasLinks(@Param(value="documentsToCheck") Set<DocumentId> var1);

    @Delete(value={"DELETE FROM public_links", "WHERE document_id = #{fileID} AND link_id = #{linkID}"})
    public void deleteLink(@Param(value="fileID") DocumentId var1, @Param(value="linkID") String var2);

    @Delete(value={"DELETE FROM public_links WHERE expiration_date < clock_timestamp()"})
    public void deleteExpiredLinks();

    @Select(value={"<script>", "SELECT link_id FROM public_links ", "WHERE document_id in (<foreach collection='documentIds' item='i' separator=','>#{i}</foreach>) ", "</script>"})
    @Nonnull
    public Set<String> getPublicLinksIncludingExpired(@Param(value="documentIds") Set<DocumentId> var1);

    @Update(value={"<script>", "UPDATE public_links", "<set>", "   <if test=\"expirationDate != null\">expiration_date = #{expirationDate},</if>", "   <if test=\"password != null\">password = #{password},</if>", "</set>", "WHERE document_id = #{fileID} AND link_id = #{linkID}", "</script>"})
    public void updateLink(@Param(value="fileID") DocumentId var1, @Param(value="linkID") String var2, @Nullable @Param(value="expirationDate") Instant var3, @Nullable @Param(value="password") String var4);
}

