/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.drive.business.track.impl;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import com.google.common.base.Charsets;
import com.google.common.collect.ImmutableMap;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import de.justsoftware.drive.business.common.ZookeeperUtil;
import de.justsoftware.drive.business.track.TrackingService;
import java.io.IOException;
import java.net.URLEncoder;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.recipes.cache.NodeCache;
import org.apache.http.ConnectionReuseStrategy;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.NoConnectionReuseStrategy;
import org.apache.http.impl.client.HttpClientBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@ParametersAreNonnullByDefault
public class HolmesTrackingService
implements TrackingService {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private static final Logger LOGGER = LoggerFactory.getLogger(HolmesTrackingService.class);
    private static final String SYSTEM_DOMAIN_PREFIX_PATH = "/just/config/just/common/system/domainprefix";
    private final ExecutorService _trackExecutor = Executors.newFixedThreadPool(10, new ThreadFactoryBuilder().setNameFormat("HolmesTrackingService-track-%d").build());
    private final NodeCache _systemDomainPrefixCache;

    @Autowired
    public HolmesTrackingService(CuratorFramework zookeeperClient) {
        this._systemDomainPrefixCache = ZookeeperUtil.createNodeCache((CuratorFramework)zookeeperClient, (String)SYSTEM_DOMAIN_PREFIX_PATH);
    }

    public void track(TrackingService.TrackingAction action, TrackingService.TrackingType type, String key, String value) {
        this.track(action, type, ImmutableMap.of((Object)key, (Object)value));
    }

    public void track(TrackingService.TrackingAction action, TrackingService.TrackingType type, ImmutableMap<String, String> params) {
        this._trackExecutor.execute(() -> {
            ObjectNode trackingObject = OBJECT_MAPPER.createObjectNode();
            for (Map.Entry param : params.entrySet()) {
                trackingObject.set((String)param.getKey(), (JsonNode)TextNode.valueOf((String)((String)param.getValue())));
            }
            trackingObject.set("action", (JsonNode)TextNode.valueOf((String)action.name()));
            trackingObject.set("type", (JsonNode)TextNode.valueOf((String)type.name()));
            trackingObject.set("jucoVersion", (JsonNode)TextNode.valueOf((String)"24.4.12-3967"));
            CloseableHttpResponse holmesResponse = null;
            try {
                String encodedTrackingObject = URLEncoder.encode(OBJECT_MAPPER.writeValueAsString((Object)trackingObject), Charsets.UTF_8.name());
                holmesResponse = HttpClientBuilder.create().setConnectionReuseStrategy((ConnectionReuseStrategy)NoConnectionReuseStrategy.INSTANCE).build().execute((HttpUriRequest)new HttpGet(ZookeeperUtil.getStringFromNodeCache((String)SYSTEM_DOMAIN_PREFIX_PATH, (NodeCache)this._systemDomainPrefixCache).orElse("") + "/holmes/track?t=" + encodedTrackingObject));
                int statusCode = holmesResponse.getStatusLine().getStatusCode();
                if (statusCode != 204) {
                    LOGGER.error("Could not send tracking event. HTTP status is " + statusCode);
                }
            }
            catch (IOException ex) {
                LOGGER.error("Error contacting Holmes", (Throwable)ex);
            }
            finally {
                if (holmesResponse != null) {
                    try {
                        holmesResponse.close();
                    }
                    catch (IOException ex) {
                        LOGGER.error("Could not close Holmes HTTP response", (Throwable)ex);
                    }
                }
            }
        });
    }
}

