/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.drive.business.migrationwiki;

import de.justsoftware.drive.business.migrationwiki.WikiDocumentMigrationService;
import de.justsoftware.drive.common.document.model.DocumentId;
import de.justsoftware.drive.common.item.model.ItemId;
import de.justsoftware.drive.persistence.transaction.TransactionSupport;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.kafka.annotation.KafkaListener;
import org.springframework.messaging.handler.annotation.Header;
import org.springframework.messaging.handler.annotation.Payload;
import org.springframework.stereotype.Component;

@Component
@ParametersAreNonnullByDefault
public class WikiDocumentMigrationTopicConsumer {
    public static final String TOPIC = "just.wiki.drive-file-migration";
    private final WikiDocumentMigrationService _documentMigrationService;
    private final TransactionSupport _transactionSupport;

    @Autowired
    public WikiDocumentMigrationTopicConsumer(WikiDocumentMigrationService documentMigrationService, TransactionSupport transactionSupport) {
        this._documentMigrationService = documentMigrationService;
        this._transactionSupport = transactionSupport;
    }

    @KafkaListener(topics={"just.wiki.drive-file-migration"}, containerFactory="migrationConsumerFactory", autoStartup="true")
    public void listen(@Header(value="kafka_receivedMessageKey") String key, @Payload ItemId moveTarget) {
        DocumentId documentToMove = new DocumentId(key);
        this._transactionSupport.doInTransaction(() -> this._documentMigrationService.moveFileToItem(documentToMove, moveTarget));
    }
}

