/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.drive.business.migrationwiki;

import de.justsoftware.drive.business.kafka.KafkaConsumerConfig;
import de.justsoftware.drive.business.kafka.serde.ItemIdDeserializer;
import de.justsoftware.drive.common.item.model.ItemId;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.kafka.common.serialization.StringDeserializer;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Profile;
import org.springframework.kafka.annotation.EnableKafka;
import org.springframework.kafka.config.ConcurrentKafkaListenerContainerFactory;
import org.springframework.kafka.config.KafkaListenerContainerFactory;
import org.springframework.kafka.core.ConsumerFactory;
import org.springframework.kafka.core.DefaultKafkaConsumerFactory;
import org.springframework.kafka.listener.ConcurrentMessageListenerContainer;

@Configuration
@EnableKafka
@Profile(value={"production"})
@ParametersAreNonnullByDefault
public class MigrationConsumerConfiguration {
    private final KafkaConsumerConfig _kafkaConsumerConfig;

    public MigrationConsumerConfiguration(KafkaConsumerConfig kafkaConsumerConfig) {
        this._kafkaConsumerConfig = kafkaConsumerConfig;
    }

    @Bean
    @Nonnull
    public KafkaListenerContainerFactory<ConcurrentMessageListenerContainer<String, ItemId>> migrationConsumerFactory() {
        Map props = this._kafkaConsumerConfig.defaultConsumerConfig();
        props.put("group.id", "just.drive.wiki-drive-file-migration.consumer");
        props.put("spring.deserializer.key.delegate.class", StringDeserializer.class);
        props.put("spring.deserializer.value.delegate.class", ItemIdDeserializer.class);
        ConcurrentKafkaListenerContainerFactory listenerFactory = new ConcurrentKafkaListenerContainerFactory();
        listenerFactory.setConsumerFactory((ConsumerFactory)new DefaultKafkaConsumerFactory(props));
        return listenerFactory;
    }
}

