/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.drive.business.file;

import com.google.common.collect.ImmutableMap;
import de.justsoftware.drive.business.file.FileLockService;
import de.justsoftware.drive.common.document.model.DocumentId;
import de.justsoftware.drive.common.file.model.FileLockBO;
import de.justsoftware.drive.common.person.model.PersonId;
import de.justsoftware.drive.persistence.file.FileLockDAO;
import java.time.Instant;
import java.util.Set;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@ParametersAreNonnullByDefault
public class FileLockServiceImpl
implements FileLockService {
    private final FileLockDAO _fileLockDAO;

    @Autowired
    public FileLockServiceImpl(FileLockDAO fileLockDAO) {
        this._fileLockDAO = fileLockDAO;
    }

    public void lockFile(DocumentId fileId, PersonId owner) {
        this._fileLockDAO.lockFile(fileId, owner, Instant.now());
    }

    public void release(DocumentId fileId) {
        this._fileLockDAO.release(fileId);
    }

    public ImmutableMap<DocumentId, FileLockBO> getLocks(Set<DocumentId> fileIds) {
        return this._fileLockDAO.getLocks(fileIds);
    }
}

