/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.drive.business.authorization;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.SetMultimap;
import de.justsoftware.drive.business.authorization.AuthorizationKey;
import de.justsoftware.drive.business.authorization.AuthorizationResult;
import de.justsoftware.drive.business.exception.PermissionDeniedException;
import de.justsoftware.drive.business.exception.UnknownResourceBusinessException;
import de.justsoftware.drive.common.authorization.model.StaticAction;
import de.justsoftware.drive.common.model.AbstractId;
import de.justsoftware.drive.common.person.model.PersonId;
import de.justsoftware.drive.common.tenant.model.TenantId;
import de.justsoftware.permission.client.model.Role;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import javax.annotation.CheckForNull;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public interface AuthorizationContext {
    default public void check(AbstractId<?> id, StaticAction action) throws PermissionDeniedException, UnknownResourceBusinessException {
        this.allowed(id, action).throwExcpetion();
    }

    default public <I extends AbstractId<?>> void check(SetMultimap<I, StaticAction> actions) throws PermissionDeniedException, UnknownResourceBusinessException {
        if (actions.isEmpty()) {
            return;
        }
        ImmutableCollection allowed = this.allowed((Set)AuthorizationKey.forSetMultimap(actions, (PersonId)this.getPersonId())).values();
        AuthorizationResult.combine((Collection)allowed).throwExcpetion();
    }

    @CheckReturnValue
    default public boolean may(AbstractId<?> id, StaticAction action) {
        return this.allowed(id, action).isOk();
    }

    @CheckReturnValue
    @Nonnull
    default public AuthorizationResult allowed(AbstractId<?> id, StaticAction action) {
        AuthorizationKey authorizationKey = new AuthorizationKey(this.getPersonId(), id, action);
        Optional authorizationResult = Optional.fromNullable((Object)((AuthorizationResult)this.allowed((Set)ImmutableSet.of((Object)authorizationKey)).get((Object)authorizationKey)));
        return AuthorizationResult.combine((Collection)authorizationResult.asSet());
    }

    @CheckReturnValue
    @Nonnull
    default public <I extends AbstractId<?>> ImmutableSetMultimap<I, StaticAction> may(SetMultimap<I, StaticAction> actions) {
        return (ImmutableSetMultimap)this.may((Set)AuthorizationKey.forSetMultimap(actions, (PersonId)this.getPersonId())).stream().collect(ImmutableSetMultimap.toImmutableSetMultimap(AuthorizationKey::getNullableId, AuthorizationKey::getAction));
    }

    @CheckReturnValue
    @Nonnull
    default public <I extends AbstractId<?>> Set<AuthorizationKey<I>> may(Set<AuthorizationKey<I>> actions) {
        return Maps.filterValues((Map)this.allowed(actions), AuthorizationResult::isOk).keySet();
    }

    @CheckReturnValue
    @Nonnull
    public <I extends AbstractId<?>> ImmutableMap<AuthorizationKey<I>, AuthorizationResult> allowed(Set<AuthorizationKey<I>> var1);

    @Nonnull
    public PersonId getPersonId();

    @CheckForNull
    public TenantId getTenantId();

    @Nonnull
    public TenantId getNonnullTenantId();

    @Nonnull
    default public <T extends AbstractId<?>> AuthorizationKey<T> key(@Nullable T id, StaticAction action) {
        return new AuthorizationKey(this.getPersonId(), id, action);
    }

    public void check(Set<Role> var1);

    default public void check(Role roleToCheck) {
        this.check((Set)ImmutableSet.of((Object)roleToCheck));
    }

    public boolean may(Role var1);
}

