--liquibase formatted sql

--changeset vinh.phu.phan:create_profile_table
CREATE TABLE profile (
    id ${int64} NOT NULL PRIMARY KEY,
    email ${varchar1024},
    full_name ${varchar1024} NOT NULL,
    first_name ${varchar255} NOT NULL,
    last_name ${varchar255} NOT NULL,
    image_url ${varchar4000} NOT NULL,
    profile_url ${varchar4000},
    active ${bool} NOT NULL,
    blocked ${bool} NOT NULL,
    deleted ${bool} NOT NULL,
    created_at ${timestamp} NOT NULL,
    updated_at ${timestamp} NOT NULL
);

--changeset alexander.zottnick:add_user_group_table
CREATE TABLE user_group (
    PRIMARY KEY (id),
    id ${uuid} NOT NULL,
    name ${varchar255} NOT NULL,
    tenant_id ${uuid} NOT NULL,
    is_all_tenant_users_group ${bool} NOT NULL,
    created_at ${timestamp} DEFAULT ${now} NOT NULL,
    updated_at ${timestamp} DEFAULT ${now} NOT NULL
);

CREATE TABLE user_group_member (
    PRIMARY KEY (group_id, profile_id),
    group_id ${uuid} NOT NULL,
    profile_id ${int32} NOT NULL,
    created_at ${timestamp} DEFAULT ${now} NOT NULL,
    updated_at ${timestamp} DEFAULT ${now} NOT NULL
);

--changeset vinh.phu.phan:create_chat_table
CREATE TABLE chat (
    id ${uuid} NOT NULL PRIMARY KEY,
    title ${varchar1024},
    type ${varchar64} NOT NULL,
    tenant_id ${uuid} NOT NULL,
    created_at ${timestamp} NOT NULL,
    updated_at ${timestamp} NOT NULL
);
CREATE INDEX chat_tenant_id_idx ON chat(tenant_id);

CREATE TABLE chat_participant (
    PRIMARY KEY (chat_id, participant_id),
    chat_id ${uuid} NOT NULL,
    participant_id ${varchar255} NOT NULL,
    permission_type ${varchar64} NOT NULL,
    created_at ${timestamp} DEFAULT ${now} NOT NULL,
    updated_at ${timestamp} DEFAULT ${now} NOT NULL
);
ALTER TABLE chat_participant ADD CONSTRAINT fk_chat_participant_chat_id FOREIGN KEY (chat_id) REFERENCES chat(id);
CREATE INDEX chat_participant_chat_id_idx ON chat_participant(chat_id);
CREATE INDEX chat_participant_part_id_idx ON chat_participant(participant_id);

--changeset sf:add_chat_message_table
CREATE TABLE chat_message (
    PRIMARY KEY (id),
    id ${uuid} NOT NULL,
    chat_id ${uuid} NOT NULL,
    message ${text},
    message_type ${varchar64} NOT NULL,
    author ${int32},
    created_at ${timestamp} DEFAULT ${now} NOT NULL,
    updated_at ${timestamp} DEFAULT ${now} NOT NULL
);
ALTER TABLE chat_message ADD CONSTRAINT fk_chat_message_chat_id FOREIGN KEY (chat_id) REFERENCES chat(id);
CREATE INDEX chat_message_chat_id_idx ON chat_message(chat_id);

--changeset vinh.phu.phan:add_index_to_user_group_member_profile_id
CREATE INDEX u_group_member_profile_id_idx ON user_group_member(profile_id);

--changeset sf:add_payload_to_chat_message_table
ALTER TABLE chat_message ADD payload ${text};

--changeset vinh.phu.phan:add_sync_date_and_sort_date_and_last_message_id_to_chat
DELETE FROM chat_message;
DELETE FROM chat_participant;
DELETE FROM chat;
ALTER TABLE chat ADD last_message_id ${uuid};
ALTER TABLE chat ADD sort_date ${timestamp} DEFAULT ${now} NOT NULL;
ALTER TABLE chat ADD sync_date ${timestamp} DEFAULT ${now} NOT NULL;
ALTER TABLE chat ADD CONSTRAINT fk_chat_last_message_id FOREIGN KEY (last_message_id) REFERENCES chat_message(id);

--changeset tsubklewe:add_chat_message_attachment_table
CREATE TABLE chat_message_attachment (
    PRIMARY KEY (id),
    id ${uuid} NOT NULL,
    message_id ${uuid} NOT NULL,
    document_id ${uuid} NOT NULL,
    document_version_id ${uuid} NOT NULL,
    mime_type ${varchar64} NOT NULL,
    file_name ${varchar64} NOT NULL,
    file_size ${int32} NOT NULL,
    height ${int32},
    width ${int32},
    created_at ${timestamp} DEFAULT ${now} NOT NULL,
    updated_at ${timestamp} DEFAULT ${now} NOT NULL
);
ALTER TABLE chat_message_attachment ADD CONSTRAINT fk_chat_message_attachment_message_id FOREIGN KEY (message_id) REFERENCES chat_message(id);

--changeset simon.ward:add_deleted_at_timestamp_to_chat_table
ALTER TABLE chat ADD deleted_at ${timestamp};

--changeset tsubklewe:cleanup_chat_message_attachment_table
ALTER TABLE chat_message_attachment DROP COLUMN height;
ALTER TABLE chat_message_attachment DROP COLUMN width;

--changeset sfleischer:add_chat_read_date_table
CREATE TABLE chat_read_date (
    PRIMARY KEY (chat_id, profile_id),
    chat_id ${uuid} NOT NULL,
    profile_id ${int64} NOT NULL,
    read_date ${timestamp} NOT NULL
);
ALTER TABLE chat_read_date ADD CONSTRAINT fk_chat_read_date_chat_id FOREIGN KEY (chat_id) REFERENCES chat(id);


--changeset tsubklewe:remove_attachment_message_type
UPDATE chat_message SET message_type = 'USER_MESSAGE' WHERE message_type = 'ATTACHMENT_MESSAGE' OR message_type = 'TEXT_MESSAGE';

--changeset tsubklewe:readd_dimensions
ALTER TABLE chat_message_attachment ADD height ${int32};
ALTER TABLE chat_message_attachment ADD width ${int32};

--changeset tsubklewe:increase_filename_length dbms:postgresql
ALTER TABLE chat_message_attachment ALTER COLUMN file_name TYPE ${varchar1024};

--changeset tsubklewe:increase_filename_length dbms:oracle
ALTER TABLE chat_message_attachment MODIFY file_name ${varchar1024};

--changeset tsubklewe:add_chat_profile_settings
CREATE TABLE chat_settings (
    PRIMARY KEY (chat_id, profile_id),
    chat_id ${uuid} NOT NULL,
    profile_id ${int64} NOT NULL,
    muted ${bool} NOT NULL,
    created_at ${timestamp} DEFAULT ${now} NOT NULL,
    updated_at ${timestamp} DEFAULT ${now} NOT NULL
);

ALTER TABLE chat_settings ADD CONSTRAINT fk_chat_settings_chat_id FOREIGN KEY (chat_id) REFERENCES chat(id);

--changeset tsubklewe:increase_mimetype_length dbms:postgresql
ALTER TABLE chat_message_attachment ALTER COLUMN mime_type TYPE ${varchar1024};

--changeset tsubklewe:increase_mimetype_length dbms:oracle
ALTER TABLE chat_message_attachment MODIFY mime_type ${varchar1024};

--changeset sgutsfeld:add_mobile_push_token_table
CREATE TABLE mobile_push_token (
    PRIMARY KEY (token, platform),
    token ${varchar255} NOT NULL,
    platform ${varchar64} NOT NULL,
    profile_id ${int64} NOT NULL,
    created_at ${timestamp} DEFAULT ${now} NOT NULL,
    updated_at ${timestamp} DEFAULT ${now} NOT NULL
);
CREATE INDEX mobile_push_token_profile_id_idx ON mobile_push_token(profile_id);

--changeset sfleischer:add_mail_settings
CREATE TABLE mail_settings (
    PRIMARY KEY (profile_id),
    profile_id ${int64} NOT NULL,
    mail_delivery_enabled ${bool} NOT NULL,
    created_at ${timestamp} DEFAULT ${now} NOT NULL,
    updated_at ${timestamp} DEFAULT ${now} NOT NULL
);

--changeset tsubklewe:add_deleted_participants
CREATE TABLE deleted_chat_participant (
    PRIMARY KEY (chat_id, participant_id),
    chat_id ${uuid} NOT NULL,
    participant_id ${varchar255} NOT NULL,
    permission_type ${varchar64} NOT NULL,
    created_at ${timestamp} DEFAULT ${now} NOT NULL,
    updated_at ${timestamp} DEFAULT ${now} NOT NULL
);
ALTER TABLE deleted_chat_participant ADD CONSTRAINT fk_deleted_chat_participant_chat_id FOREIGN KEY (chat_id) REFERENCES chat(id);


--changeset tsubklewe:add_deletion_log
CREATE TABLE chat_deletion (
    PRIMARY KEY (chat_id),
    chat_id ${uuid} NOT NULL,
    profile_id ${int64} NOT NULL,
    created_at ${timestamp} DEFAULT ${now} NOT NULL,
    updated_at ${timestamp} DEFAULT ${now} NOT NULL
);

--changeset tsubklewe:remove_deleted_at_flag
ALTER TABLE chat DROP COLUMN deleted_at;

--changeset sfleischer:add_chat_mail_delivery_date
CREATE TABLE chat_mail_delivery_date (
    PRIMARY KEY (chat_id, profile_id),
    chat_id ${uuid} NOT NULL,
    profile_id ${int64} NOT NULL,
    last_mail_delivery_date ${timestamp} NOT NULL
);
ALTER TABLE chat_mail_delivery_date ADD CONSTRAINT fk_chat_mail_delivery_date_chat_id FOREIGN KEY (chat_id) REFERENCES chat(id);

--changeset holger.dewes:add_chat_participant_native_ids
DELETE FROM chat_participant;
ALTER TABLE chat_participant ADD profile_id ${int64};
ALTER TABLE chat_participant ADD group_id ${uuid};
DELETE FROM deleted_chat_participant;
ALTER TABLE deleted_chat_participant ADD profile_id ${int64};
ALTER TABLE deleted_chat_participant ADD group_id ${uuid};

--changeset vinh.phu.phan:use_canonical_id_for_profile_and_user_group_part1 dbms:postgresql
DELETE FROM user_group_member;
DELETE FROM profile;
DELETE FROM user_group;
DELETE FROM chat_message_attachment;
UPDATE chat SET last_message_id = null;
DELETE FROM chat_message;
ALTER TABLE profile ALTER COLUMN id TYPE ${varchar255};
ALTER TABLE user_group ALTER COLUMN id TYPE ${varchar255};
ALTER TABLE user_group_member ALTER COLUMN group_id TYPE ${varchar255};
ALTER TABLE user_group_member ALTER COLUMN profile_id TYPE ${varchar255};
ALTER TABLE chat_message ALTER COLUMN author TYPE ${varchar255};

--changeset vinh.phu.phan:use_canonical_id_for_profile_and_user_group_part1 dbms:oracle
DELETE FROM user_group_member;
DELETE FROM profile;
DELETE FROM user_group;
DELETE FROM chat_message_attachment;
UPDATE chat SET last_message_id = null;
DELETE FROM chat_message;
ALTER TABLE profile MODIFY id ${varchar255};
ALTER TABLE user_group MODIFY id ${varchar255};
ALTER TABLE user_group_member MODIFY group_id ${varchar255};
ALTER TABLE user_group_member MODIFY profile_id ${varchar255};
ALTER TABLE chat_message MODIFY author ${varchar255};

--changeset vinh.phu.phan:revert_chat_participant_native_ids
ALTER TABLE chat_participant DROP COLUMN profile_id;
ALTER TABLE chat_participant DROP COLUMN group_id;
ALTER TABLE deleted_chat_participant DROP COLUMN profile_id;
ALTER TABLE deleted_chat_participant DROP COLUMN group_id;

--changeset vinh.phu.phan:use_canonical_id_for_profile_and_user_group_part2 dbms:postgresql
DELETE FROM chat_deletion;
DELETE FROM chat_settings;
DELETE FROM chat_read_date;
DELETE FROM mail_settings;
DELETE FROM mobile_push_token;
ALTER TABLE chat_deletion ALTER COLUMN profile_id TYPE ${varchar255};
ALTER TABLE chat_settings ALTER COLUMN profile_id TYPE ${varchar255};
ALTER TABLE chat_read_date ALTER COLUMN profile_id TYPE ${varchar255};
ALTER TABLE mail_settings ALTER COLUMN profile_id TYPE ${varchar255};
ALTER TABLE mobile_push_token ALTER COLUMN profile_id TYPE ${varchar255};

--changeset vinh.phu.phan:use_canonical_id_for_profile_and_user_group_part2 dbms:oracle
DELETE FROM chat_deletion;
DELETE FROM chat_settings;
DELETE FROM chat_read_date;
DELETE FROM mail_settings;
DELETE FROM mobile_push_token;
ALTER TABLE chat_deletion MODIFY profile_id ${varchar255};
ALTER TABLE chat_settings MODIFY profile_id ${varchar255};
ALTER TABLE chat_read_date MODIFY profile_id ${varchar255};
ALTER TABLE mail_settings MODIFY profile_id ${varchar255};
ALTER TABLE mobile_push_token MODIFY profile_id ${varchar255};

--changeset holger.dewes:add_removed_participant_profile_for_sync
CREATE TABLE removed_participant_profile_for_sync (
    PRIMARY KEY (profile_id, chat_id),
    profile_id ${varchar255} NOT NULL,
    chat_id ${uuid} NOT NULL,
    removed_at ${timestamp} NOT NULL,
    created_at ${timestamp} NOT NULL,
    updated_at ${timestamp} NOT NULL
);

--changeset sfleischer:drop_chat_mail_delivery_date
DROP TABLE chat_mail_delivery_date

--changeset sfleischer:add_last_mail_delivery_date_to_mail_settings
ALTER TABLE mail_settings ADD last_mail_delivery_date ${timestamp}

--changeset sfleischer:make_delivery_enabled_nullable dbms:postgresql
ALTER TABLE mail_settings ALTER COLUMN mail_delivery_enabled DROP NOT NULL;

--changeset sfleischer:make_delivery_enabled_nullable dbms:oracle
ALTER TABLE mail_settings MODIFY mail_delivery_enabled NULL;

--changeset sfleischer:create_migration_status_table
CREATE TABLE migration_status (
    status ${varchar255} NOT NULL,
    created_at ${timestamp} NOT NULL,
    updated_at ${timestamp} NOT NULL
);

--changeset sfleischer:change_attachment_message_to_null dbms:postgresql
UPDATE chat_message SET message = NULL WHERE message = '';

--changeset holger.dewes:recreate_removed_participant_profile_for_sync
DROP TABLE removed_participant_profile_for_sync;
CREATE TABLE removed_participant_profile_for_sync (
    PRIMARY KEY (id),
    id ${uuid} NOT NULL,
    profile_id ${varchar255} NOT NULL,
    chat_id ${uuid} NOT NULL,
    created_at ${timestamp} NOT NULL,
    updated_at ${timestamp} NOT NULL
);

--changeset sebastian.gutsfeld:add_created_at_and_updated_at_to_chat_read_date
ALTER TABLE chat_read_date ADD created_at ${timestamp} DEFAULT ${now} NOT NULL;
ALTER TABLE chat_read_date ADD updated_at ${timestamp} DEFAULT ${now} NOT NULL;
UPDATE chat_read_date SET created_at = read_date, updated_at = read_date;

--changeset tsubklewe:correct_last_message_id_when_migrating
UPDATE migration_status SET status = 'MIGRATE_ITEM_FINISHED' WHERE status IN ('SOLR_REINDEX_FINISHED', 'MIGRATION_FINISHED');

--changeset vinh.phu.phan:add_index_chat_msg_att_msg_id_idx
CREATE INDEX chat_msg_att_msg_id_idx ON chat_message_attachment(message_id);

--changeset vinh.phu.phan:drop_migration_status_table
DROP TABLE migration_status;

--changeset holger.dewes:delete_push_tokens_of_inactive_profiles dbms:postgresql
DELETE FROM mobile_push_token
WHERE profile_id IN (
    SELECT id
    FROM profile
    WHERE active = 'f' OR blocked = 't' OR deleted = 't'
);

--changeset holger.dewes:delete_push_tokens_of_inactive_profiles dbms:oracle
DELETE FROM mobile_push_token
WHERE profile_id IN (
    SELECT id
    FROM profile
    WHERE active = 0 OR blocked = 1 OR deleted = 1
);

--changeset holger.dewes:add_ios_silence_alerts
ALTER TABLE mobile_push_token ADD ios_silence_alerts ${bool} DEFAULT ${false} NOT NULL;

--changeset tsubklewe:add_marked_unread
ALTER TABLE chat_read_date ADD marked_as_unread ${bool} DEFAULT ${false} NOT NULL;

--changeset sward:add_mentions_of_persons
CREATE TABLE person_mention (
    PRIMARY KEY (id),
    id ${uuid} NOT NULL,
    message_id ${uuid} NOT NULL,
    profile_id ${varchar255} NOT NULL,
    name ${varchar1024} NOT NULL
);
ALTER TABLE person_mention ADD CONSTRAINT uc_person_mention UNIQUE (message_id, profile_id);
ALTER TABLE person_mention ADD CONSTRAINT fk_person_mention_message_id FOREIGN KEY (message_id) REFERENCES chat_message(id);
CREATE INDEX person_mention_msg_id_idx ON person_mention(message_id);

--changeset holger.dewes:add_audit_fields_to_person_mentions
ALTER TABLE person_mention ADD created_at ${timestamp} DEFAULT ${now} NOT NULL;
ALTER TABLE person_mention ADD updated_at ${timestamp} DEFAULT ${now} NOT NULL;

--changeset sward:add_citations
ALTER TABLE chat_message ADD cited_message_id ${uuid} DEFAULT NULL;
ALTER TABLE chat_message ADD CONSTRAINT fk_cited_message_id FOREIGN KEY (cited_message_id) REFERENCES chat_message(id);

--changeset tsubklewe:add_reactions
CREATE TABLE chat_message_reaction (
    PRIMARY KEY (message_id, profile_id),
    message_id ${uuid} NOT NULL,
    reaction ${varchar16},
    profile_id ${varchar255} NOT NULL,
    created_at ${timestamp} NOT NULL,
    updated_at ${timestamp} NOT NULL
);
ALTER TABLE chat_message_reaction ADD CONSTRAINT fk_reaction_message_id FOREIGN KEY (message_id) REFERENCES chat_message(id);
ALTER TABLE chat_message_reaction ADD CONSTRAINT fk_reaction_profile_id FOREIGN KEY (profile_id) REFERENCES profile(id);

--changeset holger.dewes:add_removed_message_reaction_for_sync
CREATE TABLE removed_message_reaction_for_sync (
    PRIMARY KEY (message_id, profile_id),
    message_id ${uuid} NOT NULL,
    profile_id ${varchar255} NOT NULL,
    created_at ${timestamp} NOT NULL,
    updated_at ${timestamp} NOT NULL
);

--changeset alexander.zottnick:add_tenant_to_profile
ALTER TABLE profile ADD tenant_id ${uuid};

--changeset alexander.zottnick:remove_tenant_from_profile
ALTER TABLE profile DROP COLUMN tenant_id;