/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.chat.persistence.model;

import de.justsoftware.chat.persistence.model.DbAuditModel;
import de.justsoftware.chat.persistence.model.DbChatProfileId;
import de.justsoftware.chat.persistence.model.DbChatReadDate;
import jakarta.persistence.Entity;
import jakarta.persistence.Id;
import jakarta.persistence.IdClass;
import jakarta.persistence.Table;
import java.time.Instant;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Entity
@Table(name="ChatReadDate")
@IdClass(value=DbChatProfileId.class)
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0018\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u0087\b\u0018\u0000 &2\u00020\u0001:\u0001&B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\t\u0010\u001b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001c\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u001d\u001a\u00020\u0007H\u00c6\u0003J\t\u0010\u001e\u001a\u00020\tH\u00c6\u0003J1\u0010\u001f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\tH\u00c6\u0001J\u0013\u0010 \u001a\u00020\t2\b\u0010!\u001a\u0004\u0018\u00010\"H\u00d6\u0003J\t\u0010#\u001a\u00020$H\u00d6\u0001J\t\u0010%\u001a\u00020\u0005H\u00d6\u0001R\u001e\u0010\u0002\u001a\u00020\u00038\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001a\u0010\b\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u001e\u0010\u0004\u001a\u00020\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u001a\u0010\u0006\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001a\u00a8\u0006'"}, d2={"Lde/justsoftware/chat/persistence/model/DbChatReadDate;", "Lde/justsoftware/chat/persistence/model/DbAuditModel;", "chatId", "Ljava/util/UUID;", "profileId", "", "readDate", "Ljava/time/Instant;", "markedAsUnread", "", "(Ljava/util/UUID;Ljava/lang/String;Ljava/time/Instant;Z)V", "getChatId", "()Ljava/util/UUID;", "setChatId", "(Ljava/util/UUID;)V", "getMarkedAsUnread", "()Z", "setMarkedAsUnread", "(Z)V", "getProfileId", "()Ljava/lang/String;", "setProfileId", "(Ljava/lang/String;)V", "getReadDate", "()Ljava/time/Instant;", "setReadDate", "(Ljava/time/Instant;)V", "component1", "component2", "component3", "component4", "copy", "equals", "other", "", "hashCode", "", "toString", "Companion", "chat-service"})
public final class DbChatReadDate
extends DbAuditModel {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Id
    @NotNull
    private UUID chatId;
    @Id
    @NotNull
    private String profileId;
    @NotNull
    private Instant readDate;
    private boolean markedAsUnread;

    public DbChatReadDate(@NotNull UUID chatId, @NotNull String profileId, @NotNull Instant readDate, boolean markedAsUnread) {
        Intrinsics.checkNotNullParameter((Object)chatId, (String)"chatId");
        Intrinsics.checkNotNullParameter((Object)profileId, (String)"profileId");
        Intrinsics.checkNotNullParameter((Object)readDate, (String)"readDate");
        this.chatId = chatId;
        this.profileId = profileId;
        this.readDate = readDate;
        this.markedAsUnread = markedAsUnread;
    }

    @NotNull
    public final UUID getChatId() {
        return this.chatId;
    }

    public final void setChatId(@NotNull UUID uUID) {
        Intrinsics.checkNotNullParameter((Object)uUID, (String)"<set-?>");
        this.chatId = uUID;
    }

    @NotNull
    public final String getProfileId() {
        return this.profileId;
    }

    public final void setProfileId(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.profileId = string;
    }

    @NotNull
    public final Instant getReadDate() {
        return this.readDate;
    }

    public final void setReadDate(@NotNull Instant instant) {
        Intrinsics.checkNotNullParameter((Object)instant, (String)"<set-?>");
        this.readDate = instant;
    }

    public final boolean getMarkedAsUnread() {
        return this.markedAsUnread;
    }

    public final void setMarkedAsUnread(boolean bl) {
        this.markedAsUnread = bl;
    }

    @NotNull
    public final UUID component1() {
        return this.chatId;
    }

    @NotNull
    public final String component2() {
        return this.profileId;
    }

    @NotNull
    public final Instant component3() {
        return this.readDate;
    }

    public final boolean component4() {
        return this.markedAsUnread;
    }

    @NotNull
    public final DbChatReadDate copy(@NotNull UUID chatId, @NotNull String profileId, @NotNull Instant readDate, boolean markedAsUnread) {
        Intrinsics.checkNotNullParameter((Object)chatId, (String)"chatId");
        Intrinsics.checkNotNullParameter((Object)profileId, (String)"profileId");
        Intrinsics.checkNotNullParameter((Object)readDate, (String)"readDate");
        return new DbChatReadDate(chatId, profileId, readDate, markedAsUnread);
    }

    public static /* synthetic */ DbChatReadDate copy$default(DbChatReadDate dbChatReadDate, UUID uUID, String string, Instant instant, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            uUID = dbChatReadDate.chatId;
        }
        if ((n & 2) != 0) {
            string = dbChatReadDate.profileId;
        }
        if ((n & 4) != 0) {
            instant = dbChatReadDate.readDate;
        }
        if ((n & 8) != 0) {
            bl = dbChatReadDate.markedAsUnread;
        }
        return dbChatReadDate.copy(uUID, string, instant, bl);
    }

    @NotNull
    public String toString() {
        return "DbChatReadDate(chatId=" + this.chatId + ", profileId=" + this.profileId + ", readDate=" + this.readDate + ", markedAsUnread=" + this.markedAsUnread + ")";
    }

    public int hashCode() {
        int result = this.chatId.hashCode();
        result = result * 31 + this.profileId.hashCode();
        result = result * 31 + this.readDate.hashCode();
        result = result * 31 + Boolean.hashCode(this.markedAsUnread);
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof DbChatReadDate)) {
            return false;
        }
        DbChatReadDate dbChatReadDate = (DbChatReadDate)other;
        if (!Intrinsics.areEqual((Object)this.chatId, (Object)dbChatReadDate.chatId)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.profileId, (Object)dbChatReadDate.profileId)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.readDate, (Object)dbChatReadDate.readDate)) {
            return false;
        }
        return this.markedAsUnread == dbChatReadDate.markedAsUnread;
    }

    public DbChatReadDate() {
    }
}

