/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.chat.business;

import de.justsoftware.chat.business.ChatParticipantService;
import de.justsoftware.chat.business.ChatReadDateService;
import de.justsoftware.chat.business.ChatService;
import de.justsoftware.chat.business.ChatSettingsService;
import de.justsoftware.chat.business.MailService;
import de.justsoftware.chat.business.SettingsService;
import de.justsoftware.chat.business.model.Chat;
import de.justsoftware.chat.business.model.ChatSettings;
import de.justsoftware.chat.business.model.MultiUserChat;
import de.justsoftware.chat.business.model.OneOnOneChat;
import de.justsoftware.chat.business.model.Profile;
import de.justsoftware.chat.business.model.UserChatUnreadCount;
import de.justsoftware.chat.config.ChatConfigProperties;
import de.justsoftware.chat.model.ChatId;
import de.justsoftware.chat.model.ProfileId;
import de.justsoftware.chat.util.CollectionUtilsKt;
import jakarta.persistence.EntityManager;
import java.time.Clock;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestOperations;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0094\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0017\u0018\u00002\u00020\u0001:\u00012Bc\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\b\b\u0001\u0010\u0010\u001a\u00020\u0011\u0012\b\b\u0001\u0010\u0012\u001a\u00020\u0013\u0012\u0006\u0010\u0014\u001a\u00020\u0015\u0012\u0006\u0010\u0016\u001a\u00020\u0017\u00a2\u0006\u0002\u0010\u0018J(\u0010\u001c\u001a\u0014\u0012\u0004\u0012\u00020\u001e\u0012\n\u0012\b\u0012\u0004\u0012\u00020 0\u001f0\u001d2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u001e0\"H\u0012J\"\u0010#\u001a\u00020$2\u0018\u0010%\u001a\u0014\u0012\u0004\u0012\u00020\u001e\u0012\n\u0012\b\u0012\u0004\u0012\u00020&0\u001f0\u001dH\u0012J\b\u0010'\u001a\u00020(H\u0017J\u0016\u0010)\u001a\u00020(2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u001e0\"H\u0012J0\u0010*\u001a\u0014\u0012\u0004\u0012\u00020\u001e\u0012\n\u0012\b\u0012\u0004\u0012\u00020 0\u001f0\u001d*\u0014\u0012\u0004\u0012\u00020\u001e\u0012\n\u0012\b\u0012\u0004\u0012\u00020 0\u001f0\u001dH\u0012J0\u0010+\u001a\u0004\u0018\u00010\u0011*\u00020,2\u0018\u0010-\u001a\u0014\u0012\u0004\u0012\u00020.\u0012\n\u0012\b\u0012\u0004\u0012\u00020/0\u001f0\u001d2\u0006\u00100\u001a\u00020\u001eH\u0012J0\u00101\u001a\u0014\u0012\u0004\u0012\u00020\u001e\u0012\n\u0012\b\u0012\u0004\u0012\u00020&0\u001f0\u001d*\u0014\u0012\u0004\u0012\u00020\u001e\u0012\n\u0012\b\u0012\u0004\u0012\u00020 0\u001f0\u001dH\u0012R\u000e\u0010\u0016\u001a\u00020\u0017X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u0011X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00063"}, d2={"Lde/justsoftware/chat/business/MailService;", "", "restOperations", "Lorg/springframework/web/client/RestOperations;", "chatService", "Lde/justsoftware/chat/business/ChatService;", "chatParticipantService", "Lde/justsoftware/chat/business/ChatParticipantService;", "chatReadDateService", "Lde/justsoftware/chat/business/ChatReadDateService;", "settingsService", "Lde/justsoftware/chat/business/SettingsService;", "chatSettingsService", "Lde/justsoftware/chat/business/ChatSettingsService;", "clock", "Ljava/time/Clock;", "toroInternalBaseUrl", "", "chatMailReceiverBatchSize", "", "entityManager", "Ljakarta/persistence/EntityManager;", "chatConfigProperties", "Lde/justsoftware/chat/config/ChatConfigProperties;", "(Lorg/springframework/web/client/RestOperations;Lde/justsoftware/chat/business/ChatService;Lde/justsoftware/chat/business/ChatParticipantService;Lde/justsoftware/chat/business/ChatReadDateService;Lde/justsoftware/chat/business/SettingsService;Lde/justsoftware/chat/business/ChatSettingsService;Ljava/time/Clock;Ljava/lang/String;ILjakarta/persistence/EntityManager;Lde/justsoftware/chat/config/ChatConfigProperties;)V", "log", "Lorg/slf4j/Logger;", "mailUrl", "getUnreadCountsForUsers", "", "Lde/justsoftware/chat/model/ProfileId;", "", "Lde/justsoftware/chat/business/model/UserChatUnreadCount;", "profileIds", "", "sendMailData", "", "mailData", "Lde/justsoftware/chat/business/MailService$ChatInfoDto;", "sendUnreadChatMails", "", "sendUnreadChatMailsChunked", "filterUsersWithAtLeastOneUnreadNonMutedChat", "getTitleForMail", "Lde/justsoftware/chat/business/model/Chat;", "oneOnOnePartners", "Lde/justsoftware/chat/model/ChatId;", "Lde/justsoftware/chat/business/model/Profile;", "currentProfileId", "toMailData", "ChatInfoDto", "chat-service"})
@SourceDebugExtension(value={"SMAP\nMailService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MailService.kt\nde/justsoftware/chat/business/MailService\n+ 2 LoggerUtils.kt\nde/justsoftware/chat/util/LoggerUtilsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 5 CollectionUtils.kt\nde/justsoftware/chat/util/CollectionUtilsKt\n+ 6 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,150:1\n9#2:151\n8#2,3:152\n766#3:155\n857#3,2:156\n1477#3:158\n1502#3,3:159\n1505#3,3:169\n1238#3,2:174\n1620#3,3:177\n1241#3:180\n1747#3,3:184\n800#3,11:191\n1620#3,3:203\n1603#3,9:208\n1855#3:217\n1603#3,9:218\n1855#3:227\n1856#3:229\n1612#3:230\n1856#3:233\n1612#3:234\n1179#3,2:236\n1253#3,4:238\n288#3,2:242\n372#4,7:162\n453#4:172\n403#4:173\n526#4:181\n511#4,2:182\n513#4,4:187\n7#5:176\n7#5:202\n80#5,2:206\n82#5:235\n1#6:228\n1#6:231\n1#6:232\n*S KotlinDebug\n*F\n+ 1 MailService.kt\nde/justsoftware/chat/business/MailService\n*L\n42#1:151\n42#1:152,3\n108#1:155\n108#1:156,2\n109#1:158\n109#1:159,3\n109#1:169,3\n110#1:174,2\n110#1:177,3\n110#1:180\n113#1:184,3\n120#1:191,11\n120#1:203,3\n132#1:208,9\n132#1:217\n134#1:218,9\n134#1:227\n134#1:229\n134#1:230\n132#1:233\n132#1:234\n132#1:236,2\n132#1:238,4\n146#1:242,2\n109#1:162,7\n110#1:172\n110#1:173\n111#1:181\n111#1:182,2\n111#1:187,4\n110#1:176\n120#1:202\n132#1:206,2\n132#1:235\n134#1:228\n132#1:232\n*E\n"})
public class MailService {
    @NotNull
    private final RestOperations restOperations;
    @NotNull
    private final ChatService chatService;
    @NotNull
    private final ChatParticipantService chatParticipantService;
    @NotNull
    private final ChatReadDateService chatReadDateService;
    @NotNull
    private final SettingsService settingsService;
    @NotNull
    private final ChatSettingsService chatSettingsService;
    @NotNull
    private final Clock clock;
    @NotNull
    private final String toroInternalBaseUrl;
    private final int chatMailReceiverBatchSize;
    @NotNull
    private final EntityManager entityManager;
    @NotNull
    private final ChatConfigProperties chatConfigProperties;
    @NotNull
    private final Logger log;
    @NotNull
    private final String mailUrl;

    public MailService(@Qualifier(value="internalApiRestOperations") @NotNull RestOperations restOperations, @NotNull ChatService chatService, @NotNull ChatParticipantService chatParticipantService, @NotNull ChatReadDateService chatReadDateService, @NotNull SettingsService settingsService, @NotNull ChatSettingsService chatSettingsService, @NotNull Clock clock, @Value(value="${just.toro.internal.baseurl}") @NotNull String toroInternalBaseUrl, @Value(value="${service.chat-mail-receiver-batch-size : 100}") int chatMailReceiverBatchSize, @NotNull EntityManager entityManager, @NotNull ChatConfigProperties chatConfigProperties) {
        Intrinsics.checkNotNullParameter((Object)restOperations, (String)"restOperations");
        Intrinsics.checkNotNullParameter((Object)chatService, (String)"chatService");
        Intrinsics.checkNotNullParameter((Object)chatParticipantService, (String)"chatParticipantService");
        Intrinsics.checkNotNullParameter((Object)chatReadDateService, (String)"chatReadDateService");
        Intrinsics.checkNotNullParameter((Object)settingsService, (String)"settingsService");
        Intrinsics.checkNotNullParameter((Object)chatSettingsService, (String)"chatSettingsService");
        Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
        Intrinsics.checkNotNullParameter((Object)toroInternalBaseUrl, (String)"toroInternalBaseUrl");
        Intrinsics.checkNotNullParameter((Object)entityManager, (String)"entityManager");
        Intrinsics.checkNotNullParameter((Object)chatConfigProperties, (String)"chatConfigProperties");
        this.restOperations = restOperations;
        this.chatService = chatService;
        this.chatParticipantService = chatParticipantService;
        this.chatReadDateService = chatReadDateService;
        this.settingsService = settingsService;
        this.chatSettingsService = chatSettingsService;
        this.clock = clock;
        this.toroInternalBaseUrl = toroInternalBaseUrl;
        this.chatMailReceiverBatchSize = chatMailReceiverBatchSize;
        this.entityManager = entityManager;
        this.chatConfigProperties = chatConfigProperties;
        MailService $this$logger$iv = this;
        boolean $i$f$logger = false;
        Logger logger = LoggerFactory.getLogger(Reflection.getOrCreateKotlinClass(MailService.class).isCompanion() ? MailService.class.getEnclosingClass() : MailService.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        this.log = logger;
        this.mailUrl = this.toroInternalBaseUrl + "/rest/internal/chat/mail";
    }

    @Transactional
    public long sendUnreadChatMails() {
        boolean mailNotificationDefault = this.chatConfigProperties.getDefaultEmailNotificationEnabled();
        return CollectionUtilsKt.chunked((Stream)this.chatReadDateService.getUsersEligibleForUnreadMail(mailNotificationDefault), (int)this.chatMailReceiverBatchSize).mapToLong(arg_0 -> MailService.sendUnreadChatMails$lambda$0((Function1)new /* Unavailable Anonymous Inner Class!! */, arg_0)).sum();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long sendUnreadChatMailsChunked(Set<ProfileId> profileIds) {
        Map mailData = this.toMailData(this.filterUsersWithAtLeastOneUnreadNonMutedChat(this.getUnreadCountsForUsers(profileIds)));
        try {
            this.sendMailData(mailData);
        }
        catch (RestClientException e) {
            this.log.error("An error occurred while sending chat notification mails", (Throwable)e);
            this.log.warn("Marking " + mailData.size() + " mail(s) as sent anyway to prevent repeat spamming of the recipients");
        }
        finally {
            Set set = mailData.keySet();
            Instant instant = this.clock.instant();
            Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"instant(...)");
            this.settingsService.saveMailDeliveryDates(set, instant);
        }
        return mailData.size();
    }

    private void sendMailData(Map<ProfileId, ? extends List<ChatInfoDto>> mailData) {
        if (mailData.isEmpty()) {
            return;
        }
        ResponseEntity responseEntity = this.restOperations.postForEntity(this.mailUrl, mailData, Void.class, new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)responseEntity, (String)"postForEntity(...)");
        ResponseEntity response = responseEntity;
        if (response.getStatusCode() != HttpStatus.OK) {
            throw new RestClientException("Failed to send notification mails. Juco Internal REST API returned StatusCode: " + response.getStatusCode().value());
        }
    }

    private Map<ProfileId, List<UserChatUnreadCount>> getUnreadCountsForUsers(Set<ProfileId> profileIds) {
        return this.chatReadDateService.getUnreadCountsForUsers(profileIds, false);
    }

    /*
     * WARNING - void declaration
     */
    private Map<ProfileId, List<UserChatUnreadCount>> filterUsersWithAtLeastOneUnreadNonMutedChat(Map<ProfileId, ? extends List<UserChatUnreadCount>> $this$filterUsersWithAtLeastOneUnreadNonMutedChat) {
        Object $this$mapValuesTo$iv$iv;
        Object value$iv$iv$iv;
        Object $this$getOrPut$iv$iv$iv;
        Object key$iv$iv;
        Object $this$groupByTo$iv$iv;
        boolean bl;
        ChatSettings p0;
        Iterable $this$filterTo$iv$iv;
        Object $this$filter$iv = this.chatSettingsService.findByProfileIdsAndChatIds($this$filterUsersWithAtLeastOneUnreadNonMutedChat.keySet(), ChatReadDateService.Companion.toChatIds($this$filterUsersWithAtLeastOneUnreadNonMutedChat));
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Object destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object t : $this$filterTo$iv$iv) {
            p0 = (ChatSettings)t;
            bl = false;
            if (!p0.getMuted()) continue;
            destination$iv$iv.add(t);
        }
        Iterable $this$groupBy$iv = (List)destination$iv$iv;
        boolean $i$f$groupBy = false;
        $this$filterTo$iv$iv = $this$groupBy$iv;
        destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        Iterator<Object> iterator = $this$groupByTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            Object object;
            Object t = iterator.next();
            p0 = (ChatSettings)t;
            bl = false;
            key$iv$iv = p0.getProfileId();
            $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(t);
        }
        Object $this$mapValues$iv = destination$iv$iv;
        boolean $i$f$mapValues = false;
        $this$groupByTo$iv$iv = $this$mapValues$iv;
        destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        boolean bl2 = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void $this$mapTo$iv$iv;
            void it$iv$iv;
            key$iv$iv = (Map.Entry)element$iv$iv$iv;
            $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean bl3 = false;
            value$iv$iv$iv = (Map.Entry)element$iv$iv$iv;
            Object k = it$iv$iv.getKey();
            Object object = $this$getOrPut$iv$iv$iv;
            boolean bl32 = false;
            List counts = (List)value$iv$iv$iv.getValue();
            Iterable $this$mapToSet$iv = counts;
            boolean $i$f$mapToSet = false;
            Iterable iterable2 = $this$mapToSet$iv;
            Collection destination$iv$iv2 = new LinkedHashSet(CollectionUtilsKt.getDefaultSize((Iterable)$this$mapToSet$iv));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void p02;
                ChatSettings chatSettings2 = (ChatSettings)item$iv$iv;
                Collection collection = destination$iv$iv2;
                boolean bl4 = false;
                collection.add(p02.getChatId());
            }
            Set set = (Set)destination$iv$iv2;
            object.put(k, set);
        }
        Object mutedChatIdsByProfileId = destination$iv$iv;
        $this$filter$iv = $this$filterUsersWithAtLeastOneUnreadNonMutedChat;
        $i$f$filter = false;
        $this$mapValuesTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new LinkedHashMap();
        $i$f$filterTo = false;
        for (Map.Entry entry : $this$filterTo$iv$iv.entrySet()) {
            boolean bl4;
            block11: {
                Map.Entry entry2 = entry;
                boolean bl5 = false;
                ProfileId profileId = (ProfileId)entry2.getKey();
                List counts = (List)entry2.getValue();
                Set set = (Set)mutedChatIdsByProfileId.get(profileId);
                if (set == null) {
                    set = SetsKt.emptySet();
                }
                Set mutedChatIds = set;
                Iterable $this$any$iv = counts;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl4 = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        UserChatUnreadCount count = (UserChatUnreadCount)element$iv;
                        boolean bl6 = false;
                        if (!(!mutedChatIds.contains(count.getChatId()))) continue;
                        bl4 = true;
                        break block11;
                    }
                    bl4 = false;
                }
            }
            if (!bl4) continue;
            destination$iv$iv.put(entry.getKey(), entry.getValue());
        }
        return destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private Map<ProfileId, List<ChatInfoDto>> toMailData(Map<ProfileId, ? extends List<UserChatUnreadCount>> $this$toMailData) {
        void $this$associateTo$iv$iv$iv;
        void $this$associate$iv$iv;
        void $this$mapNotNullTo$iv$iv$iv;
        Iterable $this$mapNotNull$iv$iv;
        Iterable $this$mapTo$iv$iv;
        void $this$mapToSet$iv;
        void $this$filterIsInstanceTo$iv$iv;
        Iterable $this$filterIsInstance$iv;
        Map chats2 = this.chatService.findByIds(ChatReadDateService.Companion.toChatIds($this$toMailData));
        Iterable iterable = chats2.values();
        ChatParticipantService chatParticipantService = this.chatParticipantService;
        boolean $i$f$filterIsInstance = false;
        void var6_6 = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof OneOnOneChat)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filterIsInstance$iv = (List)destination$iv$iv;
        boolean $i$f$mapToSet = false;
        $this$filterIsInstanceTo$iv$iv = $this$mapToSet$iv;
        destination$iv$iv = new LinkedHashSet(CollectionUtilsKt.getDefaultSize((Iterable)$this$mapToSet$iv));
        boolean $i$f$mapTo22 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            OneOnOneChat oneOnOneChat = (OneOnOneChat)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(p0.getId());
        }
        Map oneOnOneProfiles = chatParticipantService.getDirectChatPartners((Set)destination$iv$iv);
        Map<ProfileId, ? extends List<UserChatUnreadCount>> $this$mapValuesNotNull$iv = $this$toMailData;
        boolean $i$f$mapValuesNotNull = false;
        $this$mapTo$iv$iv = $this$mapValuesNotNull$iv.entrySet();
        boolean $i$f$mapNotNull = false;
        void $i$f$mapTo22 = $this$mapNotNull$iv$iv;
        Collection destination$iv$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv$iv = $this$mapNotNullTo$iv$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            Pair pair;
            void $this$mapNotNullTo$iv$iv;
            void $this$mapNotNull$iv;
            Object element$iv$iv$iv$iv;
            Object element$iv$iv$iv = element$iv$iv$iv$iv = iterator.next();
            boolean bl = false;
            Map.Entry entry$iv = (Map.Entry)element$iv$iv$iv;
            boolean bl2 = false;
            Map.Entry entry = entry$iv;
            boolean bl3 = false;
            List counts = (List)entry.getValue();
            Iterable iterable2 = counts;
            boolean $i$f$mapNotNull2 = false;
            void var24_35 = $this$mapNotNull$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$mapNotNullTo2 = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach2 = false;
            Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
            while (iterator2.hasNext()) {
                ChatInfoDto it$iv$iv;
                Object element$iv$iv$iv2;
                Object element$iv$iv = element$iv$iv$iv2 = iterator2.next();
                boolean bl4 = false;
                UserChatUnreadCount p0 = (UserChatUnreadCount)element$iv$iv;
                boolean bl5 = false;
                if (MailService.toMailData$toChatInfoDtoOrNull((UserChatUnreadCount)p0, (Map)chats2, (MailService)this, (Map)oneOnOneProfiles) == null) continue;
                boolean bl6 = false;
                destination$iv$iv2.add(it$iv$iv);
            }
            Iterable it = iterable2 = (List)destination$iv$iv2;
            boolean bl7 = false;
            if ((!((Collection)it).isEmpty() ? iterable2 : null) != null) {
                Iterable it$iv;
                it$iv = it$iv;
                boolean bl8 = false;
                pair = TuplesKt.to(entry$iv.getKey(), (Object)it$iv);
            } else {
                pair = null;
            }
            if (pair == null) continue;
            Pair it$iv$iv$iv = pair;
            boolean bl9 = false;
            destination$iv$iv$iv.add(it$iv$iv$iv);
        }
        $this$mapNotNull$iv$iv = (List)destination$iv$iv$iv;
        boolean $i$f$associate = false;
        int capacity$iv$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv$iv, (int)10)), (int)16);
        destination$iv$iv$iv = $this$associate$iv$iv;
        Map destination$iv$iv$iv2 = new LinkedHashMap(capacity$iv$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv$iv : $this$associateTo$iv$iv$iv) {
            Map map = destination$iv$iv$iv2;
            Pair it$iv = (Pair)element$iv$iv$iv;
            boolean bl = false;
            Pair pair = it$iv;
            map.put(pair.getFirst(), pair.getSecond());
        }
        return destination$iv$iv$iv2;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String getTitleForMail(Chat $this$getTitleForMail, Map<ChatId, ? extends List<Profile>> oneOnOnePartners, ProfileId currentProfileId) {
        Object v1;
        String string;
        block2: {
            void $this$firstOrNull$iv;
            Chat chat = $this$getTitleForMail;
            if (chat instanceof MultiUserChat) {
                string = ((MultiUserChat)$this$getTitleForMail).getTitle();
                return string;
            }
            if (!(chat instanceof OneOnOneChat)) throw new NoWhenBranchMatchedException();
            List<Profile> list = oneOnOnePartners.get($this$getTitleForMail.getId());
            if (list == null) return null;
            Iterable iterable = list;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                Profile profile = (Profile)element$iv;
                boolean bl = false;
                if (!(!Intrinsics.areEqual((Object)profile.getId(), (Object)currentProfileId))) continue;
                v1 = element$iv;
                break block2;
            }
            v1 = null;
        }
        Profile profile = v1;
        if (profile == null) return null;
        string = profile.getFullName();
        return string;
    }

    private static final long sendUnreadChatMails$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return ((Number)$tmp0.invoke(p0)).longValue();
    }

    private static final ChatInfoDto toMailData$toChatInfoDtoOrNull(UserChatUnreadCount $this$toMailData_u24toChatInfoDtoOrNull, Map<ChatId, ? extends Chat> chats2, MailService this$0, Map<ChatId, ? extends List<Profile>> oneOnOneProfiles) {
        ChatInfoDto chatInfoDto;
        Chat chat = chats2.get($this$toMailData_u24toChatInfoDtoOrNull.getChatId());
        if (chat != null) {
            Chat chat2 = chat;
            boolean bl = false;
            chatInfoDto = new ChatInfoDto(chat2.getId().toCanonicalId(), this$0.getTitleForMail(chat2, oneOnOneProfiles, $this$toMailData_u24toChatInfoDtoOrNull.getProfileId()), $this$toMailData_u24toChatInfoDtoOrNull.getUnreadCount());
        } else {
            chatInfoDto = null;
        }
        return chatInfoDto;
    }

    public static final /* synthetic */ long access$sendUnreadChatMailsChunked(MailService $this, Set profileIds) {
        return $this.sendUnreadChatMailsChunked(profileIds);
    }

    public static final /* synthetic */ EntityManager access$getEntityManager$p(MailService $this) {
        return $this.entityManager;
    }
}

