/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.chat.application;

import de.justsoftware.chat.application.ChatApplicationService;
import de.justsoftware.chat.application.model.AllowedActions;
import de.justsoftware.chat.application.model.AppPermissionsDto;
import de.justsoftware.chat.application.model.ChatDto;
import de.justsoftware.chat.application.model.ChatMessageAttachmentDto;
import de.justsoftware.chat.application.model.ChatMessageDto;
import de.justsoftware.chat.application.model.CreateChatDto;
import de.justsoftware.chat.application.model.MultiUserChatDto;
import de.justsoftware.chat.application.model.OneOnOneChatDto;
import de.justsoftware.chat.application.model.ProfileDto;
import de.justsoftware.chat.authorization.AuthorizationContext;
import de.justsoftware.chat.authorization.AuthorizationService;
import de.justsoftware.chat.business.ChatLocalizationService;
import de.justsoftware.chat.business.ChatMessageService;
import de.justsoftware.chat.business.ChatParticipantService;
import de.justsoftware.chat.business.ChatReadDateService;
import de.justsoftware.chat.business.ChatService;
import de.justsoftware.chat.business.ChatSettingsService;
import de.justsoftware.chat.business.ProfileService;
import de.justsoftware.chat.business.model.AttachmentFilter;
import de.justsoftware.chat.business.model.Chat;
import de.justsoftware.chat.business.model.ChatMessage;
import de.justsoftware.chat.business.model.ChatReadDateAndCount;
import de.justsoftware.chat.business.model.ChatSettings;
import de.justsoftware.chat.business.model.MultiUserChat;
import de.justsoftware.chat.business.model.OneOnOneChat;
import de.justsoftware.chat.business.model.Profile;
import de.justsoftware.chat.exception.NotAllowedException;
import de.justsoftware.chat.exception.ValidationException;
import de.justsoftware.chat.model.ChatId;
import de.justsoftware.chat.model.ChatMessageId;
import de.justsoftware.chat.model.Offset;
import de.justsoftware.chat.model.PageOffset;
import de.justsoftware.chat.model.PermissionType;
import de.justsoftware.chat.model.ProfileId;
import de.justsoftware.chat.model.TenantId;
import de.justsoftware.chat.util.CollectionUtilsKt;
import java.time.Clock;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

@Service
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00b8\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\b\u0017\u0018\u00002\u00020\u0001BW\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u0012\u0006\u0010\u0012\u001a\u00020\u0013\u0012\b\b\u0001\u0010\u0014\u001a\u00020\u0015\u00a2\u0006\u0002\u0010\u0016J\"\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\u0018\u0010\u001f\u001a\u00020 2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\u0010\u0010!\u001a\u00020\"2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J6\u0010#\u001a\b\u0012\u0004\u0012\u00020%0$2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020'2\u0006\u0010)\u001a\u00020*2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\u0018\u0010+\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\u0018\u0010,\u001a\u00020\u00182\u0006\u0010-\u001a\u00020.2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\u001a\u0010/\u001a\u0004\u0018\u0001002\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J&\u00101\u001a\b\u0012\u0004\u0012\u00020\u00180$2\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020'2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\u0010\u00102\u001a\u00020'2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J \u00103\u001a\u0002002\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u00104\u001a\u000200H\u0016J\u0018\u00105\u001a\u00020 2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J \u00106\u001a\u00020 2\u0006\u00107\u001a\u00020\u00152\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\u0018\u00108\u001a\u00020 2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J \u00109\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010:\u001a\u00020;2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J&\u0010<\u001a\u000e\u0012\u0004\u0012\u00020>\u0012\u0004\u0012\u00020?0=*\b\u0012\u0004\u0012\u00020A0@2\u0006\u0010\u001d\u001a\u00020\u001eH\u0012J\u0014\u0010B\u001a\u00020\u0018*\u00020A2\u0006\u0010\u001d\u001a\u00020\u001eH\u0012J \u0010C\u001a\b\u0012\u0004\u0012\u00020\u00180D*\b\u0012\u0004\u0012\u00020A0@2\u0006\u0010\u001d\u001a\u00020\u001eH\u0012R\u000e\u0010\u0010\u001a\u00020\u0011X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006E"}, d2={"Lde/justsoftware/chat/application/ChatApplicationService;", "", "chatService", "Lde/justsoftware/chat/business/ChatService;", "chatParticipantService", "Lde/justsoftware/chat/business/ChatParticipantService;", "chatMessageService", "Lde/justsoftware/chat/business/ChatMessageService;", "profileService", "Lde/justsoftware/chat/business/ProfileService;", "chatReadDateService", "Lde/justsoftware/chat/business/ChatReadDateService;", "chatSettingsService", "Lde/justsoftware/chat/business/ChatSettingsService;", "chatLocalizationService", "Lde/justsoftware/chat/business/ChatLocalizationService;", "authorizationService", "Lde/justsoftware/chat/authorization/AuthorizationService;", "clock", "Ljava/time/Clock;", "react", "", "(Lde/justsoftware/chat/business/ChatService;Lde/justsoftware/chat/business/ChatParticipantService;Lde/justsoftware/chat/business/ChatMessageService;Lde/justsoftware/chat/business/ProfileService;Lde/justsoftware/chat/business/ChatReadDateService;Lde/justsoftware/chat/business/ChatSettingsService;Lde/justsoftware/chat/business/ChatLocalizationService;Lde/justsoftware/chat/authorization/AuthorizationService;Ljava/time/Clock;Z)V", "createChat", "Lde/justsoftware/chat/application/model/ChatDto;", "chatId", "Lde/justsoftware/chat/model/ChatId;", "createChatDto", "Lde/justsoftware/chat/application/model/CreateChatDto;", "authContext", "Lde/justsoftware/chat/authorization/AuthorizationContext;", "deleteChat", "", "getAppPermissions", "Lde/justsoftware/chat/application/model/AppPermissionsDto;", "getAttachmentsForChat", "Lorg/springframework/data/domain/Page;", "Lde/justsoftware/chat/application/model/ChatMessageAttachmentDto;", "page", "", "pageSize", "attachmentFilter", "Lde/justsoftware/chat/business/model/AttachmentFilter;", "getChat", "getOrCreateOneOnOneChat", "chatPartnerId", "Lde/justsoftware/chat/model/ProfileId;", "getReadDate", "Ljava/time/Instant;", "getRecentChats", "getUnreadMessageCount", "markChatAsRead", "readDate", "markChatAsUnread", "muteChat", "muted", "restoreChat", "updateUserGroupChatTitle", "title", "", "loadLastMessages", "", "Lde/justsoftware/chat/model/ChatMessageId;", "Lde/justsoftware/chat/application/model/ChatMessageDto;", "", "Lde/justsoftware/chat/business/model/Chat;", "toChatDto", "toChatDtos", "", "chat-service"})
@SourceDebugExtension(value={"SMAP\nChatApplicationService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ChatApplicationService.kt\nde/justsoftware/chat/application/ChatApplicationService\n+ 2 PagingUtils.kt\nde/justsoftware/chat/util/PagingUtilsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 CollectionUtils.kt\nde/justsoftware/chat/util/CollectionUtilsKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 6 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,286:1\n11#2:287\n800#3,11:288\n1620#3,3:300\n800#3,11:303\n1620#3,3:315\n1611#3:319\n1855#3:320\n1856#3:322\n1612#3:323\n1549#3:324\n1620#3,2:325\n1622#3:328\n1611#3:330\n1855#3:331\n1856#3:333\n1612#3:334\n1620#3,3:336\n1238#3,4:341\n7#4:299\n7#4:314\n10#4:318\n10#4:329\n7#4:335\n1#5:321\n1#5:327\n1#5:332\n453#6:339\n403#6:340\n*S KotlinDebug\n*F\n+ 1 ChatApplicationService.kt\nde/justsoftware/chat/application/ChatApplicationService\n*L\n146#1:287\n221#1:288,11\n221#1:300,3\n225#1:303,11\n225#1:315,3\n238#1:319\n238#1:320\n238#1:322\n238#1:323\n242#1:324\n242#1:325,2\n242#1:328\n276#1:330\n276#1:331\n276#1:333\n276#1:334\n277#1:336,3\n278#1:341,4\n221#1:299\n225#1:314\n238#1:318\n276#1:329\n277#1:335\n238#1:321\n276#1:332\n278#1:339\n278#1:340\n*E\n"})
public class ChatApplicationService {
    @NotNull
    private final ChatService chatService;
    @NotNull
    private final ChatParticipantService chatParticipantService;
    @NotNull
    private final ChatMessageService chatMessageService;
    @NotNull
    private final ProfileService profileService;
    @NotNull
    private final ChatReadDateService chatReadDateService;
    @NotNull
    private final ChatSettingsService chatSettingsService;
    @NotNull
    private final ChatLocalizationService chatLocalizationService;
    @NotNull
    private final AuthorizationService authorizationService;
    @NotNull
    private final Clock clock;
    private final boolean react;

    public ChatApplicationService(@NotNull ChatService chatService, @NotNull ChatParticipantService chatParticipantService, @NotNull ChatMessageService chatMessageService, @NotNull ProfileService profileService, @NotNull ChatReadDateService chatReadDateService, @NotNull ChatSettingsService chatSettingsService, @NotNull ChatLocalizationService chatLocalizationService, @NotNull AuthorizationService authorizationService, @NotNull Clock clock, @Value(value="${just.chat.toggles.react:false}") boolean react2) {
        Intrinsics.checkNotNullParameter((Object)chatService, (String)"chatService");
        Intrinsics.checkNotNullParameter((Object)chatParticipantService, (String)"chatParticipantService");
        Intrinsics.checkNotNullParameter((Object)chatMessageService, (String)"chatMessageService");
        Intrinsics.checkNotNullParameter((Object)profileService, (String)"profileService");
        Intrinsics.checkNotNullParameter((Object)chatReadDateService, (String)"chatReadDateService");
        Intrinsics.checkNotNullParameter((Object)chatSettingsService, (String)"chatSettingsService");
        Intrinsics.checkNotNullParameter((Object)chatLocalizationService, (String)"chatLocalizationService");
        Intrinsics.checkNotNullParameter((Object)authorizationService, (String)"authorizationService");
        Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
        this.chatService = chatService;
        this.chatParticipantService = chatParticipantService;
        this.chatMessageService = chatMessageService;
        this.profileService = profileService;
        this.chatReadDateService = chatReadDateService;
        this.chatSettingsService = chatSettingsService;
        this.chatLocalizationService = chatLocalizationService;
        this.authorizationService = authorizationService;
        this.clock = clock;
        this.react = react2;
    }

    @Nullable
    public ChatDto createChat(@NotNull ChatId chatId, @NotNull CreateChatDto createChatDto, @NotNull AuthorizationContext authContext) throws ValidationException, NotAllowedException {
        Intrinsics.checkNotNullParameter((Object)chatId, (String)"chatId");
        Intrinsics.checkNotNullParameter((Object)createChatDto, (String)"createChatDto");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        switch (WhenMappings.$EnumSwitchMapping$0[createChatDto.getType().ordinal()]) {
            case 1: {
                authContext.checkCreateOneOnOneChat();
                break;
            }
            case 2: {
                authContext.checkCreateGroupChat();
            }
        }
        ChatDto createdChat = this.toChatDto(this.chatService.createChat(CreateChatDto.Companion.toChat(createChatDto, chatId, authContext.getTenantId(), this.clock), createChatDto.getParticipants(), authContext.getProfileId()), authContext);
        return authContext.mayReadChats(SetsKt.setOf((Object)chatId)).getOrDefault(chatId, false) != false ? createdChat : null;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public ChatDto getOrCreateOneOnOneChat(@NotNull ProfileId chatPartnerId, @NotNull AuthorizationContext authContext) throws ValidationException, NotAllowedException {
        void now;
        Intrinsics.checkNotNullParameter((Object)chatPartnerId, (String)"chatPartnerId");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        ChatId chatId = this.chatParticipantService.getOneOnOneChatIdByChatPartnerId(chatPartnerId, authContext.getProfileId());
        if (chatId != null) {
            ChatId chatId2 = chatId;
            boolean bl = false;
            authContext.checkReadChat(chatId2);
            return this.toChatDto(this.chatService.getById(chatId2), authContext);
        }
        authContext.checkCreateOneOnOneChat();
        Instant instant = this.clock.instant();
        ChatService chatService = this.chatService;
        ChatApplicationService chatApplicationService = this;
        boolean bl = false;
        ChatId chatId3 = ChatId.Companion.generate();
        TenantId tenantId = authContext.getTenantId();
        Intrinsics.checkNotNull((Object)now);
        OneOnOneChat oneOnOneChat = new OneOnOneChat(chatId3, tenantId, null, (Instant)now, (Instant)now, (Instant)now, (Instant)now);
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)chatPartnerId, (Object)PermissionType.MANAGER), TuplesKt.to((Object)authContext.getProfileId(), (Object)PermissionType.MANAGER)};
        return chatApplicationService.toChatDto(chatService.createChat((Chat)oneOnOneChat, MapsKt.mapOf((Pair[])pairArray), authContext.getProfileId()), authContext);
    }

    @NotNull
    public ChatDto updateUserGroupChatTitle(@NotNull ChatId chatId, @NotNull String title, @NotNull AuthorizationContext authContext) throws ValidationException, NotAllowedException {
        Intrinsics.checkNotNullParameter((Object)chatId, (String)"chatId");
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        authContext.checkManageChat(chatId);
        return this.toChatDto(this.chatService.updateUserGroupChatTitle(chatId, title, authContext.getProfileId()), authContext);
    }

    @NotNull
    public ChatDto getChat(@NotNull ChatId chatId, @NotNull AuthorizationContext authContext) {
        Intrinsics.checkNotNullParameter((Object)chatId, (String)"chatId");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        authContext.checkReadChat(chatId);
        return this.toChatDto(this.chatService.getById(chatId), authContext);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Page<ChatDto> getRecentChats(int page, int pageSize, @NotNull AuthorizationContext authContext) {
        void $this$mapContent$iv;
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        Page page2 = this.chatService.getRecentChats(authContext.getProfileId(), authContext.getTenantId(), (Offset)new PageOffset(page, pageSize));
        boolean $i$f$mapContent = false;
        Iterable it = (Iterable)$this$mapContent$iv;
        boolean bl = false;
        long l = $this$mapContent$iv.getTotalElements();
        Pageable pageable = $this$mapContent$iv.getPageable();
        List list = this.toChatDtos(it, authContext);
        return (Page)new PageImpl(list, pageable, l);
    }

    public int getUnreadMessageCount(@NotNull AuthorizationContext authContext) {
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        Set chats2 = this.chatService.findIdsOfProfile(authContext.getProfileId(), authContext.getTenantId());
        return this.chatReadDateService.getUnreadMessageCount(chats2, authContext.getProfileId());
    }

    @NotNull
    public AppPermissionsDto getAppPermissions(@NotNull AuthorizationContext authContext) {
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        return new AppPermissionsDto(this.authorizationService.mayProfileCreateOneOnOneChat(authContext.getTenantId(), authContext.getProfileId()), this.authorizationService.mayProfileCreateMultiUserChat(authContext.getTenantId(), authContext.getProfileId()), this.react);
    }

    public void deleteChat(@NotNull ChatId chatId, @NotNull AuthorizationContext authContext) {
        Intrinsics.checkNotNullParameter((Object)chatId, (String)"chatId");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        authContext.checkManageChat(chatId);
        this.chatService.delete(chatId, authContext.getProfileId());
    }

    @NotNull
    public Instant markChatAsRead(@NotNull ChatId chatId, @NotNull AuthorizationContext authContext, @NotNull Instant readDate) {
        Intrinsics.checkNotNullParameter((Object)chatId, (String)"chatId");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        Intrinsics.checkNotNullParameter((Object)readDate, (String)"readDate");
        authContext.checkReadChat(chatId);
        return this.chatReadDateService.markAsRead(chatId, authContext.getProfileId(), readDate).getReadDate();
    }

    public void markChatAsUnread(@NotNull ChatId chatId, @NotNull AuthorizationContext authContext) {
        Intrinsics.checkNotNullParameter((Object)chatId, (String)"chatId");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        authContext.checkReadChat(chatId);
        this.chatReadDateService.markAsUnread(chatId, authContext.getProfileId());
    }

    @Nullable
    public Instant getReadDate(@NotNull ChatId chatId, @NotNull AuthorizationContext authContext) {
        Intrinsics.checkNotNullParameter((Object)chatId, (String)"chatId");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        authContext.checkReadChat(chatId);
        return this.chatReadDateService.getReadDate(authContext.getProfileId(), chatId);
    }

    public void muteChat(boolean muted, @NotNull ChatId chatId, @NotNull AuthorizationContext authContext) {
        Intrinsics.checkNotNullParameter((Object)chatId, (String)"chatId");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        authContext.checkReadChat(chatId);
        this.chatSettingsService.muteChat(chatId, authContext.getProfileId(), muted);
    }

    public void restoreChat(@NotNull ChatId chatId, @NotNull AuthorizationContext authContext) {
        Intrinsics.checkNotNullParameter((Object)chatId, (String)"chatId");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        authContext.checkRestoreChats();
        this.chatService.restoreChat(chatId, authContext.getProfileId());
    }

    @NotNull
    public Page<ChatMessageAttachmentDto> getAttachmentsForChat(@NotNull ChatId chatId, int page, int pageSize, @NotNull AttachmentFilter attachmentFilter, @NotNull AuthorizationContext authContext) {
        Intrinsics.checkNotNullParameter((Object)chatId, (String)"chatId");
        Intrinsics.checkNotNullParameter((Object)attachmentFilter, (String)"attachmentFilter");
        Intrinsics.checkNotNullParameter((Object)authContext, (String)"authContext");
        authContext.checkReadChat(chatId);
        Page attachments = this.chatService.findAttachmentsForChat(chatId, (Offset)new PageOffset(page, pageSize), attachmentFilter);
        Set set = attachments.map(arg_0 -> ChatApplicationService.getAttachmentsForChat$lambda$3((Function1)getAttachmentsForChat.profiles.1.INSTANCE, arg_0)).toSet();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"toSet(...)");
        Map profiles2 = this.profileService.findByIds(set);
        Page page2 = attachments.map(arg_0 -> ChatApplicationService.getAttachmentsForChat$lambda$4((Function1)new /* Unavailable Anonymous Inner Class!! */, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)page2, (String)"map(...)");
        return page2;
    }

    private ChatDto toChatDto(Chat $this$toChatDto, AuthorizationContext authContext) {
        return (ChatDto)CollectionsKt.first((List)this.toChatDtos((Iterable)CollectionsKt.listOf((Object)$this$toChatDto), authContext));
    }

    /*
     * WARNING - void declaration
     */
    private List<ChatDto> toChatDtos(Iterable<? extends Chat> $this$toChatDtos, AuthorizationContext authContext) {
        void $this$mapTo$iv$iv;
        Object element$iv$iv;
        void $this$mapNotNullTo$iv$iv;
        void $this$mapTo$iv$iv2;
        void $this$mapToSet$iv;
        void $this$filterIsInstanceTo$iv$iv;
        void $this$mapTo$iv$iv3;
        void $this$mapToSet$iv2;
        void $this$filterIsInstanceTo$iv$iv2;
        Iterable $this$filterIsInstance$iv;
        Iterable iterable = $this$toChatDtos;
        Object object = this.chatParticipantService;
        boolean $i$f$filterIsInstance = false;
        void var6_7 = $this$filterIsInstance$iv;
        Iterable destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv2 : $this$filterIsInstanceTo$iv$iv2) {
            if (!(element$iv$iv2 instanceof OneOnOneChat)) continue;
            destination$iv$iv.add(element$iv$iv2);
        }
        $this$filterIsInstance$iv = (List)destination$iv$iv;
        boolean $i$f$mapToSet = false;
        $this$filterIsInstanceTo$iv$iv2 = $this$mapToSet$iv2;
        destination$iv$iv = new LinkedHashSet(CollectionUtilsKt.getDefaultSize((Iterable)$this$mapToSet$iv2));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv3) {
            void p0;
            Chat chat = (Chat)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(p0.getId());
        }
        Map oneOnOneChatPartnerByChatId = object.getDirectChatPartnersForProfile((Set)destination$iv$iv, authContext.getProfileId());
        Iterable $this$filterIsInstance$iv2 = $this$toChatDtos;
        boolean $i$f$filterIsInstance2 = false;
        destination$iv$iv = $this$filterIsInstance$iv2;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterIsInstanceTo2 = false;
        for (Object element$iv$iv3 : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv3 instanceof MultiUserChat)) continue;
            destination$iv$iv2.add(element$iv$iv3);
        }
        $this$filterIsInstance$iv2 = (List)destination$iv$iv2;
        boolean $i$f$mapToSet2 = false;
        $this$filterIsInstanceTo$iv$iv = $this$mapToSet$iv;
        destination$iv$iv2 = new LinkedHashSet(CollectionUtilsKt.getDefaultSize((Iterable)$this$mapToSet$iv));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            void p0;
            Chat bl = (Chat)item$iv$iv;
            object = destination$iv$iv2;
            boolean bl2 = false;
            object.add(p0.getId());
        }
        Set multiUserChatIds = (Set)destination$iv$iv2;
        Set chatsWithoutWriter = this.authorizationService.filterChatIdsWithoutPermission((Iterable)multiUserChatIds, PermissionType.WRITER);
        Set chatsWithoutManager = this.authorizationService.filterChatIdsWithoutPermission((Iterable)multiUserChatIds, PermissionType.MANAGER);
        Map multiUserChatAllowedActionsByChatId = authContext.toMultiUserChatsAllowedActions(multiUserChatIds, chatsWithoutWriter, chatsWithoutManager);
        Map lastMessages = this.loadLastMessages($this$toChatDtos, authContext);
        Iterable $this$mapNotNullToSet$iv = $this$toChatDtos;
        boolean $i$f$mapNotNullToSet = false;
        Iterable p0 = $this$mapNotNullToSet$iv;
        Collection destination$iv$iv3 = new LinkedHashSet(CollectionUtilsKt.getDefaultSize((Iterable)$this$mapNotNullToSet$iv));
        boolean $i$f$mapNotNullTo22 = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            ChatId it$iv$iv;
            Object element$iv$iv$iv;
            element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            Chat p02 = (Chat)element$iv$iv;
            boolean bl3 = false;
            if (p02.getId() == null) continue;
            boolean bl4 = false;
            destination$iv$iv3.add(it$iv$iv);
        }
        Set chatIds2 = (Set)destination$iv$iv3;
        Map chatsReadData = this.chatReadDateService.getReadData(authContext.getProfileId(), chatIds2);
        Map chatSettings2 = this.chatSettingsService.getSettings(authContext.getProfileId(), chatIds2);
        Iterable $this$map$iv = $this$toChatDtos;
        boolean $i$f$map = false;
        Iterable $i$f$mapNotNullTo22 = $this$map$iv;
        Collection destination$iv$iv4 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo3 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            ChatDto chatDto;
            ChatReadDateAndCount chatReadDate;
            void chat;
            element$iv$iv = (Chat)item$iv$iv;
            object = destination$iv$iv4;
            boolean bl = false;
            ChatMessageDto lastMessage = chat.getLastMessageId() != null ? (ChatMessageDto)lastMessages.get(chat.getLastMessageId()) : null;
            ChatReadDateAndCount chatReadDateAndCount = chatReadDate = (ChatReadDateAndCount)chatsReadData.get(chat.getId());
            long messageUnreadCount = chatReadDateAndCount != null ? chatReadDateAndCount.getUnreadCount() : 0L;
            ChatReadDateAndCount chatReadDateAndCount2 = chatReadDate;
            boolean markedAsUnread = chatReadDateAndCount2 != null ? chatReadDateAndCount2.getMarkedAsUnread() : false;
            ChatReadDateAndCount chatReadDateAndCount3 = chatReadDate;
            boolean amIMentioned = chatReadDateAndCount3 != null ? chatReadDateAndCount3.getAmIMentioned() : false;
            Map map = chatSettings2;
            Object object2 = map.get(chat.getId());
            if (object2 == null) {
                boolean bl5 = false;
                object2 = new ChatSettings(chat.getId(), authContext.getProfileId(), false, null, 12, null);
            }
            ChatSettings chatSettingsOrDefault = (ChatSettings)object2;
            map = chat;
            if (map instanceof OneOnOneChat) {
                Profile chatPartner = (Profile)oneOnOneChatPartnerByChatId.get(chat.getId());
                Profile profile = chatPartner;
                chatDto = (ChatDto)OneOnOneChatDto.Companion.toOneOnOneChatDto((OneOnOneChat)chat, this.chatLocalizationService.localizeOneOnOneChatTitleWithPrefix(chatPartner, authContext), profile != null ? ProfileDto.Companion.toProfileDto(profile) : null, lastMessage, messageUnreadCount, markedAsUnread, amIMentioned, chatSettingsOrDefault);
            } else if (map instanceof MultiUserChat) {
                chatDto = (ChatDto)MultiUserChatDto.Companion.toMultiUserChatDto((MultiUserChat)chat, (AllowedActions)MapsKt.getValue((Map)multiUserChatAllowedActionsByChatId, (Object)chat.getId()), lastMessage, messageUnreadCount, markedAsUnread, amIMentioned, chatSettingsOrDefault);
            } else {
                throw new NoWhenBranchMatchedException();
            }
            object.add(chatDto);
        }
        return (List)destination$iv$iv4;
    }

    /*
     * WARNING - void declaration
     */
    private Map<ChatMessageId, ChatMessageDto> loadLastMessages(Iterable<? extends Chat> $this$loadLastMessages, AuthorizationContext authContext) {
        void $this$mapValuesTo$iv$iv;
        Collection<Object> collection;
        Map $this$mapTo$iv$iv;
        void $this$mapToSet$iv;
        Object element$iv$iv$iv;
        void $this$mapNotNullTo$iv$iv;
        void $this$mapNotNullToSet$iv;
        Iterable<? extends Chat> iterable = $this$loadLastMessages;
        Object object = this.chatMessageService;
        boolean $i$f$mapNotNullToSet22 = false;
        void var6_7 = $this$mapNotNullToSet$iv;
        Collection destination$iv$iv = new LinkedHashSet(CollectionUtilsKt.getDefaultSize((Iterable)$this$mapNotNullToSet$iv));
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach22 = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            ChatMessageId it$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            Chat p0 = (Chat)element$iv$iv;
            boolean bl2 = false;
            if (p0.getLastMessageId() == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Map lastMessages = object.findByIds((Set)destination$iv$iv);
        Iterable $i$f$mapNotNullToSet22 = lastMessages.values();
        object = this.profileService;
        boolean $i$f$mapToSet = false;
        destination$iv$iv = $this$mapToSet$iv;
        Object destination$iv$iv2 = new LinkedHashSet(CollectionUtilsKt.getDefaultSize((Iterable)$this$mapToSet$iv));
        boolean $i$f$mapTo = false;
        Iterator $i$f$forEach22 = $this$mapTo$iv$iv.iterator();
        while ($i$f$forEach22.hasNext()) {
            void p0;
            Object item$iv$iv = $i$f$forEach22.next();
            element$iv$iv$iv = (ChatMessage)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl = false;
            collection.add(p0.getAuthor());
        }
        Map lastMessageAuthors = object.findByIds((Set)destination$iv$iv2);
        Map $this$mapValues$iv = lastMessages;
        boolean $i$f$mapValues = false;
        $this$mapTo$iv$iv = $this$mapValues$iv;
        destination$iv$iv2 = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv2 : $this$associateByTo$iv$iv$iv) {
            void it$iv$iv;
            Map.Entry bl = (Map.Entry)element$iv$iv$iv2;
            Object object2 = destination$iv$iv2;
            boolean bl4 = false;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv2;
            collection = it$iv$iv.getKey();
            object = object2;
            boolean bl5 = false;
            ChatMessage message = (ChatMessage)entry.getValue();
            Object v = lastMessageAuthors.get(message.getAuthor());
            if (v == null) {
                String string = "Required value was null.";
                throw new IllegalStateException(string.toString());
            }
            ChatMessageDto chatMessageDto = ChatMessageDto.Companion.toChatMessageDto$default((ChatMessageDto.Companion)ChatMessageDto.Companion, (ChatMessage)message, (ProfileDto)ProfileDto.Companion.toProfileDto((Profile)v), (String)this.chatLocalizationService.localizeMessage(message, authContext), null, null, (int)12, null);
            object.put(collection, chatMessageDto);
        }
        return destination$iv$iv2;
    }

    private static final ProfileId getAttachmentsForChat$lambda$3(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (ProfileId)$tmp0.invoke(p0);
    }

    private static final ChatMessageAttachmentDto getAttachmentsForChat$lambda$4(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (ChatMessageAttachmentDto)$tmp0.invoke(p0);
    }
}

