/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.admin.mybatis.mapper;

import de.justsoftware.admin.domain.tenant.model.IdentityProviderConfig;
import de.justsoftware.admin.domain.tenant.persistence.TenantIdpConfigRepository;
import de.justsoftware.admin.id.ClientRegistrationId;
import de.justsoftware.admin.id.TenantId;
import de.justsoftware.admin.mybatis.typehandler.IdpClientTargetsTypeHandler;
import java.util.Set;
import kotlin.Metadata;
import org.apache.ibatis.annotations.Arg;
import org.apache.ibatis.annotations.ConstructorArgs;
import org.apache.ibatis.annotations.Delete;
import org.apache.ibatis.annotations.Insert;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.ResultMap;
import org.apache.ibatis.annotations.Results;
import org.apache.ibatis.annotations.Select;
import org.apache.ibatis.annotations.Update;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.security.oauth2.core.AuthorizationGrantType;

@Mapper
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\bg\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H'J\u0012\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0004\u001a\u00020\u0005H'J\u000e\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\tH'J\u0016\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00070\t2\u0006\u0010\u000b\u001a\u00020\fH'J\u0010\u0010\r\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\fH'J\u0018\u0010\u000e\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\fH'J\u0010\u0010\u0010\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u0007H'\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0012\u00c0\u0006\u0001"}, d2={"Lde/justsoftware/admin/mybatis/mapper/TenantIdpConfigMapper;", "Lde/justsoftware/admin/domain/tenant/persistence/TenantIdpConfigRepository;", "deleteOne", "", "id", "Lde/justsoftware/admin/id/ClientRegistrationId;", "findOne", "Lde/justsoftware/admin/domain/tenant/model/IdentityProviderConfig;", "getAll", "", "getAllByTenant", "tenantId", "Lde/justsoftware/admin/id/TenantId;", "removeDefaultIdpForTenant", "setAsDefaultForTenant", "defaultId", "upsertIdpConfig", "identityProviderConfig", "admin-service"})
public interface TenantIdpConfigMapper
extends TenantIdpConfigRepository {
    @ConstructorArgs(value={@Arg(id=true, column="id", javaType=ClientRegistrationId.class), @Arg(column="tenant_id", javaType=TenantId.class), @Arg(column="client_id", javaType=String.class), @Arg(column="client_secret", javaType=String.class), @Arg(column="idp_name", javaType=String.class), @Arg(column="username_attribute", javaType=String.class), @Arg(column="grant_type", javaType=AuthorizationGrantType.class), @Arg(column="scope", javaType=String.class), @Arg(column="issuer_uri", javaType=String.class), @Arg(column="authorization_uri", javaType=String.class), @Arg(column="token_uri", javaType=String.class), @Arg(column="user_info_uri", javaType=String.class), @Arg(column="jwk_set_uri", javaType=String.class), @Arg(column="targets", javaType=Set.class, typeHandler=IdpClientTargetsTypeHandler.class), @Arg(column="automatic_mode", javaType=boolean.class), @Arg(column="default_provider", javaType=boolean.class), @Arg(column="enabled", javaType=boolean.class)})
    @Results(id="IdpMap")
    @Select(value={"SELECT * FROM idp_configuration"})
    @NotNull
    public Set<IdentityProviderConfig> getAll();

    @Insert(value={"\n        <script>\n            <if test=\"_databaseId == 'POSTGRES'\">\n                INSERT INTO idp_configuration\n                    (id, tenant_id, client_id, client_secret, idp_name, username_attribute,\n                    grant_type, scope, issuer_uri, authorization_uri, token_uri, user_info_uri, jwk_set_uri,\n                    targets, automatic_mode, default_provider, enabled)\n                    VALUES (#{id}, #{tenantId}, #{clientId}, #{clientSecret}, #{idpName},\n                    #{userNameAttribute}, #{authorizationGrantType}, #{scope}, #{issuerUri}, #{authorizationUri},\n                    #{tokenUri}, #{userInfoUri}, #{jwkSetUri}, #{targets}, #{automaticMode}, #{defaultProvider},\n                    #{enabled})\n                ON CONFLICT(id)\n                    DO UPDATE SET client_id = #{clientId}, client_secret = #{clientSecret}, idp_name = #{idpName},\n                    username_attribute = #{userNameAttribute}, grant_type = #{authorizationGrantType},\n                    scope = #{scope}, issuer_uri = #{issuerUri}, authorization_uri = #{authorizationUri},\n                    token_uri = #{tokenUri}, user_info_uri = #{userInfoUri}, jwk_set_uri = #{jwkSetUri},\n                    targets= #{targets}, \n                    automatic_mode=#{automaticMode}, default_provider = #{defaultProvider},\n                    enabled = #{enabled}\n            </if>\n\n            <if test=\"_databaseId == 'ORACLE'\">\n                MERGE INTO idp_configuration idp USING\n                    (SELECT #{id} as id from dual) t\n                ON (t.id = idp.id)\n                WHEN MATCHED THEN\n                    UPDATE SET client_id = #{clientId},\n                    client_secret = #{clientSecret},\n                    idp_name = #{idpName}, username_attribute = #{userNameAttribute},\n                    grant_type = #{authorizationGrantType}, scope = #{scope},\n                    issuer_uri = #{issuerUri},\n                    authorization_uri = #{authorizationUri},\n                    token_uri = #{tokenUri}, user_info_uri = #{userInfoUri},\n                    jwk_set_uri = #{jwkSetUri}, targets= #{targets}, automatic_mode=#{automaticMode},\n                    default_provider = #{defaultProvider}, enabled = #{enabled}\n                WHEN NOT MATCHED THEN\n                    INSERT (id, tenant_id, client_id, client_secret, idp_name, username_attribute,\n                    grant_type, scope, issuer_uri, authorization_uri, token_uri, user_info_uri, jwk_set_uri,\n                    targets, automatic_mode, default_provider, enabled)\n                    VALUES (#{id}, #{tenantId}, #{clientId}, #{clientSecret},\n                    #{idpName},\n                    #{userNameAttribute}, #{authorizationGrantType}, #{scope},\n                    #{issuerUri}, #{authorizationUri},\n                    #{tokenUri}, #{userInfoUri}, #{jwkSetUri},\n                    #{targets}, \n                    #{automaticMode}, #{defaultProvider}, #{enabled})\n            </if>\n        </script>\n        "})
    public void upsertIdpConfig(@NotNull IdentityProviderConfig var1);

    @ResultMap(value={"IdpMap"})
    @Select(value={"\n        SELECT * FROM idp_configuration\n        WHERE id = #{id}\n        "})
    @Nullable
    public IdentityProviderConfig findOne(@NotNull ClientRegistrationId var1);

    @ResultMap(value={"IdpMap"})
    @Select(value={"\n        SELECT * FROM idp_configuration\n        WHERE tenant_id = #{tenantId}\n        "})
    @NotNull
    public Set<IdentityProviderConfig> getAllByTenant(@NotNull TenantId var1);

    @Delete(value={"\n        DELETE FROM idp_configuration\n        WHERE id = #{id}\n        "})
    public void deleteOne(@NotNull ClientRegistrationId var1);

    @Update(value={"\n            <script>\n            <if test=\"_databaseId == 'POSTGRES'\">\n                UPDATE idp_configuration\n                SET default_provider=(id=#{defaultId})\n                WHERE tenant_id=#{tenantId}\n            </if>\n\n            <if test=\"_databaseId == 'ORACLE'\">\n                UPDATE idp_configuration config\n                SET config.default_provider=(\n                    case when config.id = #{defaultId}\n                        then 't'\n                    else\n                        'f'\n                    end\n                )\n                WHERE tenant_id=#{tenantId}\n            </if>\n            </script>\n        "})
    public void setAsDefaultForTenant(@NotNull ClientRegistrationId var1, @NotNull TenantId var2);

    @Update(value={"\n            UPDATE idp_configuration\n            SET default_provider='f'\n            WHERE tenant_id=#{tenantId}\n        "})
    public void removeDefaultIdpForTenant(@NotNull TenantId var1);
}

