/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.admin.domain.user.persistence;

import de.justsoftware.admin.domain.user.model.UserGroup;
import de.justsoftware.admin.id.TenantId;
import de.justsoftware.admin.id.UserGroupId;
import de.justsoftware.admin.mybatis.mapper.UserGroupMapper;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.apache.ibatis.annotations.Delete;
import org.apache.ibatis.annotations.Insert;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.stereotype.Repository;

@Repository
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0017\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u0003J\u0013\u0010\u0004\u001a\u00020\u00052\b\b\u0001\u0010\u0006\u001a\u00020\u0007H\u0097\u0001J\u0015\u0010\b\u001a\u0004\u0018\u00010\t2\b\b\u0001\u0010\n\u001a\u00020\u000bH\u0097\u0001J\u0013\u0010\f\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0006\u001a\u00020\u0007H\u0097\u0001J\u000f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\t0\u000eH\u0097\u0001J\u001c\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\t0\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00070\u0012H\u0016J1\u0010\u0013\u001a\u00020\u00052\b\b\u0001\u0010\u0006\u001a\u00020\u00072\b\b\u0001\u0010\u0014\u001a\u00020\u00152\b\b\u0001\u0010\n\u001a\u00020\u000b2\b\b\u0001\u0010\u0016\u001a\u00020\u0017H\u0097\u0001J\u0015\u0010\u0018\u001a\u00020\u00052\u0006\u0010\u0019\u001a\u00020\tH\u0010\u00a2\u0006\u0002\b\u001aR\u000e\u0010\u0002\u001a\u00020\u0001X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lde/justsoftware/admin/domain/user/persistence/UserGroupDao;", "Lde/justsoftware/admin/mybatis/mapper/UserGroupMapper;", "mapper", "(Lde/justsoftware/admin/mybatis/mapper/UserGroupMapper;)V", "delete", "", "id", "Lde/justsoftware/admin/id/UserGroupId;", "findAllTenantUsersGroup", "Lde/justsoftware/admin/domain/user/model/UserGroup;", "tenantId", "Lde/justsoftware/admin/id/TenantId;", "findById", "getAll", "", "getByIds", "", "ids", "", "insertOrUpdate", "name", "", "isAllTenantUsersGroup", "", "save", "userGroup", "save$admin_service", "admin-service"})
public class UserGroupDao
implements UserGroupMapper {
    @NotNull
    private final UserGroupMapper mapper;

    public UserGroupDao(@NotNull UserGroupMapper mapper) {
        Intrinsics.checkNotNullParameter((Object)mapper, (String)"mapper");
        this.mapper = mapper;
    }

    @Delete(value={"\n        DELETE FROM user_group WHERE id = #{id}\n        "})
    public void delete(@Param(value="id") @NotNull UserGroupId id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        this.mapper.delete(id);
    }

    @Select(value={"SELECT * FROM user_group WHERE is_all_tenant_users_group = '1' AND tenant_id = #{tenantId}"})
    @Nullable
    public UserGroup findAllTenantUsersGroup(@Param(value="tenantId") @NotNull TenantId tenantId) {
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        return this.mapper.findAllTenantUsersGroup(tenantId);
    }

    @Select(value={"SELECT * FROM user_group WHERE id = #{id}"})
    @Nullable
    public UserGroup findById(@NotNull UserGroupId id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        return this.mapper.findById(id);
    }

    @Select(value={"SELECT * FROM user_group"})
    @NotNull
    public List<UserGroup> getAll() {
        return this.mapper.getAll();
    }

    @Insert(value={"<script>\n\n        <if test=\"_databaseId == 'POSTGRES'\">\n            INSERT INTO user_group (id, name, tenant_id, is_all_tenant_users_group)\n                VALUES (#{id}, #{name}, #{tenantId}, #{isAllTenantUsersGroup})\n            ON CONFLICT(id)\n                DO UPDATE SET (name, tenant_id, is_all_tenant_users_group)\n                = (#{name}, #{tenantId}, #{isAllTenantUsersGroup})\n        </if>\n\n        <if test=\"_databaseId == 'ORACLE'\">\n            MERGE INTO user_group u USING (SELECT #{id} as id from dual) s ON (s.id = u.id)\n            WHEN MATCHED THEN\n            UPDATE SET\n                name = #{name},\n                tenant_id = #{tenantId},\n                is_all_tenant_users_group = #{isAllTenantUsersGroup}\n            WHEN NOT MATCHED THEN\n            INSERT (id, name, tenant_id, is_all_tenant_users_group)\n            VALUES (#{id}, #{name}, #{tenantId}, #{isAllTenantUsersGroup})\n        </if>\n\n        </script>\n        "})
    public void insertOrUpdate(@Param(value="id") @NotNull UserGroupId id, @Param(value="name") @NotNull String name, @Param(value="tenantId") @NotNull TenantId tenantId, @Param(value="isAllTenantUsersGroup") boolean isAllTenantUsersGroup) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        this.mapper.insertOrUpdate(id, name, tenantId, isAllTenantUsersGroup);
    }

    public void save$admin_service(@NotNull UserGroup userGroup) {
        Intrinsics.checkNotNullParameter((Object)userGroup, (String)"userGroup");
        this.mapper.insertOrUpdate(userGroup.getId(), userGroup.getName(), userGroup.getTenantId(), userGroup.isAllTenantUsersGroup());
    }

    @NotNull
    public Set<UserGroup> getByIds(@NotNull Collection<UserGroupId> ids) {
        Intrinsics.checkNotNullParameter(ids, (String)"ids");
        if (ids.isEmpty()) {
            return SetsKt.emptySet();
        }
        return this.mapper.getByIds(ids);
    }
}

