/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.admin.domain.tenant;

import de.justsoftware.admin.connector.drive.DriveApiConnector;
import de.justsoftware.admin.domain.tenant.model.Tenant;
import de.justsoftware.admin.domain.tenant.model.TenantSettings;
import de.justsoftware.admin.domain.tenant.persistence.TenantRepository;
import de.justsoftware.admin.exceptions.NotFoundException;
import de.justsoftware.admin.id.DocumentId;
import de.justsoftware.admin.id.ProfileId;
import de.justsoftware.admin.id.TenantId;
import de.justsoftware.admin.model.HexColor;
import de.justsoftware.admin.mybatis.mapper.TenantSettingsMapper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.stereotype.Service;

@Service
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0017\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u001a\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\b\b\u0002\u0010\r\u001a\u00020\u000eH\u0016J\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u0012H\u0012J\u0010\u0010\u0013\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0012\u0010\u0014\u001a\u0004\u0018\u00010\n2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u0017\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u000e\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0019H\u0016J\u000e\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\n0\u001bH\u0016J\"\u0010\u001c\u001a\u00020\u00162\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u001a\u0010\u001f\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\u000e2\b\u0010 \u001a\u0004\u0018\u00010\fH\u0016J\u0018\u0010!\u001a\u00020\u00162\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\"\u001a\u00020#H\u0016J\u0018\u0010$\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010%\u001a\u00020\fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lde/justsoftware/admin/domain/tenant/TenantService;", "", "driveApiConnector", "Lde/justsoftware/admin/connector/drive/DriveApiConnector;", "tenantRepo", "Lde/justsoftware/admin/domain/tenant/persistence/TenantRepository;", "tenantSettingsRepo", "Lde/justsoftware/admin/mybatis/mapper/TenantSettingsMapper;", "(Lde/justsoftware/admin/connector/drive/DriveApiConnector;Lde/justsoftware/admin/domain/tenant/persistence/TenantRepository;Lde/justsoftware/admin/mybatis/mapper/TenantSettingsMapper;)V", "createTenant", "Lde/justsoftware/admin/domain/tenant/model/Tenant;", "name", "", "tenantId", "Lde/justsoftware/admin/id/TenantId;", "deleteOldTenantLogoFile", "", "user", "Lde/justsoftware/admin/id/ProfileId;", "deleteTenant", "findTenant", "getSettings", "Lde/justsoftware/admin/domain/tenant/model/TenantSettings;", "getTenant", "getTenantIds", "", "getTenants", "", "setLogo", "logoId", "Lde/justsoftware/admin/id/DocumentId;", "updateDeeplKey", "deeplKey", "updateHighlightColor", "color", "Lde/justsoftware/admin/model/HexColor;", "updateName", "tenantName", "admin-service"})
@SourceDebugExtension(value={"SMAP\nTenantService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TenantService.kt\nde/justsoftware/admin/domain/tenant/TenantService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,131:1\n1549#2:132\n1620#2,3:133\n1#3:136\n*S KotlinDebug\n*F\n+ 1 TenantService.kt\nde/justsoftware/admin/domain/tenant/TenantService\n*L\n76#1:132\n76#1:133,3\n*E\n"})
public class TenantService {
    @NotNull
    private final DriveApiConnector driveApiConnector;
    @NotNull
    private final TenantRepository tenantRepo;
    @NotNull
    private final TenantSettingsMapper tenantSettingsRepo;

    public TenantService(@NotNull DriveApiConnector driveApiConnector, @NotNull TenantRepository tenantRepo, @NotNull TenantSettingsMapper tenantSettingsRepo) {
        Intrinsics.checkNotNullParameter((Object)driveApiConnector, (String)"driveApiConnector");
        Intrinsics.checkNotNullParameter((Object)tenantRepo, (String)"tenantRepo");
        Intrinsics.checkNotNullParameter((Object)tenantSettingsRepo, (String)"tenantSettingsRepo");
        this.driveApiConnector = driveApiConnector;
        this.tenantRepo = tenantRepo;
        this.tenantSettingsRepo = tenantSettingsRepo;
    }

    @NotNull
    public Tenant createTenant(@NotNull String name, @NotNull TenantId tenantId) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        this.tenantRepo.insertOrUpdateTenant(tenantId, ((Object)StringsKt.trim((CharSequence)name)).toString());
        this.tenantSettingsRepo.upsertTenantSettings(new TenantSettings(tenantId, null, null, null, 14, null));
        return this.getTenant(tenantId);
    }

    public static /* synthetic */ Tenant createTenant$default(TenantService tenantService, String string, TenantId tenantId, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: createTenant");
        }
        if ((n & 2) != 0) {
            tenantId = TenantId.Companion.random();
        }
        return tenantService.createTenant(string, tenantId);
    }

    public void deleteTenant(@NotNull TenantId tenantId) {
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        this.tenantRepo.deleteOne(tenantId);
    }

    @NotNull
    public TenantSettings getSettings(@NotNull TenantId tenantId) {
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        TenantSettings tenantSettings = this.tenantSettingsRepo.findOne(tenantId);
        if (tenantSettings == null) {
            throw new NotFoundException("No TenantSettings with tenantId '" + tenantId + "' found!");
        }
        return tenantSettings;
    }

    @Nullable
    public Tenant findTenant(@NotNull TenantId tenantId) {
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        return this.tenantRepo.findOne(tenantId);
    }

    @NotNull
    public Tenant getTenant(@NotNull TenantId tenantId) {
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        Tenant tenant = this.tenantRepo.findOne(tenantId);
        if (tenant == null) {
            throw new NotFoundException("No Tenant with id '" + tenantId + "' found!");
        }
        return tenant;
    }

    @NotNull
    public List<Tenant> getTenants() {
        return this.tenantRepo.getAll();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Set<TenantId> getTenantIds() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.getTenants();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Tenant tenant = (Tenant)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getId());
        }
        return CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
    }

    @NotNull
    public TenantSettings setLogo(@NotNull TenantId tenantId, @Nullable DocumentId logoId, @NotNull ProfileId user) {
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        DocumentId documentId = logoId;
        if (documentId != null) {
            DocumentId it = documentId;
            boolean bl = false;
            this.driveApiConnector.addFile(logoId, tenantId, user);
        }
        this.deleteOldTenantLogoFile(tenantId, user);
        TenantSettings origin = this.getSettings(tenantId);
        TenantSettings update = TenantSettings.copy$default((TenantSettings)origin, null, null, (DocumentId)logoId, null, (int)11, null);
        this.tenantSettingsRepo.upsertTenantSettings(update);
        return this.getSettings(tenantId);
    }

    public void updateDeeplKey(@NotNull TenantId tenantId, @Nullable String deeplKey) {
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        TenantSettings origin = this.getSettings(tenantId);
        TenantSettings update = TenantSettings.copy$default((TenantSettings)origin, null, null, null, (String)deeplKey, (int)7, null);
        this.tenantSettingsRepo.upsertTenantSettings(update);
    }

    @NotNull
    public TenantSettings updateHighlightColor(@NotNull TenantId tenantId, @NotNull HexColor color) {
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        Intrinsics.checkNotNullParameter((Object)color, (String)"color");
        TenantSettings origin = this.getSettings(tenantId);
        TenantSettings update = TenantSettings.copy$default((TenantSettings)origin, null, (HexColor)color, null, null, (int)13, null);
        this.tenantSettingsRepo.upsertTenantSettings(update);
        return this.getSettings(tenantId);
    }

    @NotNull
    public Tenant updateName(@NotNull TenantId tenantId, @NotNull String tenantName) {
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        Intrinsics.checkNotNullParameter((Object)tenantName, (String)"tenantName");
        this.tenantRepo.insertOrUpdateTenant(tenantId, ((Object)StringsKt.trim((CharSequence)tenantName)).toString());
        return this.getTenant(tenantId);
    }

    private void deleteOldTenantLogoFile(TenantId tenantId, ProfileId user) {
        TenantSettings tenantSettings = this.getSettings(tenantId);
        if (tenantSettings.getLogoId() == null) {
            return;
        }
        this.driveApiConnector.deleteFile(tenantSettings.getLogoId(), user);
    }
}

