/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.analytics.function.mapping;

import org.apache.solr.analytics.value.AnalyticsValueStream;
import org.apache.solr.analytics.value.LongValue;
import org.apache.solr.common.SolrException;

class LongFillMissingFunction
extends LongValue.AbstractLongValue {
    private final LongValue baseExpr;
    private final LongValue fillExpr;
    public static final String name = "fill_missing";
    private final String exprStr;
    private final AnalyticsValueStream.ExpressionType funcType;
    boolean exists = false;

    public LongFillMissingFunction(LongValue baseExpr, LongValue fillExpr) throws SolrException {
        this.baseExpr = baseExpr;
        this.fillExpr = fillExpr;
        this.exprStr = AnalyticsValueStream.createExpressionString(name, baseExpr, fillExpr);
        this.funcType = AnalyticsValueStream.determineMappingPhase(this.exprStr, baseExpr, fillExpr);
    }

    @Override
    public long getLong() {
        long value = this.baseExpr.getLong();
        this.exists = true;
        if (!this.baseExpr.exists()) {
            value = this.fillExpr.getLong();
            this.exists = this.fillExpr.exists();
        }
        return value;
    }

    @Override
    public boolean exists() {
        return this.exists;
    }

    @Override
    public String getName() {
        return name;
    }

    @Override
    public String getExpressionStr() {
        return this.exprStr;
    }

    @Override
    public AnalyticsValueStream.ExpressionType getExpressionType() {
        return this.funcType;
    }
}

