/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search.facet;

import java.io.IOException;
import java.util.Arrays;
import org.apache.lucene.util.LongValues;
import org.apache.solr.search.facet.SlotAcc;

interface SweepCountAware {
    public boolean collectBase();

    public int registerCounts(SegCounter var1) throws IOException;

    public static class SegCountPerSeg
    implements SegCounter {
        protected final int[][] allSegCounts;
        private final int[][] activeSegCounts;
        private final boolean[] seen;

        public SegCountPerSeg(int[][] allSegCounts, boolean[] seen, int segMax, int size) {
            this.allSegCounts = allSegCounts;
            this.activeSegCounts = (int[][])Arrays.copyOf(this.allSegCounts, size);
            this.seen = seen;
        }

        @Override
        public final void map(int allIdx, int activeIdx) {
            this.activeSegCounts[activeIdx] = this.allSegCounts[allIdx];
        }

        @Override
        public final void incrementCount(int segOrd, int inc, int maxIdx) {
            this.seen[segOrd] = true;
            int i = maxIdx;
            do {
                int[] nArray = this.activeSegCounts[i];
                int n = segOrd;
                nArray[n] = nArray[n] + inc;
            } while (i-- > 0);
        }

        public void register(SlotAcc.CountSlotAcc[] countAccs, LongValues toGlobal, int maxSegOrd) {
            int segOrd = maxSegOrd;
            int maxIdx = countAccs.length - 1;
            do {
                int slot;
                if (!this.seen[segOrd]) continue;
                int i = maxIdx;
                int n = slot = toGlobal == null ? segOrd : (int)toGlobal.get((long)segOrd);
                do {
                    int inc;
                    if ((inc = this.allSegCounts[i][segOrd]) <= 0) continue;
                    countAccs[i].incrementCount(slot, inc);
                } while (i-- > 0);
            } while (--segOrd >= 0);
        }
    }

    public static class SegCountGlobal
    implements SegCounter {
        private final SlotAcc.CountSlotAcc[] allCounts;
        private final SlotAcc.CountSlotAcc[] activeCounts;

        public SegCountGlobal(SlotAcc.CountSlotAcc[] allCounts) {
            this.allCounts = allCounts;
            this.activeCounts = Arrays.copyOf(allCounts, allCounts.length);
        }

        @Override
        public void map(int allIdx, int activeIdx) {
            this.activeCounts[activeIdx] = this.allCounts[allIdx];
        }

        @Override
        public final void incrementCount(int globalOrd, int inc, int maxIdx) {
            int i = maxIdx;
            do {
                this.activeCounts[i].incrementCount(globalOrd, inc);
            } while (i-- > 0);
        }
    }

    public static interface SegCounter {
        public void map(int var1, int var2);

        public void incrementCount(int var1, int var2, int var3);
    }
}

