/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.people.scheduled;

import de.justsoftware.people.business.usergroup.UserGroupService;
import java.time.Duration;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0001\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0007\u001a\u00020\bH\u0017R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lde/justsoftware/people/scheduled/ScheduledJobs;", "", "userGroupService", "Lde/justsoftware/people/business/usergroup/UserGroupService;", "notYetImportedOlderThan", "Ljava/time/Duration;", "(Lde/justsoftware/people/business/usergroup/UserGroupService;Ljava/time/Duration;)V", "cleanupNotYetImportedGroups", "", "people-api"})
public class ScheduledJobs {
    @NotNull
    private final UserGroupService userGroupService;
    @NotNull
    private final Duration notYetImportedOlderThan;

    public ScheduledJobs(@NotNull UserGroupService userGroupService, @Value(value="${just.people.scheduled.cleanup.notYetImported.olderThan:P7D}") @NotNull Duration notYetImportedOlderThan) {
        Intrinsics.checkNotNullParameter((Object)userGroupService, (String)"userGroupService");
        Intrinsics.checkNotNullParameter((Object)notYetImportedOlderThan, (String)"notYetImportedOlderThan");
        this.userGroupService = userGroupService;
        this.notYetImportedOlderThan = notYetImportedOlderThan;
    }

    @Scheduled(fixedRateString="${just.people.scheduled.cleanup.notYetImported.interval:P1D}")
    public void cleanupNotYetImportedGroups() {
        this.userGroupService.deleteOldNotYetImportedGroups(this.notYetImportedOlderThan);
    }
}

